/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.celeborn.common.network.ssl.ReloadingX509TrustManager;
import org.apache.celeborn.common.network.ssl.SSLUtils;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.shaded.com.google.common.io.Files;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBufAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLFactory {
    private static final Logger logger = LoggerFactory.getLogger(SSLFactory.class);
    private SSLContext jdkSslContext;
    private KeyManager[] keyManagers;
    private TrustManager[] trustManagers;
    private String requestedProtocol;
    private String[] requestedCiphers;
    private static final X509Certificate[] EMPTY_CERT_ARRAY = new X509Certificate[0];

    private SSLFactory(Builder b) {
        this.requestedProtocol = b.requestedProtocol;
        this.requestedCiphers = b.requestedCiphers;
        try {
            this.initJdkSslContext(b);
        }
        catch (Exception e) {
            throw new RuntimeException("SSLFactory creation failed", e);
        }
    }

    private void initJdkSslContext(Builder b) throws IOException, GeneralSecurityException {
        if (b.autoSslEnabled) {
            if (null != b.keyStore || null != b.trustStore) {
                throw new IllegalArgumentException("keystore and truststore cant be configured for auto ssl");
            }
            this.configureAutoSsl(b);
        }
        this.keyManagers = null != b.keyStore ? SSLFactory.keyManagers(b.keyStore, b.keyPassword, b.keyStorePassword) : null;
        this.trustManagers = SSLFactory.trustStoreManagers(b.trustStore, b.trustStorePassword, b.trustStoreReloadingEnabled, b.trustStoreReloadIntervalMs);
        this.jdkSslContext = SSLFactory.createSSLContext(this.requestedProtocol, this.keyManagers, this.trustManagers);
    }

    public List<KeyManager> getKeyManagers() {
        return null != this.keyManagers ? Collections.unmodifiableList(Arrays.asList(this.keyManagers)) : Collections.emptyList();
    }

    public List<TrustManager> getTrustManagers() {
        return null != this.trustManagers ? Collections.unmodifiableList(Arrays.asList(this.trustManagers)) : Collections.emptyList();
    }

    private void configureAutoSsl(Builder b) {
        try {
            SSLUtils.SelfSignedCertificateConfig config = new SSLUtils.SelfSignedCertificateConfig();
            SSLUtils.generateSelfSignedCertificate(config);
            b.keyStore(config.keystoreFile, config.keystorePassword).keyPassword(config.keyPassword);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalStateException("Unable to create self signed certificate for configuring auto ssl", e);
        }
    }

    public boolean hasKeyManagers() {
        return null != this.keyManagers && this.keyManagers.length > 0;
    }

    public void destroy() {
        if (this.trustManagers != null) {
            for (int i = 0; i < this.trustManagers.length; ++i) {
                if (!(this.trustManagers[i] instanceof ReloadingX509TrustManager)) continue;
                try {
                    ((ReloadingX509TrustManager)this.trustManagers[i]).destroy();
                    continue;
                }
                catch (InterruptedException ex) {
                    logger.info("Interrupted while destroying trust manager: {}", (Object)ex, (Object)ex);
                }
            }
            this.trustManagers = null;
        }
        this.keyManagers = null;
        this.jdkSslContext = null;
        this.requestedProtocol = null;
        this.requestedCiphers = null;
    }

    private static SSLContext createSSLContext(String requestedProtocol, KeyManager[] keyManagers, TrustManager[] trustManagers) throws GeneralSecurityException {
        SSLContext sslContext = SSLContext.getInstance(requestedProtocol);
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    public SSLEngine createSSLEngine(boolean isClient, ByteBufAllocator allocator) {
        SSLEngine engine = this.createEngine(isClient, allocator);
        engine.setUseClientMode(isClient);
        engine.setWantClientAuth(true);
        engine.setEnabledProtocols(SSLFactory.enabledProtocols(engine, this.requestedProtocol));
        engine.setEnabledCipherSuites(SSLFactory.enabledCipherSuites(engine, this.requestedCiphers));
        return engine;
    }

    private SSLEngine createEngine(boolean isClient, ByteBufAllocator allocator) {
        return this.jdkSslContext.createSSLEngine();
    }

    private static TrustManager[] credulousTrustStoreManagers() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return EMPTY_CERT_ARRAY;
            }
        }};
    }

    private static TrustManager[] trustStoreManagers(File trustStore, String trustStorePassword, boolean trustStoreReloadingEnabled, int trustStoreReloadIntervalMs) throws IOException, GeneralSecurityException {
        if (trustStore == null || !trustStore.exists()) {
            return SSLFactory.credulousTrustStoreManagers();
        }
        if (trustStoreReloadingEnabled) {
            ReloadingX509TrustManager reloading = new ReloadingX509TrustManager(KeyStore.getDefaultType(), trustStore, trustStorePassword, trustStoreReloadIntervalMs);
            reloading.init();
            return new TrustManager[]{reloading};
        }
        return SSLFactory.defaultTrustManagers(trustStore, trustStorePassword);
    }

    public static TrustManager[] defaultTrustManagers(File trustStore, String trustStorePassword) throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        try (InputStream input = Files.asByteSource(trustStore).openStream();){
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            char[] passwordCharacters = trustStorePassword != null ? trustStorePassword.toCharArray() : null;
            ks.load(input, passwordCharacters);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            TrustManager[] trustManagerArray = tmf.getTrustManagers();
            return trustManagerArray;
        }
    }

    private static KeyManager[] keyManagers(File keyStore, String keyPassword, String keyStorePassword) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException, UnrecoverableKeyException {
        KeyManagerFactory factory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        char[] keyStorePasswordChars = keyStorePassword != null ? keyStorePassword.toCharArray() : null;
        char[] keyPasswordChars = keyPassword != null ? keyPassword.toCharArray() : keyStorePasswordChars;
        factory.init(SSLFactory.loadKeyStore(keyStore, keyStorePasswordChars), keyPasswordChars);
        return factory.getKeyManagers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKeyStore(File keyStore, char[] keyStorePassword) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        if (keyStore == null) {
            throw new KeyStoreException("keyStore cannot be null. Please configure celeborn.ssl.<module>.keyStore");
        }
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream fin = new FileInputStream(keyStore);
        try {
            ks.load(fin, keyStorePassword);
            KeyStore keyStore2 = ks;
            return keyStore2;
        }
        finally {
            JavaUtils.closeQuietly(fin);
        }
    }

    private static String[] enabledProtocols(SSLEngine engine, String requestedProtocol) {
        String[] stringArray;
        String[] supportedProtocols = engine.getSupportedProtocols();
        String[] defaultProtocols = new String[]{"TLSv1.3", "TLSv1.2"};
        if (requestedProtocol == null || requestedProtocol.isEmpty()) {
            stringArray = defaultProtocols;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = requestedProtocol;
        }
        String[] enabledProtocols = stringArray;
        List<String> protocols = SSLFactory.addIfSupported(supportedProtocols, enabledProtocols);
        if (!protocols.isEmpty()) {
            return protocols.toArray(new String[protocols.size()]);
        }
        return supportedProtocols;
    }

    private static String[] enabledCipherSuites(String[] supportedCiphers, String[] defaultCiphers, String[] requestedCiphers) {
        String[] baseCiphers = new String[]{"TLS_CHACHA20_POLY1305_SHA256", "TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384"};
        String[] enabledCiphers = requestedCiphers == null || requestedCiphers.length == 0 ? baseCiphers : requestedCiphers;
        List<String> ciphers = SSLFactory.addIfSupported(supportedCiphers, enabledCiphers);
        if (!ciphers.isEmpty()) {
            return ciphers.toArray(new String[ciphers.size()]);
        }
        return defaultCiphers;
    }

    private static String[] enabledCipherSuites(SSLEngine engine, String[] requestedCiphers) {
        return SSLFactory.enabledCipherSuites(engine.getSupportedCipherSuites(), engine.getEnabledCipherSuites(), requestedCiphers);
    }

    private static List<String> addIfSupported(String[] supported, String ... names) {
        ArrayList<String> enabled = new ArrayList<String>();
        HashSet<String> supportedSet = new HashSet<String>(Arrays.asList(supported));
        for (String n : names) {
            if (!supportedSet.contains(n)) continue;
            enabled.add(n);
        }
        return enabled;
    }

    public static SSLFactory createSslFactory(TransportConf conf) {
        if (conf.sslEnabled()) {
            if (conf.sslEnabledAndKeysAreValid()) {
                return new Builder().requestedProtocol(conf.sslProtocol()).requestedCiphers(conf.sslRequestedCiphers()).autoSslEnabled(conf.autoSslEnabled()).keyStore(conf.sslKeyStore(), conf.sslKeyStorePassword()).trustStore(conf.sslTrustStore(), conf.sslTrustStorePassword(), conf.sslTrustStoreReloadingEnabled(), conf.sslTrustStoreReloadIntervalMs()).build();
            }
            logger.error("SSL encryption enabled but keyStore is not configured for " + conf.getModuleName() + "! Please ensure the configured keys are present.");
            throw new IllegalArgumentException(conf.getModuleName() + " SSL encryption enabled for " + conf.getModuleName() + " but keyStore not configured !");
        }
        return null;
    }

    public static class Builder {
        private String requestedProtocol;
        private String[] requestedCiphers;
        private File keyStore;
        private String keyStorePassword;
        private String keyPassword;
        private File trustStore;
        private String trustStorePassword;
        private boolean trustStoreReloadingEnabled;
        private int trustStoreReloadIntervalMs;
        private boolean autoSslEnabled;

        public Builder requestedProtocol(String requestedProtocol) {
            this.requestedProtocol = requestedProtocol == null ? "TLSv1.3" : requestedProtocol;
            return this;
        }

        public Builder requestedCiphers(String[] requestedCiphers) {
            this.requestedCiphers = requestedCiphers;
            return this;
        }

        public Builder keyStore(File keyStore, String keyStorePassword) {
            this.keyStore = keyStore;
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public Builder keyPassword(String keyPassword) {
            this.keyPassword = keyPassword;
            return this;
        }

        public Builder trustStore(File trustStore, String trustStorePassword, boolean trustStoreReloadingEnabled, int trustStoreReloadIntervalMs) {
            this.trustStore = trustStore;
            this.trustStorePassword = trustStorePassword;
            this.trustStoreReloadingEnabled = trustStoreReloadingEnabled;
            this.trustStoreReloadIntervalMs = trustStoreReloadIntervalMs;
            return this;
        }

        public Builder autoSslEnabled(boolean autoSslEnabled) {
            this.autoSslEnabled = autoSslEnabled;
            return this;
        }

        public SSLFactory build() {
            return new SSLFactory(this);
        }
    }
}

