/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.shuffle.celeborn;

import org.apache.spark.SparkConf;
import org.apache.spark.TaskContext;
import org.apache.spark.scheduler.DAGScheduler;

public class SparkCommonUtils {
    public static void validateAttemptConfig(SparkConf conf) throws IllegalArgumentException {
        int maxStageAttempts = conf.getInt("spark.stage.maxConsecutiveAttempts", DAGScheduler.DEFAULT_MAX_CONSECUTIVE_STAGE_ATTEMPTS());
        int maxTaskAttempts = conf.getInt("spark.task.maxFailures", 4);
        if (maxStageAttempts >= 32768 || maxTaskAttempts >= 65536) {
            throw new IllegalArgumentException("The spark.stage.maxConsecutiveAttempts should be less than 32768 (currently " + maxStageAttempts + ")and spark.task.maxFailures should be less than 65536 (currently " + maxTaskAttempts + ").");
        }
    }

    public static int getEncodedAttemptNumber(TaskContext context) {
        return context.stageAttemptNumber() << 16 | context.attemptNumber();
    }
}

