/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import java.io.File;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.DeviceInfo;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.meta.DiskStatus;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.common.util.JavaUtils;
import org.apache.celeborn.service.deploy.worker.storage.DeviceObserver;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}g\u0001\u0002\u0016,\u0001iB\u0001\"\u0013\u0001\u0003\u0006\u0004%\tA\u0013\u0005\t#\u0002\u0011\t\u0011)A\u0005\u0017\"A!\u000b\u0001B\u0001B\u0003%1\u000b\u0003\u0005X\u0001\t\u0005\t\u0015!\u0003Y\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011\u001d9\u0007A1A\u0005\u0002!Dq!a\u0001\u0001A\u0003%\u0011\u000eC\u0005\u0002\u0006\u0001\u0011\r\u0011\"\u0001\u0002\b!A\u0011q\u0003\u0001!\u0002\u0013\tI\u0001C\u0005\u0002\u001a\u0001\u0011\r\u0011\"\u0001\u0002\u001c!9\u0011Q\u0004\u0001!\u0002\u0013\u0019\b\"CA\u0010\u0001\t\u0007I\u0011AA\u0011\u0011!\ty\u0003\u0001Q\u0001\n\u0005\r\u0002\"CA\u0019\u0001\t\u0007I\u0011AA\u0011\u0011!\t\u0019\u0004\u0001Q\u0001\n\u0005\r\u0002\"CA\u001b\u0001\t\u0007I\u0011AA\u001c\u0011!\ti\u0005\u0001Q\u0001\n\u0005e\u0002\"CA(\u0001\t\u0007I\u0011AA)\u0011!\tI\u0006\u0001Q\u0001\n\u0005M\u0003\"CA.\u0001\t\u0007I\u0011AA/\u0011!\ty\u0006\u0001Q\u0001\n\u0005\u001d\u0003\"CA1\u0001\u0001\u0007I\u0011AA/\u0011%\t\u0019\u0007\u0001a\u0001\n\u0003\t)\u0007\u0003\u0005\u0002r\u0001\u0001\u000b\u0015BA$\u0011%\t\u0019\b\u0001a\u0001\n\u0003\ti\u0006C\u0005\u0002v\u0001\u0001\r\u0011\"\u0001\u0002x!A\u00111\u0010\u0001!B\u0013\t9\u0005C\u0005\u0002~\u0001\u0001\r\u0011\"\u0001\u0002^!I\u0011q\u0010\u0001A\u0002\u0013\u0005\u0011\u0011\u0011\u0005\t\u0003\u000b\u0003\u0001\u0015)\u0003\u0002H!I\u0011q\u0011\u0001A\u0002\u0013\u0005\u0011Q\f\u0005\n\u0003\u0013\u0003\u0001\u0019!C\u0001\u0003\u0017C\u0001\"a$\u0001A\u0003&\u0011q\t\u0005\b\u0003#\u0003A\u0011AAJ\u0011\u001d\tI\n\u0001C\u0001\u00037Cq!a(\u0001\t\u0003\t\t\u000bC\u0004\u0002<\u0002!\t!!0\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002F\"9\u00111\u001a\u0001\u0005\u0002\u00055\u0007bBAi\u0001\u0011\u0005\u00111\u001b\u0005\b\u00037\u0004A\u0011IAo\u00059y%m]3sm\u0016$G)\u001a<jG\u0016T!\u0001L\u0017\u0002\u000fM$xN]1hK*\u0011afL\u0001\u0007o>\u00148.\u001a:\u000b\u0005A\n\u0014A\u00023fa2|\u0017P\u0003\u00023g\u000591/\u001a:wS\u000e,'B\u0001\u001b6\u0003!\u0019W\r\\3c_Jt'B\u0001\u001c8\u0003\u0019\t\u0007/Y2iK*\t\u0001(A\u0002pe\u001e\u001c\u0001aE\u0002\u0001w\u0005\u0003\"\u0001P \u000e\u0003uR\u0011AP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0001v\u0012a!\u00118z%\u00164\u0007C\u0001\"H\u001b\u0005\u0019%B\u0001#F\u0003!Ig\u000e^3s]\u0006d'B\u0001$4\u0003\u0019\u0019w.\\7p]&\u0011\u0001j\u0011\u0002\b\u0019><w-\u001b8h\u0003)!WM^5dK&sgm\\\u000b\u0002\u0017B\u0011AjT\u0007\u0002\u001b*\u0011a*R\u0001\u0005[\u0016$\u0018-\u0003\u0002Q\u001b\nQA)\u001a<jG\u0016LeNZ8\u0002\u0017\u0011,g/[2f\u0013:4w\u000eI\u0001\u0005G>tg\r\u0005\u0002U+6\tQ)\u0003\u0002W\u000b\na1)\u001a7fE>\u0014hnQ8oM\u0006aqo\u001c:lKJ\u001cv.\u001e:dKB\u0011\u0011LX\u0007\u00025*\u00111\fX\u0001\u0007g>,(oY3\u000b\u0005u+\u0015aB7fiJL7m]\u0005\u0003?j\u0013a\"\u00112tiJ\f7\r^*pkJ\u001cW-\u0001\u0004=S:LGO\u0010\u000b\u0005E\u0012,g\r\u0005\u0002d\u00015\t1\u0006C\u0003J\u000b\u0001\u00071\nC\u0003S\u000b\u0001\u00071\u000bC\u0003X\u000b\u0001\u0007\u0001,A\u0005eSN\\\u0017J\u001c4pgV\t\u0011\u000e\u0005\u0003kcNtX\"A6\u000b\u00051l\u0017AC2p]\u000e,(O]3oi*\u0011an\\\u0001\u0005kRLGNC\u0001q\u0003\u0011Q\u0017M^1\n\u0005I\\'!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0011Ao\u001f\b\u0003kf\u0004\"A^\u001f\u000e\u0003]T!\u0001_\u001d\u0002\rq\u0012xn\u001c;?\u0013\tQX(\u0001\u0004Qe\u0016$WMZ\u0005\u0003yv\u0014aa\u0015;sS:<'B\u0001>>!\tau0C\u0002\u0002\u00025\u0013\u0001\u0002R5tW&sgm\\\u0001\u000bI&\u001c8.\u00138g_N\u0004\u0013!C8cg\u0016\u0014h/\u001a:t+\t\tI\u0001\u0005\u0004\u0002\f\u00055\u0011\u0011C\u0007\u0002[&\u0019\u0011qB7\u0003\u0007M+G\u000fE\u0002d\u0003'I1!!\u0006,\u00059!UM^5dK>\u00137/\u001a:wKJ\f!b\u001c2tKJ4XM]:!\u0003-\u0019\u0018p\u001d\"m_\u000e\\G)\u001b:\u0016\u0003M\fAb]=t\u00052|7m\u001b#je\u0002\n\u0001b\u001d;bi\u001aKG.Z\u000b\u0003\u0003G\u0001B!!\n\u0002,5\u0011\u0011q\u0005\u0006\u0004\u0003Sy\u0017AA5p\u0013\u0011\ti#a\n\u0003\t\u0019KG.Z\u0001\ngR\fGOR5mK\u0002\nA\"\u001b8GY&<\u0007\u000e\u001e$jY\u0016\fQ\"\u001b8GY&<\u0007\u000e\u001e$jY\u0016\u0004\u0013!\u00058p]\u000e\u0013\u0018\u000e^5dC2,%O]8sgV\u0011\u0011\u0011\b\t\u0007UF\fY$!\u0011\u0011\u00071\u000bi$C\u0002\u0002@5\u0013!\u0002R5tWN#\u0018\r^;t!\u0019\tY!a\u0011\u0002H%\u0019\u0011QI7\u0003\t1K7\u000f\u001e\t\u0004y\u0005%\u0013bAA&{\t!Aj\u001c8h\u0003IqwN\\\"sSRL7-\u00197FeJ|'o\u001d\u0011\u0002)9|G/\u001b4z\u000bJ\u0014xN\u001d+ie\u0016\u001c\bn\u001c7e+\t\t\u0019\u0006E\u0002=\u0003+J1!a\u0016>\u0005\rIe\u000e^\u0001\u0016]>$\u0018NZ=FeJ|'\u000f\u00165sKNDw\u000e\u001c3!\u0003aqw\u000e^5gs\u0016\u0013(o\u001c:FqBL'/\u001a+j[\u0016|W\u000f^\u000b\u0003\u0003\u000f\n\u0011D\\8uS\u001aLXI\u001d:pe\u0016C\b/\u001b:f)&lWm\\;uA\u0005\u0001B.Y:u%\u0016\fGmQ8na2,G/Z\u0001\u0015Y\u0006\u001cHOU3bI\u000e{W\u000e\u001d7fi\u0016|F%Z9\u0015\t\u0005\u001d\u0014Q\u000e\t\u0004y\u0005%\u0014bAA6{\t!QK\\5u\u0011%\tygFA\u0001\u0002\u0004\t9%A\u0002yIE\n\u0011\u0003\\1tiJ+\u0017\rZ\"p[BdW\r^3!\u0003Ea\u0017m\u001d;Xe&$XmQ8na2,G/Z\u0001\u0016Y\u0006\u001cHo\u0016:ji\u0016\u001cu.\u001c9mKR,w\fJ3r)\u0011\t9'!\u001f\t\u0013\u0005=$$!AA\u0002\u0005\u001d\u0013A\u00057bgR<&/\u001b;f\u0007>l\u0007\u000f\\3uK\u0002\n\u0001\u0003\\1tiJ+\u0017\rZ%o\r2Lw\r\u001b;\u0002)1\f7\u000f\u001e*fC\u0012LeN\u00127jO\"$x\fJ3r)\u0011\t9'a!\t\u0013\u0005=T$!AA\u0002\u0005\u001d\u0013!\u00057bgR\u0014V-\u00193J]\u001ac\u0017n\u001a5uA\u0005\tB.Y:u/JLG/Z%o\r2Lw\r\u001b;\u0002+1\f7\u000f^,sSR,\u0017J\u001c$mS\u001eDGo\u0018\u0013fcR!\u0011qMAG\u0011%\ty\u0007IA\u0001\u0002\u0004\t9%\u0001\nmCN$xK]5uK&sg\t\\5hQR\u0004\u0013aC1eI>\u00137/\u001a:wKJ$B!a\u001a\u0002\u0016\"9\u0011q\u0013\u0012A\u0002\u0005E\u0011\u0001C8cg\u0016\u0014h/\u001a:\u0002\u001dI,Wn\u001c<f\u001f\n\u001cXM\u001d<feR!\u0011qMAO\u0011\u001d\t9j\ta\u0001\u0003#\taC\\8uS\u001aLxJY:feZ,'o](o\u000bJ\u0014xN\u001d\u000b\u0007\u0003O\n\u0019+a.\t\u000f\u0005\u0015F\u00051\u0001\u0002(\u0006YQn\\;oiB{\u0017N\u001c;t!\u0015\tI+a-t\u001d\u0011\tY+a,\u000f\u0007Y\fi+C\u0001?\u0013\r\t\t,P\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t)%!.\u000b\u0007\u0005EV\bC\u0004\u0002:\u0012\u0002\r!a\u000f\u0002\u0015\u0011L7o[*uCR,8/A\u0011o_RLg-_(cg\u0016\u0014h/\u001a:t\u001f:tuN\\\"sSRL7-\u00197FeJ|'\u000f\u0006\u0004\u0002h\u0005}\u0016\u0011\u0019\u0005\b\u0003K+\u0003\u0019AAT\u0011\u001d\tI,\na\u0001\u0003w\t\u0001D\\8uS\u001aLxJY:feZ,'o](o\u0011\u0016\fG\u000e\u001e5z)\u0011\t9'a2\t\r\u0005%g\u00051\u0001t\u0003)iw.\u001e8u!>Lg\u000e^\u0001\u001f]>$\u0018NZ=PEN,'O^3sg>s\u0007*[4i\t&\u001c8.V:bO\u0016$B!a\u001a\u0002P\"1\u0011\u0011Z\u0014A\u0002M\fa![8IC:<GCAAk!\ra\u0014q[\u0005\u0004\u00033l$a\u0002\"p_2,\u0017M\\\u0001\ti>\u001cFO]5oOR\t1\u000f")
public class ObservedDevice
implements Logging {
    private final DeviceInfo deviceInfo;
    private final AbstractSource workerSource;
    private final ConcurrentHashMap<String, DiskInfo> diskInfos;
    private final Set<DeviceObserver> observers;
    private final String sysBlockDir;
    private final File statFile;
    private final File inFlightFile;
    private final ConcurrentHashMap<DiskStatus, java.util.List<Object>> nonCriticalErrors;
    private final int notifyErrorThreshold;
    private final long notifyErrorExpireTimeout;
    private long lastReadComplete;
    private long lastWriteComplete;
    private long lastReadInFlight;
    private long lastWriteInFlight;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        ObservedDevice observedDevice = this;
        synchronized (observedDevice) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public DeviceInfo deviceInfo() {
        return this.deviceInfo;
    }

    public ConcurrentHashMap<String, DiskInfo> diskInfos() {
        return this.diskInfos;
    }

    public Set<DeviceObserver> observers() {
        return this.observers;
    }

    public String sysBlockDir() {
        return this.sysBlockDir;
    }

    public File statFile() {
        return this.statFile;
    }

    public File inFlightFile() {
        return this.inFlightFile;
    }

    public ConcurrentHashMap<DiskStatus, java.util.List<Object>> nonCriticalErrors() {
        return this.nonCriticalErrors;
    }

    public int notifyErrorThreshold() {
        return this.notifyErrorThreshold;
    }

    public long notifyErrorExpireTimeout() {
        return this.notifyErrorExpireTimeout;
    }

    public long lastReadComplete() {
        return this.lastReadComplete;
    }

    public void lastReadComplete_$eq(long x$1) {
        this.lastReadComplete = x$1;
    }

    public long lastWriteComplete() {
        return this.lastWriteComplete;
    }

    public void lastWriteComplete_$eq(long x$1) {
        this.lastWriteComplete = x$1;
    }

    public long lastReadInFlight() {
        return this.lastReadInFlight;
    }

    public void lastReadInFlight_$eq(long x$1) {
        this.lastReadInFlight = x$1;
    }

    public long lastWriteInFlight() {
        return this.lastWriteInFlight;
    }

    public void lastWriteInFlight_$eq(long x$1) {
        this.lastWriteInFlight = x$1;
    }

    public void addObserver(DeviceObserver observer) {
        this.observers().add(observer);
    }

    public void removeObserver(DeviceObserver observer) {
        this.observers().remove(observer);
    }

    public synchronized void notifyObserversOnError(List<String> mountPoints, DiskStatus diskStatus) {
        mountPoints.foreach((Function1 & Serializable & scala.Serializable)mountPoint -> this.diskInfos().get(mountPoint).setStatus(diskStatus));
        HashSet<DeviceObserver> tmpObservers = new HashSet<DeviceObserver>(this.observers());
        tmpObservers.forEach(ob -> mountPoints.foreach((Function1 & Serializable & scala.Serializable)mountPoint -> {
            ob.notifyError(mountPoint, diskStatus);
            return BoxedUnit.UNIT;
        }));
    }

    public synchronized void notifyObserversOnNonCriticalError(List<String> mountPoints, DiskStatus diskStatus) {
        ((java.util.List)this.nonCriticalErrors().computeIfAbsent(diskStatus, x$1 -> {
            void var3_3;
            CopyOnWriteArrayList list = new CopyOnWriteArrayList();
            $this.workerSource.addGauge(new StringBuilder(14).append("Device_").append(this.deviceInfo().name()).append("_").append(diskStatus.toMetric()).append("_Count").toString(), $this.workerSource.addGauge$default$2(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> list.size());
            return var3_3;
        })).add(BoxesRunTime.boxToLong((long)System.currentTimeMillis()));
        mountPoints.foreach((Function1 & Serializable & scala.Serializable)mountPoint -> this.diskInfos().get(mountPoint).setStatus(diskStatus));
        HashSet<DeviceObserver> tmpObservers = new HashSet<DeviceObserver>(this.observers());
        tmpObservers.forEach(ob -> mountPoints.foreach((Function1 & Serializable & scala.Serializable)mountPoint -> {
            ob.notifyNonCriticalError(mountPoint, diskStatus);
            return BoxedUnit.UNIT;
        }));
    }

    public synchronized void notifyObserversOnHealthy(String mountPoint) {
        this.diskInfos().get(mountPoint).setStatus(DiskStatus.HEALTHY);
        HashSet<DeviceObserver> tmpObservers = new HashSet<DeviceObserver>(this.observers());
        tmpObservers.forEach(ob -> ob.notifyHealthy(mountPoint));
    }

    public synchronized void notifyObserversOnHighDiskUsage(String mountPoint) {
        this.diskInfos().get(mountPoint).setStatus(DiskStatus.HIGH_DISK_USAGE);
        HashSet<DeviceObserver> tmpObservers = new HashSet<DeviceObserver>(this.observers());
        tmpObservers.forEach(ob -> ob.notifyHighDiskUsage(mountPoint));
    }

    public boolean ioHang() {
        boolean bl;
        block12: {
            if (!this.deviceInfo().deviceStatAvailable()) {
                bl = false;
            } else {
                BufferedSource statsSource = null;
                BufferedSource inflightSource = null;
                try {
                    try {
                        boolean isWriteHang;
                        statsSource = Source$.MODULE$.fromFile(this.statFile(), Codec$.MODULE$.fallbackSystemCodec());
                        inflightSource = Source$.MODULE$.fromFile(this.inFlightFile(), Codec$.MODULE$.fallbackSystemCodec());
                        String[] stats = ((String)statsSource.getLines().next()).trim().split("[ \t]+", -1);
                        String[] inflight = ((String)inflightSource.getLines().next()).trim().split("[ \t]+", -1);
                        long readComplete = new StringOps(Predef$.MODULE$.augmentString(stats[0])).toLong();
                        long writeComplete = new StringOps(Predef$.MODULE$.augmentString(stats[4])).toLong();
                        long readInflight = new StringOps(Predef$.MODULE$.augmentString(inflight[0])).toLong();
                        long writeInflight = new StringOps(Predef$.MODULE$.augmentString(inflight[1])).toLong();
                        if (this.lastReadComplete() == -1L) {
                            this.lastReadComplete_$eq(readComplete);
                            this.lastWriteComplete_$eq(writeComplete);
                            this.lastReadInFlight_$eq(readInflight);
                            this.lastWriteInFlight_$eq(writeInflight);
                            bl = false;
                            break block12;
                        }
                        boolean isReadHang = this.lastReadComplete() == readComplete && readInflight >= this.lastReadInFlight() && this.lastReadInFlight() > 0L;
                        boolean bl2 = isWriteHang = this.lastWriteComplete() == writeComplete && writeInflight >= this.lastWriteInFlight() && this.lastWriteInFlight() > 0L;
                        if (isReadHang || isWriteHang) {
                            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Result of DeviceInfo.checkIoHang, DeviceName: ").append(this.deviceInfo().name()).append("(").append(readComplete).append(",").append(writeComplete).append(",").append(readInflight).append(",").append(writeInflight).append(")\t").append("(").append(this.lastReadComplete()).append(",").append(this.lastWriteComplete()).append(",").append(this.lastReadInFlight()).append(",").append(this.lastWriteInFlight()).append(")\t").append("Observer cnt: ").append(this.observers().size()).toString());
                            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("IO Hang! ReadHang: ").append(isReadHang).append(", WriteHang: ").append(isWriteHang).toString());
                        }
                        this.lastReadComplete_$eq(readComplete);
                        this.lastWriteComplete_$eq(writeComplete);
                        this.lastReadInFlight_$eq(readInflight);
                        this.lastWriteInFlight_$eq(writeInflight);
                        if (isReadHang || isWriteHang) {
                            bl = true;
                            break block12;
                        }
                        bl = false;
                    }
                    catch (Exception e) {
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Encounter Exception when check IO hang for device ").append(this.deviceInfo().name()).toString(), e);
                        bl = false;
                    }
                }
                finally {
                    if (statsSource != null) {
                        statsSource.close();
                    }
                    if (inflightSource != null) {
                        inflightSource.close();
                    }
                }
            }
        }
        return bl;
    }

    public String toString() {
        return new StringBuilder(26).append("DeviceName: ").append(this.deviceInfo().name()).append("\tMount Infos: ").append(((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.diskInfos().values()).asScala()).mkString("\n")).toString();
    }

    public ObservedDevice(DeviceInfo deviceInfo, CelebornConf conf, AbstractSource workerSource) {
        this.deviceInfo = deviceInfo;
        this.workerSource = workerSource;
        Logging.$init$((Logging)this);
        this.diskInfos = JavaUtils.newConcurrentHashMap();
        deviceInfo.diskInfos().foreach((Function1 & Serializable & scala.Serializable)diskInfo -> this.diskInfos().put(diskInfo.mountPoint(), (DiskInfo)diskInfo));
        this.observers = ConcurrentHashMap.newKeySet();
        this.sysBlockDir = conf.workerDiskMonitorSysBlockDir();
        this.statFile = new File(new StringBuilder(6).append(this.sysBlockDir()).append("/").append(deviceInfo.name()).append("/stat").toString());
        this.inFlightFile = new File(new StringBuilder(10).append(this.sysBlockDir()).append("/").append(deviceInfo.name()).append("/inflight").toString());
        this.nonCriticalErrors = JavaUtils.newConcurrentHashMap();
        this.notifyErrorThreshold = conf.workerDiskMonitorNotifyErrorThreshold();
        this.notifyErrorExpireTimeout = conf.workerDiskMonitorNotifyErrorExpireTimeout();
        this.lastReadComplete = -1L;
        this.lastWriteComplete = -1L;
        this.lastReadInFlight = -1L;
        this.lastWriteInFlight = -1L;
    }
}

