/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker;

import com.google.common.base.Throwables;
import com.google.protobuf.GeneratedMessageV3;
import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.CelebornConf$;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.meta.FileManagedBuffers;
import org.apache.celeborn.common.meta.TimeWindow;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;
import org.apache.celeborn.common.network.buffer.NioManagedBuffer;
import org.apache.celeborn.common.network.client.RpcResponseCallback;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.protocol.BufferStreamEnd;
import org.apache.celeborn.common.network.protocol.ChunkFetchFailure;
import org.apache.celeborn.common.network.protocol.ChunkFetchRequest;
import org.apache.celeborn.common.network.protocol.ChunkFetchSuccess;
import org.apache.celeborn.common.network.protocol.Message;
import org.apache.celeborn.common.network.protocol.OpenStream;
import org.apache.celeborn.common.network.protocol.OpenStreamWithCredit;
import org.apache.celeborn.common.network.protocol.ReadAddCredit;
import org.apache.celeborn.common.network.protocol.RequestMessage;
import org.apache.celeborn.common.network.protocol.RpcRequest;
import org.apache.celeborn.common.network.protocol.RpcResponse;
import org.apache.celeborn.common.network.protocol.StreamChunkSlice;
import org.apache.celeborn.common.network.protocol.StreamHandle;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.network.server.BaseMessageHandler;
import org.apache.celeborn.common.network.util.NettyUtils;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.protocol.MessageType;
import org.apache.celeborn.common.protocol.PartitionType;
import org.apache.celeborn.common.protocol.PbBufferStreamEnd;
import org.apache.celeborn.common.protocol.PbChunkFetchRequest;
import org.apache.celeborn.common.protocol.PbOpenStream;
import org.apache.celeborn.common.protocol.PbReadAddCredit;
import org.apache.celeborn.common.protocol.PbStreamChunkSlice;
import org.apache.celeborn.common.protocol.PbStreamHandler;
import org.apache.celeborn.common.protocol.StreamType;
import org.apache.celeborn.common.util.ExceptionUtils;
import org.apache.celeborn.common.util.Utils$;
import org.apache.celeborn.service.deploy.worker.Worker;
import org.apache.celeborn.service.deploy.worker.WorkerSource;
import org.apache.celeborn.service.deploy.worker.WorkerSource$;
import org.apache.celeborn.service.deploy.worker.storage.ChunkStreamManager;
import org.apache.celeborn.service.deploy.worker.storage.CreditStreamManager;
import org.apache.celeborn.service.deploy.worker.storage.PartitionFilesSorter;
import org.apache.celeborn.service.deploy.worker.storage.StorageManager;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\rEa\u0001\u0002\u00180\u0001qB\u0001\"\u0014\u0001\u0003\u0006\u0004%\tA\u0014\u0005\t'\u0002\u0011\t\u0011)A\u0005\u001f\"AA\u000b\u0001BC\u0002\u0013\u0005Q\u000b\u0003\u0005]\u0001\t\u0005\t\u0015!\u0003W\u0011!i\u0006A!b\u0001\n\u0003q\u0006\u0002C2\u0001\u0005\u0003\u0005\u000b\u0011B0\t\u000b\u0011\u0004A\u0011A3\t\u000f)\u0004!\u0019!C\u0001W\"1!\u000f\u0001Q\u0001\n1Dqa\u001d\u0001C\u0002\u0013\u0005A\u000f\u0003\u0004\u007f\u0001\u0001\u0006I!\u001e\u0005\t\u007f\u0002\u0011\r\u0011\"\u0001\u0002\u0002!A\u0011\u0011\u0002\u0001!\u0002\u0013\t\u0019\u0001C\u0006\u0002\f\u0001\u0001\r\u00111A\u0005\u0002\u00055\u0001bCA\u000b\u0001\u0001\u0007\t\u0019!C\u0001\u0003/A1\"a\t\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0010!Y\u0011Q\u0005\u0001A\u0002\u0003\u0007I\u0011AA\u0014\u0011-\ty\u0003\u0001a\u0001\u0002\u0004%\t!!\r\t\u0017\u0005U\u0002\u00011A\u0001B\u0003&\u0011\u0011\u0006\u0005\n\u0003o\u0001\u0001\u0019!C\u0001\u0003sA\u0011\"a\u0015\u0001\u0001\u0004%\t!!\u0016\t\u0011\u0005e\u0003\u0001)Q\u0005\u0003wAq!a\u0017\u0001\t\u0003\ti\u0006C\u0004\u0002h\u0001!\t!!\u001b\t\u000f\u0005U\u0005\u0001\"\u0011\u0002\u0018\"9\u0011Q\u0013\u0001\u0005B\u0005\u0005\u0007bBAd\u0001\u0011%\u0011\u0011\u001a\u0005\b\u00033\u0004A\u0011BAn\u0011\u001d\t\u0019\u000f\u0001C\u0005\u0003KD\u0011Ba\u0005\u0001#\u0003%IA!\u0006\t\u000f\t-\u0002\u0001\"\u0003\u0003.!I!\u0011\f\u0001\u0012\u0002\u0013%!1\f\u0005\n\u0005?\u0002\u0011\u0013!C\u0005\u0005CBqA!\u001a\u0001\t\u0013\u00119\u0007C\u0004\u0003\u0006\u0002!IAa\"\t\u000f\tM\u0005\u0001\"\u0001\u0003\u0016\"9!1\u0013\u0001\u0005\u0002\tm\u0005b\u0002BX\u0001\u0011\u0005!\u0011\u0017\u0005\b\u0005w\u0003A\u0011\u0001B_\u0011\u001d\u0011y\r\u0001C!\u0005#DqAa5\u0001\t\u0003\u0012)\u000eC\u0004\u0003Z\u0002!\tEa7\t\u000f\t}\u0007\u0001\"\u0011\u0003b\"9!1 \u0001\u0005\u0002\tu\bbBB\u0005\u0001\u0011\u000511\u0002\u0002\r\r\u0016$8\r\u001b%b]\u0012dWM\u001d\u0006\u0003aE\naa^8sW\u0016\u0014(B\u0001\u001a4\u0003\u0019!W\r\u001d7ps*\u0011A'N\u0001\bg\u0016\u0014h/[2f\u0015\t1t'\u0001\u0005dK2,'m\u001c:o\u0015\tA\u0014(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002u\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!P$\u0011\u0005y*U\"A \u000b\u0005\u0001\u000b\u0015AB:feZ,'O\u0003\u0002C\u0007\u00069a.\u001a;x_J\\'B\u0001#6\u0003\u0019\u0019w.\\7p]&\u0011ai\u0010\u0002\u0013\u0005\u0006\u001cX-T3tg\u0006<W\rS1oI2,'\u000f\u0005\u0002I\u00176\t\u0011J\u0003\u0002K\u0007\u0006A\u0011N\u001c;fe:\fG.\u0003\u0002M\u0013\n9Aj\\4hS:<\u0017\u0001B2p]\u001a,\u0012a\u0014\t\u0003!Fk\u0011aQ\u0005\u0003%\u000e\u0013AbQ3mK\n|'O\\\"p]\u001a\fQaY8oM\u0002\nQ\u0002\u001e:b]N\u0004xN\u001d;D_:4W#\u0001,\u0011\u0005]SV\"\u0001-\u000b\u0005e\u000b\u0015\u0001B;uS2L!a\u0017-\u0003\u001bQ\u0013\u0018M\\:q_J$8i\u001c8g\u00039!(/\u00198ta>\u0014HoQ8oM\u0002\nAb^8sW\u0016\u00148k\\;sG\u0016,\u0012a\u0018\t\u0003A\u0006l\u0011aL\u0005\u0003E>\u0012AbV8sW\u0016\u00148k\\;sG\u0016\fQb^8sW\u0016\u00148k\\;sG\u0016\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003gO\"L\u0007C\u00011\u0001\u0011\u0015iu\u00011\u0001P\u0011\u0015!v\u00011\u0001W\u0011\u0015iv\u00011\u0001`\u0003I\u0019\u0007.\u001e8l'R\u0014X-Y7NC:\fw-\u001a:\u0016\u00031\u0004\"!\u001c9\u000e\u00039T!a\\\u0018\u0002\u000fM$xN]1hK&\u0011\u0011O\u001c\u0002\u0013\u0007\",hn[*ue\u0016\fW.T1oC\u001e,'/A\ndQVt7n\u0015;sK\u0006lW*\u00198bO\u0016\u0014\b%\u0001\rnCb\u001c\u0005.\u001e8l\u0005\u0016Lgn\u001a+sC:\u001ch-\u001a:sK\u0012,\u0012!\u001e\t\u0004mf\\X\"A<\u000b\u0003a\fQa]2bY\u0006L!A_<\u0003\r=\u0003H/[8o!\t1H0\u0003\u0002~o\n!Aj\u001c8h\u0003ei\u0017\r_\"ik:\\')Z5oOR\u0013\u0018M\\:gKJ\u0014X\r\u001a\u0011\u0002'\r\u0014X\rZ5u'R\u0014X-Y7NC:\fw-\u001a:\u0016\u0005\u0005\r\u0001cA7\u0002\u0006%\u0019\u0011q\u00018\u0003'\r\u0013X\rZ5u'R\u0014X-Y7NC:\fw-\u001a:\u0002)\r\u0014X\rZ5u'R\u0014X-Y7NC:\fw-\u001a:!\u00039\u0019Ho\u001c:bO\u0016l\u0015M\\1hKJ,\"!a\u0004\u0011\u00075\f\t\"C\u0002\u0002\u00149\u0014ab\u0015;pe\u0006<W-T1oC\u001e,'/\u0001\nti>\u0014\u0018mZ3NC:\fw-\u001a:`I\u0015\fH\u0003BA\r\u0003?\u00012A^A\u000e\u0013\r\tib\u001e\u0002\u0005+:LG\u000fC\u0005\u0002\"=\t\t\u00111\u0001\u0002\u0010\u0005\u0019\u0001\u0010J\u0019\u0002\u001fM$xN]1hK6\u000bg.Y4fe\u0002\n\u0001\u0003]1si&$\u0018n\u001c8t'>\u0014H/\u001a:\u0016\u0005\u0005%\u0002cA7\u0002,%\u0019\u0011Q\u00068\u0003)A\u000b'\u000f^5uS>tg)\u001b7fgN{'\u000f^3s\u0003Q\u0001\u0018M\u001d;ji&|gn]*peR,'o\u0018\u0013fcR!\u0011\u0011DA\u001a\u0011%\t\tCEA\u0001\u0002\u0004\tI#A\tqCJ$\u0018\u000e^5p]N\u001cvN\u001d;fe\u0002\n!B]3hSN$XM]3e+\t\tY\u0004\u0005\u0003ws\u0006u\u0002\u0003BA \u0003\u001fj!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\u0007CR|W.[2\u000b\t\u0005\u001d\u0013\u0011J\u0001\u000bG>t7-\u001e:sK:$(bA-\u0002L)\u0011\u0011QJ\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002R\u0005\u0005#!D!u_6L7MQ8pY\u0016\fg.\u0001\bsK\u001eL7\u000f^3sK\u0012|F%Z9\u0015\t\u0005e\u0011q\u000b\u0005\n\u0003C)\u0012\u0011!a\u0001\u0003w\t1B]3hSN$XM]3eA\u0005!\u0011N\\5u)\u0011\tI\"a\u0018\t\rA:\u0002\u0019AA1!\r\u0001\u00171M\u0005\u0004\u0003Kz#AB,pe.,'/\u0001\bhKR\u0014\u0016m\u001e$jY\u0016LeNZ8\u0015\r\u0005-\u0014qOAI!\u0011\ti'a\u001d\u000e\u0005\u0005=$bAA9\u0007\u0006!Q.\u001a;b\u0013\u0011\t)(a\u001c\u0003\u0011\u0019KG.Z%oM>Dq!!\u001f\u0019\u0001\u0004\tY(\u0001\u0006tQV4g\r\\3LKf\u0004B!! \u0002\f:!\u0011qPAD!\r\t\ti^\u0007\u0003\u0003\u0007S1!!\"<\u0003\u0019a$o\\8u}%\u0019\u0011\u0011R<\u0002\rA\u0013X\rZ3g\u0013\u0011\ti)a$\u0003\rM#(/\u001b8h\u0015\r\tIi\u001e\u0005\b\u0003'C\u0002\u0019AA>\u0003!1\u0017\u000e\\3OC6,\u0017a\u0002:fG\u0016Lg/\u001a\u000b\t\u00033\tI*a*\u00028\"9\u00111T\rA\u0002\u0005u\u0015AB2mS\u0016tG\u000f\u0005\u0003\u0002 \u0006\rVBAAQ\u0015\r\tY*Q\u0005\u0005\u0003K\u000b\tKA\bUe\u0006t7\u000f]8si\u000ec\u0017.\u001a8u\u0011\u001d\tI+\u0007a\u0001\u0003W\u000b1!\\:h!\u0011\ti+a-\u000e\u0005\u0005=&bAAY\u0003\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u00026\u0006=&A\u0004*fcV,7\u000f^'fgN\fw-\u001a\u0005\b\u0003sK\u0002\u0019AA^\u0003!\u0019\u0017\r\u001c7cC\u000e\\\u0007\u0003BAP\u0003{KA!a0\u0002\"\n\u0019\"\u000b]2SKN\u0004xN\\:f\u0007\u0006dGNY1dWR1\u0011\u0011DAb\u0003\u000bDq!a'\u001b\u0001\u0004\ti\nC\u0004\u0002*j\u0001\r!a+\u0002!!\fg\u000e\u001a7f%B\u001c'+Z9vKN$H\u0003CA\r\u0003\u0017\fi-a6\t\u000f\u0005m5\u00041\u0001\u0002\u001e\"9\u0011qZ\u000eA\u0002\u0005E\u0017A\u0003:qGJ+\u0017/^3tiB!\u0011QVAj\u0013\u0011\t).a,\u0003\u0015I\u00038MU3rk\u0016\u001cH\u000fC\u0004\u0002:n\u0001\r!a/\u0002-!\fg\u000e\u001a7f\u0019\u0016<\u0017mY=Sa\u000elUm]:bO\u0016$\u0002\"!\u0007\u0002^\u0006}\u0017\u0011\u001d\u0005\b\u00037c\u0002\u0019AAO\u0011\u001d\ty\r\ba\u0001\u0003#Dq!!/\u001d\u0001\u0004\tY,\u0001\riC:$G.Z(qK:\u001cFO]3b[&sG/\u001a:oC2$b#!\u0007\u0002h\u0006%\u00181^Aw\u0003o\fY0a@\u0003\u0004\t5!\u0011\u0003\u0005\b\u00037k\u0002\u0019AAO\u0011\u001d\tI(\ba\u0001\u0003wBq!a%\u001e\u0001\u0004\tY\bC\u0004\u0002pv\u0001\r!!=\u0002\u0015M$\u0018M\u001d;J]\u0012,\u0007\u0010E\u0002w\u0003gL1!!>x\u0005\rIe\u000e\u001e\u0005\b\u0003sl\u0002\u0019AAy\u0003!)g\u000eZ%oI\u0016D\bbBA\u007f;\u0001\u0007\u0011\u0011_\u0001\u000eS:LG/[1m\u0007J,G-\u001b;\t\r\t\u0005Q\u00041\u0001|\u00031\u0011\bo\u0019*fcV,7\u000f^%e\u0011\u001d\u0011)!\ba\u0001\u0005\u000f\t\u0001\"[:MK\u001e\f7-\u001f\t\u0004m\n%\u0011b\u0001B\u0006o\n9!i\\8mK\u0006t\u0007\"\u0003B\b;A\u0005\t\u0019\u0001B\u0004\u0003A\u0011X-\u00193M_\u000e\fGn\u00155vM\u001adW\rC\u0004\u0002:v\u0001\r!a/\u0002E!\fg\u000e\u001a7f\u001fB,gn\u0015;sK\u0006l\u0017J\u001c;fe:\fG\u000e\n3fM\u0006,H\u000e\u001e\u0013:+\t\u00119B\u000b\u0003\u0003\b\te1F\u0001B\u000e!\u0011\u0011iBa\n\u000e\u0005\t}!\u0002\u0002B\u0011\u0005G\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t\u0015r/\u0001\u0006b]:|G/\u0019;j_:LAA!\u000b\u0003 \t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002%I,\u0007\u000f\\=TiJ,\u0017-\u001c%b]\u0012dWM\u001d\u000b\u0011\u00033\u0011yC!\r\u00036\te\"Q\bB \u0005+Bq!a' \u0001\u0004\ti\n\u0003\u0004\u00034}\u0001\ra_\u0001\ne\u0016\fX/Z:u\u0013\u0012DaAa\u000e \u0001\u0004Y\u0018\u0001C:ue\u0016\fW.\u00133\t\u000f\tmr\u00041\u0001\u0002r\u0006Ia.^7DQVt7n\u001d\u0005\b\u0005\u000by\u0002\u0019\u0001B\u0004\u0011%\u0011\te\bI\u0001\u0002\u0004\u0011\u0019%A\u0004pM\u001a\u001cX\r^:\u0011\r\t\u0015#q\tB&\u001b\t\tI%\u0003\u0003\u0003J\u0005%#\u0001\u0002'jgR\u0004BA!\u0014\u0003T5\u0011!q\n\u0006\u0005\u0005#\nY%\u0001\u0003mC:<\u0017bA?\u0003P!I!qK\u0010\u0011\u0002\u0003\u0007\u00111P\u0001\tM&dW\r]1uQ\u0006a\"/\u001a9msN#(/Z1n\u0011\u0006tG\r\\3sI\u0011,g-Y;mi\u00122TC\u0001B/U\u0011\u0011\u0019E!\u0007\u00029I,\u0007\u000f\\=TiJ,\u0017-\u001c%b]\u0012dWM\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!1\r\u0016\u0005\u0003w\u0012I\"\u0001\u000biC:$G.\u001a*qG&{U\t_2faRLwN\u001c\u000b\u000f\u00033\u0011IGa\u001b\u0003n\t=$\u0011\u000fBA\u0011\u001d\tYJ\ta\u0001\u0003;CaAa\r#\u0001\u0004Y\bbBA=E\u0001\u0007\u00111\u0010\u0005\b\u0003'\u0013\u0003\u0019AA>\u0011\u001d\u0011\u0019H\ta\u0001\u0005k\n1![8f!\u0011\u00119H! \u000e\u0005\te$\u0002\u0002B>\u0003\u0017\n!![8\n\t\t}$\u0011\u0010\u0002\f\u0013>+\u0005pY3qi&|g\u000eC\u0004\u0003\u0004\n\u0002\r!a/\u0002\u0017I\u00048mQ1mY\n\f7m[\u0001\u0013Q\u0006tG\r\\3Sa\u000e,\u0005pY3qi&|g\u000e\u0006\u0006\u0002\u001a\t%%1\u0012BG\u0005\u001fCq!a'$\u0001\u0004\ti\n\u0003\u0004\u00034\r\u0002\ra\u001f\u0005\b\u0005g\u001a\u0003\u0019\u0001B;\u0011\u001d\u0011\tj\ta\u0001\u0003w\u000b1C\u001d9d%\u0016\u001c\bo\u001c8tK\u000e\u000bG\u000e\u001c2bG.\f\u0011\u0004[1oI2,WI\u001c3TiJ,\u0017-\u001c$s_6\u001cE.[3oiR1\u0011\u0011\u0004BL\u00053Cq!a'%\u0001\u0004\ti\n\u0003\u0004\u00038\u0011\u0002\ra\u001f\u000b\t\u00033\u0011iJa(\u0003\"\"9\u00111T\u0013A\u0002\u0005u\u0005B\u0002B\u001cK\u0001\u00071\u0010C\u0004\u0003$\u0016\u0002\rA!*\u0002\u0015M$(/Z1n)f\u0004X\r\u0005\u0003\u0003(\n-VB\u0001BU\u0015\r\t\tlQ\u0005\u0005\u0005[\u0013IK\u0001\u0006TiJ,\u0017-\u001c+za\u0016\f1\u0003[1oI2,'+Z1e\u0003\u0012$7I]3eSR$\u0002\"!\u0007\u00034\nU&\u0011\u0018\u0005\b\u000373\u0003\u0019AAO\u0011\u001d\u00119L\na\u0001\u0003c\faa\u0019:fI&$\bB\u0002B\u001cM\u0001\u000710A\fiC:$G.Z\"ik:\\g)\u001a;dQJ+\u0017/^3tiRA\u0011\u0011\u0004B`\u0005\u0003\u0014Y\rC\u0004\u0002\u001c\u001e\u0002\r!!(\t\u000f\t\rw\u00051\u0001\u0003F\u0006\u00012\u000f\u001e:fC6\u001c\u0005.\u001e8l'2L7-\u001a\t\u0005\u0003[\u00139-\u0003\u0003\u0003J\u0006=&\u0001E*ue\u0016\fWn\u00115v].\u001cF.[2f\u0011\u001d\u0011im\na\u0001\u0003W\u000b1A]3r\u0003=\u0019\u0007.Z2l%\u0016<\u0017n\u001d;fe\u0016$GC\u0001B\u0004\u00035\u0019\u0007.\u00198oK2\f5\r^5wKR!\u0011\u0011\u0004Bl\u0011\u001d\tY*\u000ba\u0001\u0003;\u000bqb\u00195b]:,G.\u00138bGRLg/\u001a\u000b\u0005\u00033\u0011i\u000eC\u0004\u0002\u001c*\u0002\r!!(\u0002\u001f\u0015D8-\u001a9uS>t7)Y;hQR$b!!\u0007\u0003d\ne\bb\u0002BsW\u0001\u0007!q]\u0001\u0006G\u0006,8/\u001a\t\u0005\u0005S\u0014\u0019P\u0004\u0003\u0003l\n=h\u0002BAA\u0005[L\u0011\u0001_\u0005\u0004\u0005c<\u0018a\u00029bG.\fw-Z\u0005\u0005\u0005k\u00149PA\u0005UQJ|w/\u00192mK*\u0019!\u0011_<\t\u000f\u0005m5\u00061\u0001\u0002\u001e\u0006A2\r\\3b]V\u0004X\t\u001f9je\u0016$7\u000b[;gM2,7*Z=\u0015\t\u0005e!q \u0005\b\u0007\u0003a\u0003\u0019AB\u0002\u0003I)\u0007\u0010]5sK\u0012\u001c\u0006.\u001e4gY\u0016\\U-_:\u0011\r\t\u00153QAA>\u0013\u0011\u00199!!\u0013\u0003\u000f!\u000b7\u000f[*fi\u0006\u00192/\u001a;QCJ$\u0018\u000e^5p]N\u001cvN\u001d;feR!\u0011\u0011DB\u0007\u0011\u001d\u0019y!\fa\u0001\u0003S\tA\u0003]1si&$\u0018n\u001c8GS2,7oU8si\u0016\u0014\b")
public class FetchHandler
extends BaseMessageHandler
implements Logging {
    private final CelebornConf conf;
    private final TransportConf transportConf;
    private final WorkerSource workerSource;
    private final ChunkStreamManager chunkStreamManager;
    private final Option<Object> maxChunkBeingTransferred;
    private final CreditStreamManager creditStreamManager;
    private StorageManager storageManager;
    private PartitionFilesSorter partitionsSorter;
    private Option<AtomicBoolean> registered;
    private transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    private Logger log$lzycompute() {
        FetchHandler fetchHandler = this;
        synchronized (fetchHandler) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Logger log() {
        return !this.bitmap$trans$0 ? this.log$lzycompute() : this.log;
    }

    public CelebornConf conf() {
        return this.conf;
    }

    public TransportConf transportConf() {
        return this.transportConf;
    }

    public WorkerSource workerSource() {
        return this.workerSource;
    }

    public ChunkStreamManager chunkStreamManager() {
        return this.chunkStreamManager;
    }

    public Option<Object> maxChunkBeingTransferred() {
        return this.maxChunkBeingTransferred;
    }

    public CreditStreamManager creditStreamManager() {
        return this.creditStreamManager;
    }

    public StorageManager storageManager() {
        return this.storageManager;
    }

    public void storageManager_$eq(StorageManager x$1) {
        this.storageManager = x$1;
    }

    public PartitionFilesSorter partitionsSorter() {
        return this.partitionsSorter;
    }

    public void partitionsSorter_$eq(PartitionFilesSorter x$1) {
        this.partitionsSorter = x$1;
    }

    public Option<AtomicBoolean> registered() {
        return this.registered;
    }

    public void registered_$eq(Option<AtomicBoolean> x$1) {
        this.registered = x$1;
    }

    public void init(Worker worker) {
        this.workerSource().addGauge(WorkerSource$.MODULE$.CHUNK_STREAM_COUNT(), this.workerSource().addGauge$default$2(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.chunkStreamManager().getStreamsCount());
        this.workerSource().addGauge(WorkerSource$.MODULE$.CREDIT_STREAM_COUNT(), this.workerSource().addGauge$default$2(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.creditStreamManager().getStreamsCount());
        this.workerSource().addGauge(WorkerSource$.MODULE$.ACTIVE_MAP_PARTITION_COUNT(), this.workerSource().addGauge$default$2(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> this.creditStreamManager().getActiveMapPartitionCount());
        this.storageManager_$eq(worker.storageManager());
        this.partitionsSorter_$eq(worker.partitionsSorter());
        this.registered_$eq((Option<AtomicBoolean>)new Some((Object)worker.registered()));
    }

    /*
     * WARNING - void declaration
     */
    public FileInfo getRawFileInfo(String shuffleKey, String fileName) {
        void var3_3;
        FileInfo fileInfo = this.storageManager().getFileInfo(shuffleKey, fileName);
        if (fileInfo == null) {
            String errMsg = new StringBuilder(26).append("Could not find file ").append(fileName).append(" for ").append(shuffleKey).append(".").toString();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errMsg);
            throw new FileNotFoundException(errMsg);
        }
        return var3_3;
    }

    public void receive(TransportClient client, RequestMessage msg, RpcResponseCallback callback) {
        this.handleRpcRequest(client, (RpcRequest)msg, callback);
    }

    public void receive(TransportClient client, RequestMessage msg) {
        RequestMessage requestMessage = msg;
        if (requestMessage instanceof BufferStreamEnd) {
            BufferStreamEnd bufferStreamEnd = (BufferStreamEnd)requestMessage;
            this.handleEndStreamFromClient(client, bufferStreamEnd.getStreamId());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (requestMessage instanceof ReadAddCredit) {
            ReadAddCredit readAddCredit = (ReadAddCredit)requestMessage;
            this.handleReadAddCredit(client, readAddCredit.getCredit(), readAddCredit.getStreamId());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (requestMessage instanceof ChunkFetchRequest) {
            ChunkFetchRequest chunkFetchRequest = (ChunkFetchRequest)requestMessage;
            this.handleChunkFetchRequest(client, chunkFetchRequest.streamChunkSlice, (RequestMessage)chunkFetchRequest);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            if (requestMessage != null) {
                RequestMessage requestMessage2 = requestMessage;
                throw new IllegalArgumentException(new StringBuilder(25).append("Unknown message type id: ").append(requestMessage2.type().id()).toString());
            }
            throw new MatchError((Object)requestMessage);
        }
    }

    private void handleRpcRequest(TransportClient client, RpcRequest rpcRequest, RpcResponseCallback callback) {
        GeneratedMessageV3 message = null;
        try {
            message = TransportMessage.fromByteBuffer((ByteBuffer)rpcRequest.body().nioByteBuffer()).getParsedPayload();
        }
        catch (CelebornIOException exception) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Handle request with legacy RPCs", exception);
            this.handleLegacyRpcMessage(client, rpcRequest, callback);
            return;
        }
        GeneratedMessageV3 generatedMessageV3 = message;
        if (generatedMessageV3 instanceof PbOpenStream) {
            PbOpenStream pbOpenStream = (PbOpenStream)generatedMessageV3;
            this.handleOpenStreamInternal(client, pbOpenStream.getShuffleKey(), pbOpenStream.getFileName(), pbOpenStream.getStartIndex(), pbOpenStream.getEndIndex(), pbOpenStream.getInitialCredit(), rpcRequest.requestId, false, pbOpenStream.getReadLocalShuffle(), callback);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (generatedMessageV3 instanceof PbBufferStreamEnd) {
            PbBufferStreamEnd pbBufferStreamEnd = (PbBufferStreamEnd)generatedMessageV3;
            this.handleEndStreamFromClient(client, pbBufferStreamEnd.getStreamId(), pbBufferStreamEnd.getStreamType());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (generatedMessageV3 instanceof PbReadAddCredit) {
            PbReadAddCredit pbReadAddCredit = (PbReadAddCredit)generatedMessageV3;
            this.handleReadAddCredit(client, pbReadAddCredit.getCredit(), pbReadAddCredit.getStreamId());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (generatedMessageV3 instanceof PbChunkFetchRequest) {
            PbChunkFetchRequest pbChunkFetchRequest = (PbChunkFetchRequest)generatedMessageV3;
            this.handleChunkFetchRequest(client, StreamChunkSlice.fromProto((PbStreamChunkSlice)pbChunkFetchRequest.getStreamChunkSlice()), (RequestMessage)rpcRequest);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (generatedMessageV3 != null) {
            GeneratedMessageV3 generatedMessageV32 = generatedMessageV3;
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Unknown message ").append(generatedMessageV32).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)generatedMessageV3);
        }
    }

    private void handleLegacyRpcMessage(TransportClient client, RpcRequest rpcRequest, RpcResponseCallback callback) {
        block4: {
            try {
                Message message = Message.decode((ByteBuffer)rpcRequest.body().nioByteBuffer());
                Message.Type type = message.type();
                if (Message.Type.OPEN_STREAM.equals(type)) {
                    OpenStream openStream = (OpenStream)message;
                    this.handleOpenStreamInternal(client, new String(openStream.shuffleKey, StandardCharsets.UTF_8), new String(openStream.fileName, StandardCharsets.UTF_8), openStream.startMapIndex, openStream.endMapIndex, 0, rpcRequest.requestId, true, false, callback);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                if (Message.Type.OPEN_STREAM_WITH_CREDIT.equals(type)) {
                    OpenStreamWithCredit openStreamWithCredit = (OpenStreamWithCredit)message;
                    this.handleOpenStreamInternal(client, new String(openStreamWithCredit.shuffleKey, StandardCharsets.UTF_8), new String(openStreamWithCredit.fileName, StandardCharsets.UTF_8), openStreamWithCredit.startIndex, openStreamWithCredit.endIndex, openStreamWithCredit.initialCredit, rpcRequest.requestId, true, false, callback);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Received an unknown message type id: ").append(message.type().id()).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Catch an error when handle legacy rpc message.", e);
            }
        }
    }

    private void handleOpenStreamInternal(TransportClient client, String shuffleKey, String fileName, int startIndex, int endIndex, int initialCredit, long rpcRequestId, boolean isLegacy, boolean readLocalShuffle, RpcResponseCallback callback) {
        this.workerSource().recordAppActiveConnection(client, shuffleKey);
        this.workerSource().startTimer(WorkerSource$.MODULE$.OPEN_STREAM_TIME(), shuffleKey);
        try {
            try {
                Object object;
                ObjectRef fileInfo = ObjectRef.create((Object)this.getRawFileInfo(shuffleKey, fileName));
                PartitionType partitionType = ((FileInfo)fileInfo.elem).getPartitionType();
                if (PartitionType.REDUCE.equals(partitionType)) {
                    BoxedUnit boxedUnit;
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(68).append("Received open stream request ").append(shuffleKey).append(" ").append(fileName).append(" ").append(startIndex).append(" ").append(endIndex).append(" get file name ").append(fileName).append(" from client channel ").append(NettyUtils.getRemoteAddress((Channel)client.getChannel())).toString());
                    long streamId = this.chunkStreamManager().nextStreamId();
                    if (endIndex != Integer.MAX_VALUE || endIndex == Integer.MAX_VALUE && !((FileInfo)fileInfo.elem).addStream(streamId)) {
                        fileInfo.elem = this.partitionsSorter().getSortedFileInfo(shuffleKey, fileName, (FileInfo)fileInfo.elem, startIndex, endIndex);
                    }
                    if (readLocalShuffle) {
                        this.chunkStreamManager().registerStream(streamId, shuffleKey, fileName);
                        this.org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler(client, rpcRequestId, streamId, ((FileInfo)fileInfo.elem).numChunks(), isLegacy, ((FileInfo)fileInfo.elem).getChunkOffsets(), ((FileInfo)fileInfo.elem).getFilePath());
                        boxedUnit = BoxedUnit.UNIT;
                    } else if (((FileInfo)fileInfo.elem).isHdfs()) {
                        this.chunkStreamManager().registerStream(streamId, shuffleKey, fileName);
                        this.org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler(client, rpcRequestId, streamId, 0, isLegacy, this.org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler$default$6(), this.org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler$default$7());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        this.chunkStreamManager().registerStream(streamId, shuffleKey, new FileManagedBuffers((FileInfo)fileInfo.elem, this.transportConf()), fileName, this.storageManager().getFetchTimeMetric(((FileInfo)fileInfo.elem).getFile()));
                        if (((FileInfo)fileInfo.elem).numChunks() == 0) {
                            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("StreamId ").append(streamId).append(", fileName ").append(fileName).append(", mapRange ").append("[").append(startIndex).append("-").append(endIndex).append("] is empty. Received from client channel ").append(NettyUtils.getRemoteAddress((Channel)client.getChannel())).toString());
                        } else {
                            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(77).append("StreamId ").append(streamId).append(", fileName ").append(fileName).append(", numChunks ").append(((FileInfo)fileInfo$1.elem).numChunks()).append(", ").append("mapRange [").append(startIndex).append("-").append(endIndex).append("]. Received from client channel ").append(NettyUtils.getRemoteAddress((Channel)client.getChannel())).toString());
                        }
                        this.org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler(client, rpcRequestId, streamId, ((FileInfo)fileInfo.elem).numChunks(), isLegacy, this.org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler$default$6(), this.org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler$default$7());
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = boxedUnit;
                } else if (PartitionType.MAP.equals(partitionType)) {
                    Consumer<Long> creditStreamHandler = new Consumer<Long>(this, client, rpcRequestId, isLegacy){
                        private final /* synthetic */ FetchHandler $outer;
                        private final TransportClient client$1;
                        private final long rpcRequestId$1;
                        private final boolean isLegacy$1;

                        public Consumer<Long> andThen(Consumer<? super Long> x$1) {
                            return Consumer.super.andThen(x$1);
                        }

                        public void accept(Long streamId) {
                            this.$outer.org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler(this.client$1, this.rpcRequestId$1, Predef$.MODULE$.Long2long(streamId), 0, this.isLegacy$1, this.$outer.org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler$default$6(), this.$outer.org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler$default$7());
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.client$1 = client$1;
                            this.rpcRequestId$1 = rpcRequestId$1;
                            this.isLegacy$1 = isLegacy$1;
                        }
                    };
                    object = BoxesRunTime.boxToLong((long)this.creditStreamManager().registerStream(creditStreamHandler, client.getChannel(), shuffleKey, initialCredit, startIndex, endIndex, (FileInfo)fileInfo.elem));
                } else if (PartitionType.MAPGROUP.equals(partitionType)) {
                    object = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)partitionType);
                }
                this.workerSource().incCounter(WorkerSource$.MODULE$.OPEN_STREAM_SUCCESS_COUNT());
            }
            catch (IOException e) {
                this.workerSource().incCounter(WorkerSource$.MODULE$.OPEN_STREAM_FAIL_COUNT());
                this.handleRpcIOException(client, rpcRequestId, shuffleKey, fileName, e, callback);
            }
        }
        finally {
            this.workerSource().stopTimer(WorkerSource$.MODULE$.OPEN_STREAM_TIME(), shuffleKey);
        }
    }

    private boolean handleOpenStreamInternal$default$9() {
        return false;
    }

    public void org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler(TransportClient client, long requestId, long streamId, int numChunks, boolean isLegacy, List<Long> offsets, String filepath) {
        if (isLegacy) {
            client.getChannel().writeAndFlush((Object)new RpcResponse(requestId, (ManagedBuffer)new NioManagedBuffer(new StreamHandle(streamId, numChunks).toByteBuffer())));
        } else {
            PbStreamHandler.Builder pbStreamHandlerBuilder = PbStreamHandler.newBuilder().setStreamId(streamId).setNumChunks(numChunks);
            Object object = offsets != null ? pbStreamHandlerBuilder.addAllChunkOffsets(offsets) : BoxedUnit.UNIT;
            Object object2 = new StringOps(Predef$.MODULE$.augmentString(filepath)).nonEmpty() ? pbStreamHandlerBuilder.setFullPath(filepath) : BoxedUnit.UNIT;
            PbStreamHandler pbStreamHandler = pbStreamHandlerBuilder.build();
            client.getChannel().writeAndFlush((Object)new RpcResponse(requestId, (ManagedBuffer)new NioManagedBuffer(new TransportMessage(MessageType.STREAM_HANDLER, pbStreamHandler.toByteArray()).toByteBuffer())));
        }
    }

    public List<Long> org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler$default$6() {
        return null;
    }

    public String org$apache$celeborn$service$deploy$worker$FetchHandler$$replyStreamHandler$default$7() {
        return "";
    }

    private void handleRpcIOException(TransportClient client, long requestId, String shuffleKey, String fileName, IOException ioe, RpcResponseCallback rpcCallback) {
        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Read file: ").append(fileName).append(" with shuffleKey: ").append(shuffleKey).append(" error from ").append(NettyUtils.getRemoteAddress((Channel)client.getChannel())).toString(), ioe);
        this.handleRpcException(client, requestId, ioe, rpcCallback);
    }

    private void handleRpcException(TransportClient client, long requestId, IOException ioe, RpcResponseCallback rpcResponseCallback) {
        rpcResponseCallback.onFailure(ExceptionUtils.wrapIOExceptionToUnRetryable((Throwable)ioe));
    }

    public void handleEndStreamFromClient(TransportClient client, long streamId) {
        this.handleEndStreamFromClient(client, streamId, StreamType.CreditStream);
    }

    public void handleEndStreamFromClient(TransportClient client, long streamId, StreamType streamType) {
        StreamType streamType2 = streamType;
        if (StreamType.ChunkStream.equals(streamType2)) {
            Tuple2<String, String> tuple2 = this.chunkStreamManager().getShuffleKeyAndFileName(streamId);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String shuffleKey = (String)tuple2._1();
            String fileName = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)shuffleKey, (Object)fileName);
            Tuple2 tuple23 = tuple22;
            String shuffleKey2 = (String)tuple23._1();
            String fileName2 = (String)tuple23._2();
            this.workerSource().recordAppActiveConnection(client, shuffleKey2);
            this.getRawFileInfo(shuffleKey2, fileName2).closeStream(streamId);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (StreamType.CreditStream.equals(streamType2)) {
            BoxedUnit boxedUnit;
            String shuffleKey = this.creditStreamManager().getStreamShuffleKey(Predef$.MODULE$.long2Long(streamId));
            if (shuffleKey != null) {
                this.workerSource().recordAppActiveConnection(client, shuffleKey);
                this.creditStreamManager().notifyStreamEndByClient(streamId);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Received a PbBufferStreamEnd message with unknown type ").append(streamType).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void handleReadAddCredit(TransportClient client, int credit, long streamId) {
        block0: {
            String shuffleKey = this.creditStreamManager().getStreamShuffleKey(Predef$.MODULE$.long2Long(streamId));
            if (shuffleKey == null) break block0;
            this.workerSource().recordAppActiveConnection(client, shuffleKey);
            this.creditStreamManager().addCredit(credit, streamId);
        }
    }

    public void handleChunkFetchRequest(TransportClient client, StreamChunkSlice streamChunkSlice, RequestMessage req) {
        Object object = new Object();
        try {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Received req from ").append(NettyUtils.getRemoteAddress((Channel)client.getChannel())).append(" to fetch block ").append(streamChunkSlice).toString());
            this.workerSource().recordAppActiveConnection(client, (String)this.chunkStreamManager().getShuffleKeyAndFileName(streamChunkSlice.streamId)._1());
            this.maxChunkBeingTransferred().foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)threshold -> {
                long chunksBeingTransferred = this.chunkStreamManager().chunksBeingTransferred();
                if (chunksBeingTransferred > threshold) {
                    String message = new StringBuilder(70).append("Worker is too busy. The number of chunks being transferred ").append(chunksBeingTransferred).append(" exceeds ").append(CelebornConf$.MODULE$.MAX_CHUNKS_BEING_TRANSFERRED().key()).append(" ").append(Utils$.MODULE$.bytesToString(threshold)).append(".").toString();
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
                    this.workerSource().incCounter(WorkerSource$.MODULE$.FETCH_CHUNK_FAIL_COUNT());
                    client.getChannel().writeAndFlush((Object)new ChunkFetchFailure(streamChunkSlice, message));
                    throw new NonLocalReturnControl.mcV.sp(object, BoxedUnit.UNIT);
                }
            });
            String reqStr = req.toString();
            this.workerSource().startTimer(WorkerSource$.MODULE$.FETCH_CHUNK_TIME(), reqStr);
            TimeWindow fetchTimeMetric = this.chunkStreamManager().getFetchTimeMetric(streamChunkSlice.streamId);
            long fetchBeginTime = System.nanoTime();
            try {
                ManagedBuffer buf = this.chunkStreamManager().getChunk(streamChunkSlice.streamId, streamChunkSlice.chunkIndex, streamChunkSlice.offset, streamChunkSlice.len);
                this.chunkStreamManager().chunkBeingSent(streamChunkSlice.streamId);
                client.getChannel().writeAndFlush((Object)new ChunkFetchSuccess(streamChunkSlice, buf)).addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(this, streamChunkSlice, fetchTimeMetric, fetchBeginTime, reqStr){
                    private final /* synthetic */ FetchHandler $outer;
                    private final StreamChunkSlice streamChunkSlice$1;
                    private final TimeWindow fetchTimeMetric$1;
                    private final long fetchBeginTime$1;
                    private final String reqStr$1;

                    public void operationComplete(Future<? super Void> future) {
                        if (future.isSuccess()) {
                            if (this.$outer.log().isDebugEnabled()) {
                                this.$outer.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Sending ChunkFetchSuccess operation succeeded, chunk ").append($this.streamChunkSlice$1).toString());
                            }
                        } else {
                            this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Sending ChunkFetchSuccess operation failed, chunk ").append($this.streamChunkSlice$1).toString(), future.cause());
                        }
                        this.$outer.workerSource().incCounter(WorkerSource$.MODULE$.FETCH_CHUNK_SUCCESS_COUNT());
                        this.$outer.chunkStreamManager().chunkSent(this.streamChunkSlice$1.streamId);
                        if (this.fetchTimeMetric$1 != null) {
                            this.fetchTimeMetric$1.update(System.nanoTime() - this.fetchBeginTime$1);
                        }
                        this.$outer.workerSource().stopTimer(WorkerSource$.MODULE$.FETCH_CHUNK_TIME(), this.reqStr$1);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.streamChunkSlice$1 = streamChunkSlice$1;
                        this.fetchTimeMetric$1 = fetchTimeMetric$1;
                        this.fetchBeginTime$1 = fetchBeginTime$1;
                        this.reqStr$1 = reqStr$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$operationComplete$1(org.apache.celeborn.service.deploy.worker.FetchHandler$$anon$2 ), $anonfun$operationComplete$2(org.apache.celeborn.service.deploy.worker.FetchHandler$$anon$2 )}, serializedLambda);
                    }
                });
            }
            catch (Exception e) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Error opening block ").append(streamChunkSlice).append(" for request from ").append(NettyUtils.getRemoteAddress((Channel)client.getChannel())).toString(), e);
                this.workerSource().incCounter(WorkerSource$.MODULE$.FETCH_CHUNK_FAIL_COUNT());
                client.getChannel().writeAndFlush((Object)new ChunkFetchFailure(streamChunkSlice, Throwables.getStackTraceAsString((Throwable)e)));
                this.workerSource().stopTimer(WorkerSource$.MODULE$.FETCH_CHUNK_TIME(), reqStr);
            }
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                ex.value$mcV$sp();
            }
            throw ex;
        }
    }

    public boolean checkRegistered() {
        return this.registered().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.get()));
    }

    public void channelActive(TransportClient client) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(15).append("channel active ").append(client.getSocketAddress()).toString());
        this.workerSource().connectionActive(client);
        super.channelActive(client);
    }

    public void channelInactive(TransportClient client) {
        this.workerSource().connectionInactive(client);
        this.creditStreamManager().connectionTerminated(client.getChannel());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("channel inactive ").append(client.getSocketAddress()).toString());
    }

    public void exceptionCaught(Throwable cause, TransportClient client) {
        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("exception caught ").append(client.getSocketAddress()).toString(), cause);
    }

    public void cleanupExpiredShuffleKey(HashSet<String> expiredShuffleKeys) {
        block0: {
            this.chunkStreamManager().cleanupExpiredShuffleKey(expiredShuffleKeys);
            if (this.partitionsSorter() == null) break block0;
            this.partitionsSorter().cleanupExpiredShuffleKey(expiredShuffleKeys);
        }
    }

    public void setPartitionsSorter(PartitionFilesSorter partitionFilesSorter) {
        this.partitionsSorter_$eq(partitionFilesSorter);
    }

    public FetchHandler(CelebornConf conf, TransportConf transportConf, WorkerSource workerSource) {
        this.conf = conf;
        this.transportConf = transportConf;
        this.workerSource = workerSource;
        Logging.$init$((Logging)this);
        this.chunkStreamManager = new ChunkStreamManager();
        this.maxChunkBeingTransferred = conf.shuffleIoMaxChunksBeingTransferred();
        this.creditStreamManager = new CreditStreamManager(conf.partitionReadBuffersMin(), conf.partitionReadBuffersMax(), conf.creditStreamThreadsPerMountpoint(), conf.readBuffersToTriggerReadMin());
        this.registered = None$.MODULE$;
    }
}

