/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.shuffledb;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.celeborn.common.util.PbSerDeUtils;
import org.apache.celeborn.service.deploy.worker.shuffledb.StoreVersion;
import org.apache.commons.io.FileUtils;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.CompressionType;
import org.rocksdb.Filter;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.LoggerInterface;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.Status;
import org.rocksdb.TableFormatConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocksDBProvider {
    private static final Logger logger;

    public static RocksDB initRockDB(File dbFile, StoreVersion version) throws IOException {
        RocksDB tmpDb = null;
        if (dbFile != null) {
            BloomFilter fullFilter = new BloomFilter(10.0, false);
            BlockBasedTableConfig tableFormatConfig = new BlockBasedTableConfig().setFilterPolicy((Filter)fullFilter).setEnableIndexCompression(false).setIndexBlockRestartInterval(8).setFormatVersion(5);
            Options dbOptions = new Options();
            RocksDBLogger rocksDBLogger = new RocksDBLogger(dbOptions);
            dbOptions.setCreateIfMissing(false);
            dbOptions.setBottommostCompressionType(CompressionType.ZSTD_COMPRESSION);
            dbOptions.setCompressionType(CompressionType.LZ4_COMPRESSION);
            dbOptions.setTableFormatConfig((TableFormatConfig)tableFormatConfig);
            dbOptions.setLogger((LoggerInterface)rocksDBLogger);
            try {
                tmpDb = RocksDB.open((Options)dbOptions, (String)dbFile.toString());
            }
            catch (RocksDBException e) {
                if (e.getStatus().getCode() == Status.Code.NotFound) {
                    logger.info("Creating state database at " + dbFile);
                    RocksDBProvider.createIfMissing(dbOptions, dbFile);
                    try {
                        tmpDb = RocksDB.open((Options)dbOptions, (String)dbFile.toString());
                    }
                    catch (RocksDBException dbExc) {
                        throw new IOException("Unable to create state store", dbExc);
                    }
                }
                logger.error("Error opening rocksdb file {}. Creating new file, will not be able to recover state for existing applications", (Object)dbFile, (Object)e);
                if (dbFile.isDirectory()) {
                    for (File f : Objects.requireNonNull(dbFile.listFiles())) {
                        if (f.delete()) continue;
                        logger.warn("Error deleting {}", (Object)f.getPath());
                    }
                }
                if (!dbFile.delete()) {
                    logger.warn("Error deleting {}", (Object)dbFile.getPath());
                }
                RocksDBProvider.createIfMissing(dbOptions, dbFile);
                try {
                    tmpDb = RocksDB.open((Options)dbOptions, (String)dbFile.toString());
                }
                catch (RocksDBException dbExc) {
                    throw new IOException("Unable to create state store", dbExc);
                }
            }
            try {
                RocksDBProvider.checkVersion(tmpDb, version);
            }
            catch (RocksDBException e) {
                tmpDb.close();
                throw new IOException(e.getMessage(), e);
            }
            catch (IOException ioe) {
                tmpDb.close();
                throw ioe;
            }
        }
        return tmpDb;
    }

    private static void createIfMissing(Options dbOptions, File dbFile) {
        logger.info("Creating database file {} if missing", (Object)dbFile);
        dbOptions.setCreateIfMissing(true);
        if (!dbFile.exists()) {
            try {
                FileUtils.forceMkdir((File)dbFile);
            }
            catch (IOException e) {
                logger.warn("Failed to create database file {}", (Object)dbFile, (Object)e);
            }
        }
    }

    public static void checkVersion(RocksDB db, StoreVersion newVersion) throws IOException, RocksDBException {
        byte[] bytes = db.get(StoreVersion.KEY);
        if (bytes == null) {
            RocksDBProvider.storeVersion(db, newVersion);
        } else {
            ArrayList versions = PbSerDeUtils.fromPbStoreVersion((byte[])bytes);
            StoreVersion version = new StoreVersion((Integer)versions.get(0), (Integer)versions.get(1));
            if (version.major != newVersion.major) {
                throw new IOException("Cannot read state DB with version " + version + ", incompatible with current version " + newVersion);
            }
            RocksDBProvider.storeVersion(db, newVersion);
        }
    }

    public static void storeVersion(RocksDB db, StoreVersion version) throws RocksDBException {
        db.put(StoreVersion.KEY, PbSerDeUtils.toPbStoreVersion((int)version.major, (int)version.minor));
    }

    static {
        RocksDB.loadLibrary();
        logger = LoggerFactory.getLogger(RocksDBProvider.class);
    }

    private static class RocksDBLogger
    extends org.rocksdb.Logger {
        private static final Logger LOG = LoggerFactory.getLogger(RocksDBLogger.class);

        RocksDBLogger(Options options) {
            super(options);
        }

        protected void log(InfoLogLevel infoLogLevel, String message) {
            if (infoLogLevel == InfoLogLevel.INFO_LEVEL) {
                LOG.info(message);
            }
        }
    }
}

