/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.api.records;

import java.text.NumberFormat;
import org.apache.hadoop.mapreduce.v2.api.records.JobId;
import org.apache.hadoop.mapreduce.v2.api.records.TaskType;

public abstract class TaskId
implements Comparable<TaskId> {
    protected static final String TASK = "task";
    static final ThreadLocal<NumberFormat> taskIdFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(6);
            return fmt;
        }
    };

    public abstract JobId getJobId();

    public abstract TaskType getTaskType();

    public abstract int getId();

    public abstract void setJobId(JobId var1);

    public abstract void setTaskType(TaskType var1);

    public abstract void setId(int var1);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.getId();
        result = 31 * result + this.getJobId().hashCode();
        result = 31 * result + this.getTaskType().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaskId other = (TaskId)obj;
        if (this.getId() != other.getId()) {
            return false;
        }
        if (!this.getJobId().equals(other.getJobId())) {
            return false;
        }
        return this.getTaskType() == other.getTaskType();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(TASK);
        JobId jobId = this.getJobId();
        builder.append("_").append(jobId.getAppId().getClusterTimestamp());
        builder.append("_").append(JobId.jobIdFormat.get().format(jobId.getAppId().getId()));
        builder.append("_");
        builder.append(this.getTaskType() == TaskType.MAP ? "m" : "r").append("_");
        builder.append(taskIdFormat.get().format(this.getId()));
        return builder.toString();
    }

    @Override
    public int compareTo(TaskId other) {
        int jobIdComp = this.getJobId().compareTo(other.getJobId());
        if (jobIdComp == 0) {
            if (this.getTaskType() == other.getTaskType()) {
                return this.getId() - other.getId();
            }
            return this.getTaskType().compareTo(other.getTaskType());
        }
        return jobIdComp;
    }
}

