/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh;

import java.io.Closeable;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.ratis.shell.cli.AbstractShell;
import org.apache.ratis.shell.cli.Command;
import org.apache.ratis.shell.cli.sh.command.Context;
import org.apache.ratis.util.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class RatisShell
extends AbstractShell {
    public static void main(String[] args) {
        RatisShell shell = new RatisShell(System.out);
        System.exit(shell.run(args));
    }

    public RatisShell(PrintStream out) {
        super(new Context(out));
    }

    @Override
    protected String getShellName() {
        return "sh";
    }

    @Override
    protected Map<String, Command> loadCommands(Context context) {
        return this.loadCommands(RatisShell.class.getPackage().getName(), new Class[]{Context.class}, new Object[]{this.getCloser().register((Closeable)context)});
    }

    private Map<String, Command> loadCommands(String pkgName, Class[] classArgs, Object[] objectArgs) {
        HashMap<String, Command> commandsMap = new HashMap<String, Command>();
        Reflections reflections = new Reflections(pkgName, new Scanner[0]);
        for (Class cls : reflections.getSubTypesOf(Command.class)) {
            if (!cls.getPackage().getName().equals(pkgName + ".command") || Modifier.isAbstract(cls.getModifiers())) continue;
            Command cmd = (Command)ReflectionUtils.newInstance((Class)cls, (Class[])classArgs, (Object[])objectArgs);
            commandsMap.put(cmd.getCommandName(), cmd);
        }
        return commandsMap;
    }
}

