/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.bytes;

import java.security.Key;
import org.apache.cayenne.crypto.transformer.bytes.BytesEncryptor;
import org.apache.cayenne.crypto.transformer.bytes.Header;
import org.apache.cayenne.crypto.transformer.bytes.HmacCreator;

class HmacEncryptor
extends HmacCreator
implements BytesEncryptor {
    BytesEncryptor delegate;

    HmacEncryptor(BytesEncryptor delegate, Header header, Key key) {
        super(header, key);
        this.delegate = delegate;
    }

    @Override
    public byte[] encrypt(byte[] input, int outputOffset, byte[] flags) {
        byte[] hmac = this.createHmac(input);
        byte[] encrypted = this.delegate.encrypt(input, outputOffset + hmac.length + 1, flags);
        encrypted[outputOffset++] = (byte)hmac.length;
        System.arraycopy(hmac, 0, encrypted, outputOffset, hmac.length);
        return encrypted;
    }
}

