/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.inflector.lang.it;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jvnet.inflector.Rule;
import org.jvnet.inflector.RuleBasedPluralizer;
import org.jvnet.inflector.rule.AbstractRegexReplacementRule;
import org.jvnet.inflector.rule.CategoryInflectionRule;
import org.jvnet.inflector.rule.IrregularMappingRule;
import org.jvnet.inflector.rule.RegexReplacementRule;
import org.jvnet.inflector.rule.SuffixInflectionRule;

public class NounPluralizer
extends RuleBasedPluralizer {
    private static final Map<String, String> IRREGULAR_NOUNS = IrregularMappingRule.toMap(new String[][]{{"moglie", "mogli"}, {"uovo", "uova"}, {"lenzuolo", "lenzuola"}, {"paio", "paia"}, {"braccio", "braccia"}, {"dito", "dita"}, {"centinaio", "centinaia"}, {"uomo", "uomini"}, {"dio", "dei"}, {"collega", "colleghi"}, {"atleta", "atleti"}});
    private static final String[] CATEGORY_UNINFLECTED_NOUNS = new String[]{"radio", "foto", "moto", "computer", "chef", "hostess"};
    private static final String[] CATEGORY_MA_MA_RULE = new String[]{"cinema", "clima"};
    private static final String[] CATEGORY_MA_ME_RULE = new String[]{"vittima"};
    private static final String[] CATEGORY_IO_II_RULE = new String[]{"zio"};
    private static final String[] CATEGORY_CO_CI_RULE = new String[]{"amico"};
    private static final String[] CATEGORY_GO_GI_RULE = new String[]{"asparago"};
    private static final String[] CATEGORY_CIA_CIE_RULE = new String[]{"farmacia"};
    private static final String[] CATEGORY_GIA_GIE_RULE = new String[]{"valigia"};
    private final List<Rule> rules = Arrays.asList(new RegexReplacementRule("^(\\s)$", "$1"), new IrregularMappingRule(IRREGULAR_NOUNS, "(?i)" + AbstractRegexReplacementRule.disjunction(IRREGULAR_NOUNS.keySet()) + "$"), new SuffixInflectionRule("-ista", "-isti"), new CategoryInflectionRule(CATEGORY_UNINFLECTED_NOUNS, "-", "-"), new SuffixInflectionRule("-[\u00e0|\u00e8|\u00ec|\u00f9]", "-", "-"), new SuffixInflectionRule("-ie?", "-", "-"), new CategoryInflectionRule(CATEGORY_MA_MA_RULE, "-ma", "-ma"), new CategoryInflectionRule(CATEGORY_MA_ME_RULE, "-ma", "-me"), new SuffixInflectionRule("-ma", "-mi"), new CategoryInflectionRule(CATEGORY_IO_II_RULE, "-io", "-ii"), new SuffixInflectionRule("-io", "-o", "-"), new CategoryInflectionRule(CATEGORY_CO_CI_RULE, "-co", "-ci"), new SuffixInflectionRule("-co", "-chi"), new CategoryInflectionRule(CATEGORY_GO_GI_RULE, "-go", "-gi"), new SuffixInflectionRule("-go", "-ghi"), new SuffixInflectionRule("-o", "-i"), new SuffixInflectionRule("-ca", "-che"), new SuffixInflectionRule("-ga", "-ghe"), new CategoryInflectionRule(CATEGORY_CIA_CIE_RULE, "-cia", "-cie"), new SuffixInflectionRule("-cia", "-ce"), new CategoryInflectionRule(CATEGORY_GIA_GIE_RULE, "-gia", "-gie"), new SuffixInflectionRule("-gia", "-ge"), new SuffixInflectionRule("-a", "-e"), new SuffixInflectionRule("-e", "-i"), new SuffixInflectionRule("-", "-"));

    public NounPluralizer() {
        this.setRules(this.rules);
        this.setLocale(Locale.ITALIAN);
    }
}

