/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.project.validation;

import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.configuration.DataNodeDescriptor;
import org.apache.cayenne.configuration.server.XMLPoolingDataSourceFactory;
import org.apache.cayenne.project.validation.ConfigurationNodeValidator;
import org.apache.cayenne.util.Util;
import org.apache.cayenne.validation.ValidationResult;

class DataNodeValidator
extends ConfigurationNodeValidator {
    DataNodeValidator() {
    }

    void validate(DataNodeDescriptor node, ValidationResult validationResult) {
        this.validateName(node, validationResult);
        this.validateConnection(node, validationResult);
    }

    void validateConnection(DataNodeDescriptor node, ValidationResult validationResult) {
        String parameters;
        String factory = node.getDataSourceFactoryType();
        if (factory != null && !XMLPoolingDataSourceFactory.class.getName().equals(factory) && Util.isEmptyString(parameters = node.getParameters())) {
            this.addFailure(validationResult, node, "DataNode has empty 'parameters' string", new Object[0]);
        }
    }

    void validateName(DataNodeDescriptor node, ValidationResult validationResult) {
        String name = node.getName();
        if (Util.isEmptyString(name)) {
            this.addFailure(validationResult, node, "Unnamed DataNode", new Object[0]);
            return;
        }
        DataChannelDescriptor dataChannelDescriptor = node.getDataChannelDescriptor();
        for (DataNodeDescriptor otherNode : dataChannelDescriptor.getNodeDescriptors()) {
            if (otherNode == node || !name.equals(otherNode.getName())) continue;
            this.addFailure(validationResult, node, "Duplicate DataNode name: %s", name);
            break;
        }
    }
}

