/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util.state;

import java.util.ArrayList;
import org.apache.cayenne.configuration.DataChannelDescriptor;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.Embeddable;
import org.apache.cayenne.map.EmbeddableAttribute;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.event.EmbeddableAttributeDisplayEvent;
import org.apache.cayenne.modeler.event.EmbeddableDisplayEvent;
import org.apache.cayenne.modeler.util.state.EmbeddableDisplayEventType;

class EmbeddableAttributeDisplayEventType
extends EmbeddableDisplayEventType {
    public EmbeddableAttributeDisplayEventType(ProjectController controller) {
        super(controller);
    }

    @Override
    public void fireLastDisplayEvent() {
        DataChannelDescriptor dataChannel = (DataChannelDescriptor)this.controller.getProject().getRootNode();
        if (!dataChannel.getName().equals(this.preferences.getDomain())) {
            return;
        }
        DataMap dataMap = dataChannel.getDataMap(this.preferences.getDataMap());
        if (dataMap == null) {
            return;
        }
        Embeddable embeddable = dataMap.getEmbeddable(this.preferences.getEmbeddable());
        if (embeddable == null) {
            return;
        }
        EmbeddableDisplayEvent embeddableDisplayEvent = new EmbeddableDisplayEvent((Object)this, embeddable, dataMap, dataChannel);
        this.controller.fireEmbeddableDisplayEvent(embeddableDisplayEvent);
        EmbeddableAttribute[] embeddableAttributes = this.getLastEmbeddableAttributes(embeddable);
        EmbeddableAttributeDisplayEvent attributeDisplayEvent = new EmbeddableAttributeDisplayEvent((Object)this, embeddable, embeddableAttributes, dataMap, dataChannel);
        this.controller.fireEmbeddableAttributeDisplayEvent(attributeDisplayEvent);
    }

    @Override
    public void saveLastDisplayEvent() {
        this.preferences.setEvent(EmbeddableAttributeDisplayEvent.class.getSimpleName());
        this.preferences.setDomain(this.controller.getCurrentDataChanel().getName());
        this.preferences.setDataMap(this.controller.getCurrentDataMap().getName());
        this.preferences.setEmbeddable(this.controller.getCurrentEmbeddable().getClassName());
        EmbeddableAttribute[] currentEmbAttributes = this.controller.getCurrentEmbAttributes();
        if (currentEmbAttributes == null) {
            this.preferences.setEmbAttrs("");
        } else {
            StringBuilder sb = new StringBuilder();
            for (EmbeddableAttribute embeddableAttribute : currentEmbAttributes) {
                sb.append(embeddableAttribute.getName()).append(",");
            }
            this.preferences.setEmbAttrs(sb.toString());
        }
    }

    protected EmbeddableAttribute[] getLastEmbeddableAttributes(Embeddable embeddable) {
        ArrayList<EmbeddableAttribute> embeddableAttributeList = new ArrayList<EmbeddableAttribute>();
        EmbeddableAttribute[] attributes = new EmbeddableAttribute[]{};
        String embAttrs = this.preferences.getEmbAttrs();
        if (embAttrs.isEmpty()) {
            return embeddableAttributeList.toArray(attributes);
        }
        for (String embAttrName : embAttrs.split(",")) {
            embeddableAttributeList.add(embeddable.getAttribute(embAttrName));
        }
        return embeddableAttributeList.toArray(attributes);
    }
}

