/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.cgen;

import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import org.apache.cayenne.gen.CgenConfiguration;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.editor.cgen.CodeGeneratorController;
import org.apache.cayenne.modeler.editor.cgen.GeneratorControllerPanel;
import org.apache.cayenne.modeler.pref.FSPath;
import org.apache.cayenne.modeler.util.CayenneController;
import org.apache.cayenne.modeler.util.TextAdapter;
import org.apache.cayenne.swing.BindingBuilder;
import org.apache.cayenne.util.Util;

public abstract class GeneratorController
extends CayenneController {
    protected CgenConfiguration cgenConfiguration;

    public GeneratorController(CodeGeneratorController parent) {
        super(parent);
        this.createView();
        this.initBindings(new BindingBuilder(this.getApplication().getBindingFactory(), this));
    }

    protected void initBindings(BindingBuilder bindingBuilder) {
        JButton outputSelect = this.getView().getSelectOutputFolder();
        bindingBuilder.bindToAction(outputSelect, "selectOutputFolderAction()");
    }

    protected CodeGeneratorController getParentController() {
        return (CodeGeneratorController)this.getParent();
    }

    protected abstract void createView();

    @Override
    public abstract GeneratorControllerPanel getView();

    protected void initForm(CgenConfiguration cgenConfiguration) {
        this.cgenConfiguration = cgenConfiguration;
        if (cgenConfiguration.getRootPath() != null) {
            this.getView().getOutputFolder().setText(cgenConfiguration.buildPath().toString());
        }
        if (cgenConfiguration.getArtifactsGenerationMode().equalsIgnoreCase("all")) {
            this.getParentController().setCurrentClass(cgenConfiguration.getDataMap());
            this.getParentController().setSelected(true);
        }
    }

    public abstract void updateConfiguration(CgenConfiguration var1);

    public void selectOutputFolderAction() {
        TextAdapter outputFolder = this.getView().getOutputFolder();
        String currentDir = outputFolder.getComponent().getText();
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setDialogType(0);
        if (!Util.isEmptyString(currentDir)) {
            chooser.setCurrentDirectory(new File(currentDir));
        } else {
            FSPath lastDir = Application.getInstance().getFrameController().getLastDirectory();
            lastDir.updateChooser(chooser);
        }
        int result = chooser.showOpenDialog(this.getView());
        if (result == 0) {
            File selected = chooser.getSelectedFile();
            String path = selected.getAbsolutePath();
            this.getView().getOutputFolder().setText(path);
            this.getView().getOutputFolder().updateModel();
        }
    }
}

