/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.sqlserver;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.SQLTreeProcessor;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeFactory;
import org.apache.cayenne.access.types.ValueObjectTypeRegistry;
import org.apache.cayenne.configuration.RuntimeProperties;
import org.apache.cayenne.dba.sqlserver.SQLServerActionBuilder;
import org.apache.cayenne.dba.sqlserver.SQLServerTreeProcessor;
import org.apache.cayenne.dba.sqlserver.SQLServerTreeProcessorV12;
import org.apache.cayenne.dba.sybase.SybaseAdapter;
import org.apache.cayenne.di.Inject;
import org.apache.cayenne.map.Attribute;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.resource.ResourceLocator;

public class SQLServerAdapter
extends SybaseAdapter {
    private Integer version;
    @Deprecated
    public static final String TRIM_FUNCTION = "RTRIM";
    private final List<String> SYSTEM_SCHEMAS = Arrays.asList("db_accessadmin", "db_backupoperator", "db_datareader", "db_datawriter", "db_ddladmin", "db_denydatareader", "db_denydatawriter", "sys", "db_owner", "db_securityadmin", "INFORMATION_SCHEMA");
    private final List<String> SYSTEM_CATALOGS = Arrays.asList("model", "msdb", "tempdb");

    public SQLServerAdapter(@Inject RuntimeProperties runtimeProperties, @Inject(value="cayenne.server.default_types") List<ExtendedType> defaultExtendedTypes, @Inject(value="cayenne.server.user_types") List<ExtendedType> userExtendedTypes, @Inject(value="cayenne.server.type_factories") List<ExtendedTypeFactory> extendedTypeFactories, @Inject(value="cayenne.server.resource_locator") ResourceLocator resourceLocator, @Inject ValueObjectTypeRegistry valueObjectTypeRegistry) {
        super(runtimeProperties, defaultExtendedTypes, userExtendedTypes, extendedTypeFactories, resourceLocator, valueObjectTypeRegistry);
        this.setSupportsBatchUpdates(true);
    }

    @Override
    public boolean supportsGeneratedKeysForBatchInserts() {
        return false;
    }

    @Override
    public SQLTreeProcessor getSqlTreeProcessor() {
        if (this.getVersion() != null && this.getVersion() >= 12) {
            return new SQLServerTreeProcessorV12();
        }
        return new SQLServerTreeProcessor();
    }

    @Override
    public SQLAction getAction(Query query, DataNode node) {
        return query.createSQLAction(new SQLServerActionBuilder(node, this.getVersion()));
    }

    @Override
    public List<String> getSystemCatalogs() {
        return this.SYSTEM_CATALOGS;
    }

    @Override
    public List<String> getSystemSchemas() {
        return this.SYSTEM_SCHEMAS;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @Override
    public String createUniqueConstraint(DbEntity source, Collection<DbAttribute> columns) {
        if (columns == null || columns.isEmpty()) {
            throw new CayenneRuntimeException("Can't create UNIQUE constraint - no columns specified.", new Object[0]);
        }
        return "CREATE UNIQUE NONCLUSTERED INDEX " + this.uniqueIndexName(source, columns) + " ON " + this.quotingStrategy.quotedFullyQualifiedName(source) + "(" + columns.stream().map(this.quotingStrategy::quotedName).collect(Collectors.joining(", ")) + ") WHERE " + columns.stream().map(this.quotingStrategy::quotedName).map(n -> n + " IS NOT NULL").collect(Collectors.joining(" AND "));
    }

    private String uniqueIndexName(DbEntity source, Collection<DbAttribute> columns) {
        return "_idx_unique_" + source.getName().replace(' ', '_').toLowerCase() + "_" + columns.stream().map(Attribute::getName).map(String::toLowerCase).map(n -> n.replace(' ', '_')).collect(Collectors.joining("_"));
    }
}

