/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token.model;

import org.apache.cayenne.dba.TypesMapping;
import org.apache.cayenne.dbsync.merge.context.MergerContext;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.model.AbstractToModelToken;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;

public class SetColumnTypeToModel
extends AbstractToModelToken.Entity {
    private DbAttribute columnOriginal;
    private DbAttribute columnNew;

    public SetColumnTypeToModel(DbEntity entity, DbAttribute columnOriginal, DbAttribute columnNew) {
        super("Set Column Type", 65, entity);
        this.columnOriginal = columnOriginal;
        this.columnNew = columnNew;
    }

    @Override
    public MergerToken createReverse(MergerTokenFactory factory) {
        return factory.createSetColumnTypeToDb(this.getEntity(), this.columnNew, this.columnOriginal);
    }

    @Override
    public void execute(MergerContext mergerContext) {
        this.columnOriginal.setType(this.columnNew.getType());
        this.columnOriginal.setMaxLength(this.columnNew.getMaxLength());
        this.columnOriginal.setAttributePrecision(this.columnNew.getAttributePrecision());
        this.columnOriginal.setScale(this.columnNew.getScale());
        mergerContext.getDelegate().dbAttributeModified(this.columnOriginal);
    }

    @Override
    public String getTokenValue() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getEntity().getName());
        sb.append(".");
        sb.append(this.columnNew.getName());
        if (this.columnOriginal.getType() != this.columnNew.getType()) {
            sb.append(" type: ");
            sb.append(TypesMapping.getSqlNameByType((int)this.columnOriginal.getType()));
            sb.append(" -> ");
            sb.append(TypesMapping.getSqlNameByType((int)this.columnNew.getType()));
        }
        if (this.columnOriginal.getMaxLength() != this.columnNew.getMaxLength()) {
            sb.append(" maxLength: ");
            sb.append(this.columnOriginal.getMaxLength());
            sb.append(" -> ");
            sb.append(this.columnNew.getMaxLength());
        }
        if (this.columnOriginal.getAttributePrecision() != this.columnNew.getAttributePrecision()) {
            sb.append(" precision: ");
            sb.append(this.columnOriginal.getAttributePrecision());
            sb.append(" -> ");
            sb.append(this.columnNew.getAttributePrecision());
        }
        if (this.columnOriginal.getScale() != this.columnNew.getScale()) {
            sb.append(" scale: ");
            sb.append(this.columnOriginal.getScale());
            sb.append(" -> ");
            sb.append(this.columnNew.getScale());
        }
        return sb.toString();
    }
}

