/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token.db;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.db.AbstractToDbToken;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;

public class SetAllowNullToDb
extends AbstractToDbToken.EntityAndColumn {
    public SetAllowNullToDb(DbEntity entity, DbAttribute column) {
        super("Set Allow Null", 70, entity, column);
    }

    @Override
    public List<String> createSql(DbAdapter adapter) {
        StringBuilder sqlBuffer = new StringBuilder();
        QuotingStrategy context = adapter.getQuotingStrategy();
        sqlBuffer.append("ALTER TABLE ");
        sqlBuffer.append(context.quotedFullyQualifiedName(this.getEntity()));
        sqlBuffer.append(" ALTER COLUMN ");
        sqlBuffer.append(context.quotedName(this.getColumn()));
        sqlBuffer.append(" DROP NOT NULL");
        return Collections.singletonList(sqlBuffer.toString());
    }

    @Override
    public MergerToken createReverse(MergerTokenFactory factory) {
        return factory.createSetNotNullToModel(this.getEntity(), this.getColumn());
    }
}

