/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.exp.parser;

import java.io.IOException;
import java.util.List;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.parser.ExpressionParserTreeConstants;
import org.apache.cayenne.exp.parser.SimpleNode;

public class ASTScalar
extends SimpleNode {
    protected Object value;

    ASTScalar(int id) {
        super(id);
    }

    public ASTScalar() {
        super(21);
    }

    public ASTScalar(Object value) {
        super(21);
        this.setValue(value);
    }

    @Override
    protected Object evaluateNode(Object o) throws Exception {
        return this.value;
    }

    @Override
    public Expression shallowCopy() {
        ASTScalar copy = new ASTScalar(this.id);
        copy.value = this.value;
        return copy;
    }

    @Override
    public void appendAsString(Appendable out) throws IOException {
        SimpleNode.appendScalarAsString(out, this.value, '\"');
    }

    @Override
    public void appendAsEJBQL(List<Object> parameterAccumulator, Appendable out, String rootId) throws IOException {
        ObjectId temp;
        Object scalar = this.value;
        if (scalar instanceof ObjectId && !(temp = (ObjectId)this.value).isTemporary() && temp.getIdSnapshot().size() == 1) {
            scalar = temp.getIdSnapshot().values().iterator().next();
        }
        SimpleNode.encodeScalarAsEJBQL(parameterAccumulator, out, scalar);
    }

    public void setValue(Object value) {
        this.value = value instanceof Persistent ? ((Persistent)value).getObjectId() : value;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    protected String getExpressionOperator(int index) {
        throw new UnsupportedOperationException("No operator for '" + ExpressionParserTreeConstants.jjtNodeName[this.id] + "'");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ASTScalar other = (ASTScalar)o;
        return this.value != null ? this.value.equals(other.value) : other.value == null;
    }

    @Override
    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }
}

