/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.xml;

import org.apache.cayenne.configuration.xml.NamespaceAwareNestedTagHandler;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbJoin;
import org.apache.cayenne.map.DbRelationship;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DbRelationshipHandler
extends NamespaceAwareNestedTagHandler {
    private static final String DB_RELATIONSHIP_TAG = "db-relationship";
    public static final String DB_ATTRIBUTE_PAIR_TAG = "db-attribute-pair";
    private DataMap map;
    private DbRelationship dbRelationship;

    public DbRelationshipHandler(NamespaceAwareNestedTagHandler parentHandler, DataMap map) {
        super(parentHandler);
        this.map = map;
    }

    @Override
    protected boolean processElement(String namespaceURI, String localName, Attributes attributes) throws SAXException {
        switch (localName) {
            case "db-relationship": {
                this.createRelationship(attributes);
                return true;
            }
            case "db-attribute-pair": {
                this.createDbAttributePair(attributes);
                return true;
            }
        }
        return false;
    }

    private void createRelationship(Attributes attributes) throws SAXException {
        String name = attributes.getValue("name");
        if (name == null) {
            throw new SAXException("DbRelationshipHandler::createRelationship() - missing \"name\" attribute.");
        }
        String sourceName = attributes.getValue("source");
        if (sourceName == null) {
            throw new SAXException("DbRelationshipHandler::createRelationship() - null source entity");
        }
        DbEntity source = this.map.getDbEntity(sourceName);
        if (source == null) {
            return;
        }
        this.dbRelationship = new DbRelationship(name);
        this.dbRelationship.setSourceEntity(source);
        this.dbRelationship.setTargetEntityName(attributes.getValue("target"));
        this.dbRelationship.setToMany("true".equalsIgnoreCase(attributes.getValue("toMany")));
        this.dbRelationship.setToDependentPK("true".equalsIgnoreCase(attributes.getValue("toDependentPK")));
        source.addRelationship(this.dbRelationship);
    }

    private void createDbAttributePair(Attributes attributes) {
        DbJoin join = new DbJoin(this.dbRelationship);
        join.setSourceName(attributes.getValue("source"));
        join.setTargetName(attributes.getValue("target"));
        this.dbRelationship.addJoin(join);
    }

    public DbRelationship getDbRelationship() {
        return this.dbRelationship;
    }
}

