/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.sql.DataSource;
import org.apache.cayenne.access.DataDomain;
import org.apache.cayenne.configuration.server.CayenneServerModuleProvider;
import org.apache.cayenne.configuration.server.DataSourceFactory;
import org.apache.cayenne.configuration.server.FixedDataSourceFactory;
import org.apache.cayenne.configuration.server.FixedJNDIDataSourceFactory;
import org.apache.cayenne.configuration.server.ServerModule;
import org.apache.cayenne.configuration.server.ServerRuntime;
import org.apache.cayenne.configuration.server.SyntheticNodeDataDomainProvider;
import org.apache.cayenne.di.ListBuilder;
import org.apache.cayenne.di.MapBuilder;
import org.apache.cayenne.di.Module;
import org.apache.cayenne.di.spi.ModuleLoader;

public class ServerRuntimeBuilder {
    static final String DEFAULT_NAME = "cayenne";
    private String name;
    private Collection<String> configs = new LinkedHashSet<String>();
    private List<Module> modules = new ArrayList<Module>();
    private DataSourceFactory dataSourceFactory;
    private String jdbcUrl;
    private String jdbcDriver;
    private String jdbcUser;
    private String jdbcPassword;
    private int jdbcMinConnections;
    private int jdbcMaxConnections;
    private long maxQueueWaitTime;
    private String validationQuery;
    private boolean autoLoadModules;

    protected ServerRuntimeBuilder(String name) {
        this.name = name;
        this.autoLoadModules = true;
    }

    public ServerRuntimeBuilder disableModulesAutoLoading() {
        this.autoLoadModules = false;
        return this;
    }

    public ServerRuntimeBuilder dataSource(DataSource dataSource) {
        this.dataSourceFactory = new FixedDataSourceFactory(dataSource);
        return this;
    }

    public ServerRuntimeBuilder jndiDataSource(String location) {
        this.dataSourceFactory = new FixedJNDIDataSourceFactory(location);
        return this;
    }

    public ServerRuntimeBuilder url(String url) {
        this.jdbcUrl = url;
        return this;
    }

    public ServerRuntimeBuilder jdbcDriver(String driver) {
        this.jdbcDriver = driver;
        return this;
    }

    public ServerRuntimeBuilder validationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
        return this;
    }

    public ServerRuntimeBuilder maxQueueWaitTime(long maxQueueWaitTime) {
        this.maxQueueWaitTime = maxQueueWaitTime;
        return this;
    }

    public ServerRuntimeBuilder user(String user) {
        this.jdbcUser = user;
        return this;
    }

    public ServerRuntimeBuilder password(String password) {
        this.jdbcPassword = password;
        return this;
    }

    public ServerRuntimeBuilder minConnections(int minConnections) {
        this.jdbcMinConnections = minConnections;
        return this;
    }

    public ServerRuntimeBuilder maxConnections(int maxConnections) {
        this.jdbcMaxConnections = maxConnections;
        return this;
    }

    public ServerRuntimeBuilder addConfig(String configurationLocation) {
        this.configs.add(configurationLocation);
        return this;
    }

    public ServerRuntimeBuilder addConfigs(String ... configurationLocations) {
        if (configurationLocations != null) {
            this.configs.addAll(Arrays.asList(configurationLocations));
        }
        return this;
    }

    public ServerRuntimeBuilder addConfigs(Collection<String> configurationLocations) {
        this.configs.addAll(configurationLocations);
        return this;
    }

    public ServerRuntimeBuilder addModule(Module module) {
        this.modules.add(module);
        return this;
    }

    public ServerRuntimeBuilder addModules(Collection<Module> modules) {
        this.modules.addAll(modules);
        return this;
    }

    public ServerRuntime build() {
        ArrayList<Module> allModules = new ArrayList<Module>();
        allModules.addAll(this.autoLoadModules ? this.autoLoadedModules() : this.defaultModules());
        allModules.addAll(this.modules);
        allModules.addAll(this.builderModules());
        return new ServerRuntime(allModules);
    }

    private Collection<? extends Module> autoLoadedModules() {
        return new ModuleLoader().load(CayenneServerModuleProvider.class);
    }

    private Collection<? extends Module> defaultModules() {
        return Collections.singleton(new ServerModule());
    }

    private Collection<? extends Module> builderModules() {
        String nameOverride;
        ArrayList<Module> modules = new ArrayList<Module>();
        if (!this.configs.isEmpty()) {
            modules.add(binder -> {
                ListBuilder<String> locationsBinder = ServerModule.contributeProjectLocations(binder);
                for (String c : this.configs) {
                    locationsBinder.add((Object)c);
                }
            });
        }
        if ((nameOverride = this.name) == null && this.configs.size() != 1) {
            nameOverride = DEFAULT_NAME;
        }
        if (nameOverride != null) {
            String finalNameOverride = nameOverride;
            modules.add(binder -> ServerModule.contributeProperties(binder).put("cayenne.server.domain.name", (Object)finalNameOverride));
        }
        if (this.dataSourceFactory != null) {
            modules.add(binder -> {
                binder.bind(DataDomain.class).toProvider(SyntheticNodeDataDomainProvider.class);
                binder.bind(DataSourceFactory.class).toInstance((Object)this.dataSourceFactory);
            });
        } else if (this.jdbcUrl != null && this.jdbcDriver != null) {
            modules.add(binder -> {
                binder.bind(DataDomain.class).toProvider(SyntheticNodeDataDomainProvider.class);
                MapBuilder props = ServerModule.contributeProperties(binder).put("cayenne.jdbc.driver", (Object)this.jdbcDriver).put("cayenne.jdbc.url", (Object)this.jdbcUrl);
                if (this.jdbcUser != null) {
                    props.put("cayenne.jdbc.username", (Object)this.jdbcUser);
                }
                if (this.jdbcPassword != null) {
                    props.put("cayenne.jdbc.password", (Object)this.jdbcPassword);
                }
                if (this.jdbcMinConnections > 0) {
                    props.put("cayenne.jdbc.min_connections", (Object)Integer.toString(this.jdbcMinConnections));
                }
                if (this.jdbcMaxConnections > 0) {
                    props.put("cayenne.jdbc.max_connections", (Object)Integer.toString(this.jdbcMaxConnections));
                }
                if (this.maxQueueWaitTime > 0L) {
                    props.put("cayenne.jdbc.max_wait", (Object)Long.toString(this.maxQueueWaitTime));
                }
                if (this.validationQuery != null) {
                    props.put("cayenne.jdbc.validation_query", (Object)this.validationQuery);
                }
            });
        }
        return modules;
    }
}

