/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.sqlbuilder;

import java.util.Objects;
import org.apache.cayenne.access.sqlbuilder.ExpressionTrait;
import org.apache.cayenne.access.sqlbuilder.OrderingNodeBuilder;
import org.apache.cayenne.access.sqlbuilder.sqltree.ColumnNode;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.access.sqlbuilder.sqltree.UnescapedColumnNode;
import org.apache.cayenne.map.DbAttribute;

public class ColumnNodeBuilder
implements ExpressionTrait {
    private final String table;
    private final String column;
    private boolean unescaped;
    private String alias;
    private DbAttribute attribute;

    ColumnNodeBuilder(String table, String field) {
        this.table = table;
        this.column = Objects.requireNonNull(field);
    }

    ColumnNodeBuilder(String table, DbAttribute attribute) {
        this.table = table;
        this.column = Objects.requireNonNull(attribute).getName();
        this.attribute = attribute;
    }

    public ColumnNodeBuilder as(String alias) {
        this.alias = alias;
        return this;
    }

    public ColumnNodeBuilder unescaped() {
        this.unescaped = true;
        return this;
    }

    public ColumnNodeBuilder attribute(DbAttribute attribute) {
        this.attribute = attribute;
        return this;
    }

    public OrderingNodeBuilder desc() {
        return new OrderingNodeBuilder(this).desc();
    }

    public OrderingNodeBuilder asc() {
        return new OrderingNodeBuilder(this).asc();
    }

    @Override
    public Node build() {
        if (this.unescaped) {
            return new UnescapedColumnNode(this.table, this.column, this.alias, this.attribute);
        }
        return new ColumnNode(this.table, this.column, this.alias, this.attribute);
    }
}

