/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.util.ResultIteratorIterator;

public class LimitResultIterator<T>
implements ResultIterator<T> {
    protected ResultIterator<T> delegate;
    protected Map<String, Object> nextDataObjectIds;
    protected int fetchLimit;
    protected int offset;
    protected int fetchedSoFar;
    protected boolean nextRow;

    public LimitResultIterator(ResultIterator<T> delegate, int offset, int fetchLimit) {
        if (delegate == null) {
            throw new NullPointerException("Null delegate iterator.");
        }
        this.delegate = delegate;
        this.offset = offset;
        this.fetchLimit = fetchLimit;
        this.checkOffset();
        this.checkNextRow();
    }

    @Override
    public Iterator<T> iterator() {
        return new ResultIteratorIterator(this);
    }

    private void checkOffset() {
        for (int i = 0; i < this.offset && this.delegate.hasNextRow(); ++i) {
            this.delegate.nextRow();
        }
    }

    private void checkNextRow() {
        this.nextRow = false;
        if ((this.fetchLimit <= 0 || this.fetchedSoFar < this.fetchLimit) && this.delegate.hasNextRow()) {
            this.nextRow = true;
            ++this.fetchedSoFar;
        }
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public List<T> allRows() {
        ArrayList<T> list = new ArrayList<T>();
        while (this.hasNextRow()) {
            list.add(this.nextRow());
        }
        return list;
    }

    @Override
    public boolean hasNextRow() {
        return this.nextRow;
    }

    @Override
    public T nextRow() {
        if (!this.hasNextRow()) {
            throw new NoSuchElementException("An attempt to read uninitialized row or past the end of the iterator.");
        }
        T row = this.delegate.nextRow();
        this.checkNextRow();
        return row;
    }

    @Override
    public void skipRow() {
        this.delegate.skipRow();
    }
}

