/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.mariadb;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.cayenne.configuration.server.DbAdapterDetector;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.mysql.MySQLAdapter;
import org.apache.cayenne.di.AdhocObjectFactory;
import org.apache.cayenne.di.Inject;

public class MariaDBSniffer
implements DbAdapterDetector {
    public static final String DEFAULT_STORAGE_ENGINE = "InnoDB";
    protected AdhocObjectFactory objectFactory;

    public MariaDBSniffer(@Inject AdhocObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    @Override
    public DbAdapter createAdapter(DatabaseMetaData md) throws SQLException {
        String dbName = md.getDatabaseProductName();
        if (dbName == null || !dbName.toUpperCase().contains("MARIADB")) {
            return null;
        }
        MySQLAdapter adapter = (MySQLAdapter)this.objectFactory.newInstance(MySQLAdapter.class, MySQLAdapter.class.getName());
        adapter.setStorageEngine(DEFAULT_STORAGE_ENGINE);
        return adapter;
    }
}

