/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.rop;

import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.SerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.cayenne.rop.ROPSerializationService;

public class HessianROPSerializationService
implements ROPSerializationService {
    protected SerializerFactory serializerFactory;

    public HessianROPSerializationService(SerializerFactory serializerFactory) {
        this.serializerFactory = serializerFactory;
    }

    @Override
    public byte[] serialize(Object object) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        HessianOutput out = new HessianOutput((OutputStream)bytes);
        out.setSerializerFactory(this.serializerFactory);
        out.writeObject(object);
        out.flush();
        return bytes.toByteArray();
    }

    @Override
    public void serialize(Object object, OutputStream outputStream) throws IOException {
        HessianOutput out = new HessianOutput(outputStream);
        out.setSerializerFactory(this.serializerFactory);
        out.writeObject(object);
        out.flush();
    }

    @Override
    public <T> T deserialize(byte[] serializedObject, Class<T> objectClass) throws IOException {
        HessianInput in = new HessianInput((InputStream)new ByteArrayInputStream(serializedObject));
        in.setSerializerFactory(this.serializerFactory);
        return objectClass.cast(in.readObject());
    }

    @Override
    public <T> T deserialize(InputStream input, Class<T> objectClass) throws IOException {
        HessianInput in = new HessianInput(input);
        in.setSerializerFactory(this.serializerFactory);
        return objectClass.cast(in.readObject());
    }
}

