/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dbsync.merge.token.db;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.dbsync.merge.factory.MergerTokenFactory;
import org.apache.cayenne.dbsync.merge.token.MergerToken;
import org.apache.cayenne.dbsync.merge.token.db.AbstractToDbToken;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;

public class SetGeneratedFlagToDb
extends AbstractToDbToken.EntityAndColumn {
    private final boolean isGenerated;

    public SetGeneratedFlagToDb(DbEntity entity, DbAttribute column, boolean isGenerated) {
        super("Set Is Generated", isGenerated ? 111 : 109, entity, column);
        this.isGenerated = isGenerated;
    }

    @Override
    public MergerToken createReverse(MergerTokenFactory factory) {
        return factory.createSetGeneratedFlagToModel(this.getEntity(), this.getColumn(), !this.isGenerated);
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    protected void appendAutoIncrement(DbAdapter adapter, StringBuffer builder) {
        throw new UnsupportedOperationException("Not supported on generic DB");
    }

    protected void appendDropAutoIncrement(DbAdapter adapter, StringBuffer builder) {
        throw new UnsupportedOperationException("Not supported on generic DB");
    }

    protected void appendAlterColumnClause(DbAdapter adapter, StringBuffer builder) {
        QuotingStrategy context = adapter.getQuotingStrategy();
        builder.append(" ALTER COLUMN ").append(context.quotedName(this.getColumn())).append(" ");
    }

    @Override
    public List<String> createSql(DbAdapter adapter) {
        if (!adapter.supportsGeneratedKeys()) {
            return Collections.EMPTY_LIST;
        }
        QuotingStrategy context = adapter.getQuotingStrategy();
        StringBuffer builder = new StringBuffer();
        builder.append("ALTER TABLE ").append(context.quotedFullyQualifiedName(this.getEntity()));
        this.appendAlterColumnClause(adapter, builder);
        if (this.isGenerated) {
            this.appendAutoIncrement(adapter, builder);
        } else {
            this.appendDropAutoIncrement(adapter, builder);
        }
        return Collections.singletonList(builder.toString());
    }
}

