/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.editor.datanode;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.cayenne.configuration.PasswordEncoding;
import org.apache.cayenne.modeler.Application;
import org.apache.cayenne.modeler.util.JTextFieldUndoable;

public class PasswordEncoderView
extends JPanel {
    protected JComboBox passwordEncoder = Application.getWidgetFactory().createUndoableComboBox();
    protected JComboBox passwordLocation = Application.getWidgetFactory().createUndoableComboBox();
    protected JTextField passwordKey;
    protected JTextField passwordSource = new JTextFieldUndoable();
    protected JLabel passwordSourceLabel;
    private static final String PASSWORD_CLASSPATH = "Classpath Search (File System)";
    private static final String PASSWORD_EXECUTABLE = "Executable Program";
    private static final String PASSWORD_MODEL = "Cayenne Model";
    private static final String PASSWORD_URL = "URL (file:, http:, etc)";
    private static final Object[] PASSWORD_LOCATIONS = new Object[]{"model", "classpath", "executable", "url"};
    private static final Map<String, String> passwordSourceLabels = new TreeMap<String, String>();

    public PasswordEncoderView() {
        this.passwordKey = new JTextFieldUndoable();
        this.passwordEncoder.setModel(new DefaultComboBoxModel<String>(PasswordEncoding.standardEncoders));
        this.passwordEncoder.setEditable(true);
        this.passwordLocation = Application.getWidgetFactory().createUndoableComboBox();
        this.passwordLocation.setRenderer(new PasswordLocationRenderer());
        DefaultComboBoxModel<Object> passwordLocationModel = new DefaultComboBoxModel<Object>(PASSWORD_LOCATIONS);
        this.passwordLocation.setModel(passwordLocationModel);
        CellConstraints cc = new CellConstraints();
        FormLayout layout = new FormLayout("right:80dlu, 3dlu, fill:50dlu, 3dlu, fill:74dlu, 3dlu, fill:70dlu", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.addSeparator("Encoder", cc.xywh(1, 1, 7, 1));
        builder.addLabel("Password Encoder:", cc.xy(1, 11));
        builder.add((Component)this.passwordEncoder, cc.xywh(3, 11, 5, 1));
        builder.addLabel("Password Encoder Key:", cc.xy(1, 13));
        builder.add((Component)this.passwordKey, cc.xywh(3, 13, 5, 1));
        builder.addLabel("Note: Cayenne supplied encoders do not use a key.", cc.xywh(3, 15, 5, 1));
        builder.addLabel("Password Location:", cc.xy(1, 17));
        builder.add((Component)this.passwordLocation, cc.xywh(3, 17, 5, 1));
        this.passwordSourceLabel = builder.addLabel("Password Source:", cc.xy(1, 19));
        builder.add((Component)this.passwordSource, cc.xywh(3, 19, 5, 1));
        this.setLayout(new BorderLayout());
        this.add((Component)builder.getPanel(), "Center");
    }

    public JComboBox getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public JComboBox getPasswordLocation() {
        return this.passwordLocation;
    }

    public JTextField getPasswordKey() {
        return this.passwordKey;
    }

    public JTextField getPasswordSource() {
        return this.passwordSource;
    }

    public JLabel getPasswordSourceLabel() {
        return this.passwordSourceLabel;
    }

    static {
        passwordSourceLabels.put("model", PASSWORD_MODEL);
        passwordSourceLabels.put("classpath", PASSWORD_CLASSPATH);
        passwordSourceLabels.put("executable", PASSWORD_EXECUTABLE);
        passwordSourceLabels.put("url", PASSWORD_URL);
    }

    final class PasswordLocationRenderer
    extends DefaultListCellRenderer {
        PasswordLocationRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object object, int arg2, boolean arg3, boolean arg4) {
            object = object != null ? passwordSourceLabels.get(object) : PasswordEncoderView.PASSWORD_MODEL;
            return super.getListCellRendererComponent((JList<?>)list, object, arg2, arg3, arg4);
        }
    }
}

