/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.db.load;

import java.util.ArrayList;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.cayenne.dbsync.reverse.dbimport.Catalog;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.ExcludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.FilterContainer;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeColumn;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeProcedure;
import org.apache.cayenne.dbsync.reverse.dbimport.IncludeTable;
import org.apache.cayenne.dbsync.reverse.dbimport.PatternParam;
import org.apache.cayenne.dbsync.reverse.dbimport.ReverseEngineering;
import org.apache.cayenne.dbsync.reverse.dbimport.Schema;

public class DbImportTreeNode
extends DefaultMutableTreeNode {
    private boolean isLoaded;

    public DbImportTreeNode() {
        this(null);
    }

    private DbImportTreeNode(Object userObject, boolean allowsChildren) {
        this.userObject = userObject;
        this.allowsChildren = allowsChildren;
        this.parent = null;
    }

    public boolean isIncludeTable() {
        return this.getUserObject().getClass() == IncludeTable.class;
    }

    public boolean isExcludeTable() {
        return this.getUserObject().getClass() == ExcludeTable.class;
    }

    public boolean isIncludeColumn() {
        return this.getUserObject().getClass() == IncludeColumn.class;
    }

    public boolean isExcludeColumn() {
        return this.getUserObject().getClass() == ExcludeColumn.class;
    }

    public boolean isExcludeProcedure() {
        return this.getUserObject().getClass() == ExcludeProcedure.class;
    }

    public boolean isIncludeProcedure() {
        return this.getUserObject().getClass() == IncludeProcedure.class;
    }

    public boolean isLabel() {
        return this.getUserObject().getClass() == String.class;
    }

    public boolean isSchema() {
        return this.getUserObject().getClass() == Schema.class;
    }

    public boolean isCatalog() {
        return this.getUserObject().getClass() == Catalog.class;
    }

    public boolean isReverseEngineering() {
        return this.getUserObject().getClass() == ReverseEngineering.class;
    }

    public DbImportTreeNode(Object userObject) {
        this(userObject, true);
    }

    public boolean parentsIsEqual(DbImportTreeNode reverseEngineeringNode) {
        ArrayList<DbImportTreeNode> reverseEngineeringNodeParents = reverseEngineeringNode == null ? new ArrayList() : reverseEngineeringNode.getParents();
        ArrayList<DbImportTreeNode> dbNodeParents = this.getParents();
        for (DbImportTreeNode node : reverseEngineeringNodeParents) {
            int deleteIndex = -1;
            for (int i = 0; i < dbNodeParents.size(); ++i) {
                if (!node.getSimpleNodeName().equals(dbNodeParents.get(i).getSimpleNodeName())) continue;
                deleteIndex = i;
                break;
            }
            if (deleteIndex != -1) {
                dbNodeParents.remove(deleteIndex);
                continue;
            }
            return false;
        }
        return true;
    }

    public ArrayList<DbImportTreeNode> getParents() {
        ArrayList<DbImportTreeNode> parents = new ArrayList<DbImportTreeNode>();
        DbImportTreeNode tmpNode = this;
        while (tmpNode.getParent() != null) {
            parents.add(tmpNode.getParent());
            tmpNode = tmpNode.getParent();
        }
        return parents;
    }

    @Override
    public DbImportTreeNode getParent() {
        return (DbImportTreeNode)super.getParent();
    }

    protected String getFormattedName(String className, String nodeName) {
        if (nodeName == null) {
            return className;
        }
        return String.format("%s", nodeName);
    }

    protected String getNodeName() {
        if (this.userObject instanceof FilterContainer) {
            return this.getFormattedName(this.userObject.getClass().getSimpleName(), ((FilterContainer)this.userObject).getName());
        }
        if (this.userObject instanceof PatternParam) {
            return this.getFormattedName(this.userObject.getClass().getSimpleName(), ((PatternParam)this.userObject).getPattern());
        }
        if (this.userObject != null) {
            return this.userObject.toString();
        }
        return "";
    }

    public String getSimpleNodeName() {
        if (this.userObject instanceof ReverseEngineering) {
            return "";
        }
        if (this.userObject instanceof FilterContainer) {
            return ((FilterContainer)this.userObject).getName();
        }
        if (this.userObject instanceof PatternParam) {
            return ((PatternParam)this.userObject).getPattern();
        }
        return "";
    }

    @Override
    public String toString() {
        if (this.userObject == null) {
            return "";
        }
        if (this.userObject instanceof ReverseEngineering) {
            return "Reverse Engineering Configuration:";
        }
        return this.getNodeName();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DbImportTreeNode objNode = (DbImportTreeNode)obj;
        if (!objNode.getSimpleNodeName().equals(this.getSimpleNodeName())) {
            return false;
        }
        return objNode.getUserObject().getClass() == this.getUserObject().getClass();
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public void setLoaded(boolean loaded) {
        this.isLoaded = loaded;
    }
}

