/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.di.spi;

import org.apache.cayenne.di.DIRuntimeException;
import org.apache.cayenne.di.DecoratorBuilder;
import org.apache.cayenne.di.Key;
import org.apache.cayenne.di.spi.ConstructorInjectingDecoratorProvider;
import org.apache.cayenne.di.spi.DecoratorProvider;
import org.apache.cayenne.di.spi.DefaultInjector;
import org.apache.cayenne.di.spi.FieldInjectingDecoratorProvider;

class DefaultDecoratorBuilder<T>
implements DecoratorBuilder<T> {
    private Key<T> bindingKey;
    private DefaultInjector injector;

    DefaultDecoratorBuilder(Key<T> bindingKey, DefaultInjector injector) {
        this.bindingKey = bindingKey;
        this.injector = injector;
    }

    @Override
    public DecoratorBuilder<T> after(Class<? extends T> decoratorImplementationType) throws DIRuntimeException {
        this.injector.putDecorationAfter(this.bindingKey, this.decoratorProvider(decoratorImplementationType));
        return this;
    }

    @Override
    public DecoratorBuilder<T> before(Class<? extends T> decoratorImplementationType) throws DIRuntimeException {
        this.injector.putDecorationBefore(this.bindingKey, this.decoratorProvider(decoratorImplementationType));
        return this;
    }

    private DecoratorProvider<T> decoratorProvider(Class<? extends T> decoratorType) {
        ConstructorInjectingDecoratorProvider<? extends T> provider0 = new ConstructorInjectingDecoratorProvider<T>(decoratorType, this.injector);
        FieldInjectingDecoratorProvider<? extends T> provider1 = new FieldInjectingDecoratorProvider<T>(decoratorType, provider0, this.injector);
        return provider1;
    }
}

