/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.translator.ejbql;

import java.util.Collection;
import org.apache.cayenne.access.translator.ejbql.EJBQLMultiColumnOperand;
import org.apache.cayenne.access.translator.ejbql.EJBQLPathTranslator;
import org.apache.cayenne.access.translator.ejbql.EJBQLTranslationContext;
import org.apache.cayenne.ejbql.EJBQLBaseVisitor;
import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.ejbql.EJBQLExpression;
import org.apache.cayenne.ejbql.EJBQLExpressionVisitor;
import org.apache.cayenne.ejbql.parser.EJBQLAggregateColumn;
import org.apache.cayenne.ejbql.parser.EJBQLIntegerLiteral;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjAttribute;
import org.apache.cayenne.map.ObjRelationship;
import org.apache.cayenne.reflect.ClassDescriptor;

class EJBQLAggregateColumnTranslator
extends EJBQLBaseVisitor {
    private EJBQLTranslationContext context;
    private String attributeType;

    EJBQLAggregateColumnTranslator(EJBQLTranslationContext context) {
        this.context = context;
    }

    @Override
    public boolean visitCount(EJBQLAggregateColumn expression) {
        this.visitAggregateColumn(expression, new CountColumnVisitor());
        return false;
    }

    @Override
    public boolean visitAverage(EJBQLAggregateColumn expression) {
        this.visitAggregateColumn(expression, new FieldPathTranslator());
        return false;
    }

    @Override
    public boolean visitMax(EJBQLAggregateColumn expression) {
        this.visitAggregateColumn(expression, new FieldPathTranslator());
        return false;
    }

    @Override
    public boolean visitMin(EJBQLAggregateColumn expression) {
        this.visitAggregateColumn(expression, new FieldPathTranslator());
        return false;
    }

    @Override
    public boolean visitSum(EJBQLAggregateColumn expression) {
        this.visitAggregateColumn(expression, new FieldPathTranslator());
        return false;
    }

    private void visitAggregateColumn(EJBQLAggregateColumn column, EJBQLExpressionVisitor pathVisitor) {
        if (this.context.isAppendingResultColumns()) {
            this.context.append(" #result('");
        } else {
            this.context.append(' ');
        }
        this.context.append(column.getFunction()).append('(');
        column.visit(pathVisitor);
        this.context.append(')');
        if (this.context.isAppendingResultColumns()) {
            this.context.append("' '").append(column.getJavaType(this.attributeType)).append("' '").append(this.context.nextColumnAlias()).append("')");
        }
    }

    private DbAttribute getPk(DbEntity dbEntity) {
        for (DbAttribute attribute : dbEntity.getPrimaryKeys()) {
            if (!attribute.isMandatory()) continue;
            return attribute;
        }
        return dbEntity.getPrimaryKeys().iterator().next();
    }

    class CountColumnVisitor
    extends EJBQLBaseVisitor {
        CountColumnVisitor() {
        }

        @Override
        public boolean visitDistinct(EJBQLExpression expression) {
            EJBQLAggregateColumnTranslator.this.context.append("DISTINCT ");
            return true;
        }

        @Override
        public boolean visitIntegerLiteral(EJBQLIntegerLiteral expression) {
            EJBQLAggregateColumnTranslator.this.context.append(expression.getText());
            return false;
        }

        @Override
        public boolean visitIdentifier(EJBQLExpression expression) {
            ClassDescriptor classDescriptor = EJBQLAggregateColumnTranslator.this.context.getCompiledExpression().getEntityDescriptor(expression.getText());
            if (classDescriptor == null) {
                throw new EJBQLException("Unmapped id variable: " + expression.getText(), new Object[0]);
            }
            DbEntity dbEntity = classDescriptor.getEntity().getDbEntity();
            String tableName = EJBQLAggregateColumnTranslator.this.context.getQuotingStrategy().quotedFullyQualifiedName(dbEntity);
            EJBQLAggregateColumnTranslator.this.context.append(EJBQLAggregateColumnTranslator.this.context.getTableAlias(expression.getText(), tableName)).append('.').append(EJBQLAggregateColumnTranslator.this.context.getQuotingStrategy().quotedName(EJBQLAggregateColumnTranslator.this.getPk(dbEntity)));
            return false;
        }

        @Override
        public boolean visitPath(EJBQLExpression expression, int finishedChildIndex) {
            expression.visit(new FieldPathTranslator());
            return false;
        }
    }

    class FieldPathTranslator
    extends EJBQLPathTranslator {
        FieldPathTranslator() {
            super(EJBQLAggregateColumnTranslator.this.context);
        }

        @Override
        public boolean visitDistinct(EJBQLExpression expression) {
            EJBQLAggregateColumnTranslator.this.context.append("DISTINCT ");
            return true;
        }

        @Override
        protected void appendMultiColumnPath(EJBQLMultiColumnOperand operand) {
            throw new EJBQLException("Can't use multi-column paths in column clause", new Object[0]);
        }

        @Override
        protected void processTerminatingAttribute(ObjAttribute attribute) {
            EJBQLAggregateColumnTranslator.this.attributeType = attribute.getType();
            DbEntity table = this.currentEntity.getDbEntity();
            String alias = this.lastAlias != null ? this.lastAlias : EJBQLAggregateColumnTranslator.this.context.getTableAlias(this.idPath, EJBQLAggregateColumnTranslator.this.context.getQuotingStrategy().quotedFullyQualifiedName(table));
            EJBQLAggregateColumnTranslator.this.context.append(alias).append('.').append(EJBQLAggregateColumnTranslator.this.context.getQuotingStrategy().quotedName(attribute.getDbAttribute()));
        }

        @Override
        protected void processTerminatingRelationship(ObjRelationship relationship) {
            Collection<DbAttribute> dbAttr = relationship.getTargetEntity().getDbEntity().getAttributes();
            if (dbAttr.size() > 0) {
                this.resolveJoin();
            }
            DbAttribute pk = EJBQLAggregateColumnTranslator.this.getPk(relationship.getTargetEntity().getDbEntity());
            EJBQLAggregateColumnTranslator.this.context.append(this.lastAlias).append('.').append(EJBQLAggregateColumnTranslator.this.context.getQuotingStrategy().quotedName(pk));
        }
    }
}

