/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.Persistent;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.access.DataContext;
import org.apache.cayenne.exp.Expression;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.query.ObjectSelect;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.util.Util;

public class IncrementalFaultList<E>
implements List<E>,
Serializable {
    protected int pageSize;
    protected final List elements;
    protected DataContext dataContext;
    protected ObjEntity rootEntity;
    protected int unfetchedObjects;
    protected int idWidth;
    IncrementalListHelper helper;
    protected QueryMetadata metadata;
    protected int maxFetchSize;

    public IncrementalFaultList(DataContext dataContext, Query query, int maxFetchSize) {
        this.metadata = query.getMetaData(dataContext.getEntityResolver());
        if (this.metadata.getPageSize() <= 0) {
            throw new CayenneRuntimeException("Not a paginated query; page size: " + this.metadata.getPageSize(), new Object[0]);
        }
        this.dataContext = dataContext;
        this.pageSize = this.metadata.getPageSize();
        this.rootEntity = this.metadata.getObjEntity();
        if (this.rootEntity == null) {
            throw new CayenneRuntimeException("Pagination is not supported for queries not rooted in an ObjEntity", new Object[0]);
        }
        this.idWidth = this.metadata.getDbEntity().getPrimaryKeys().size();
        ArrayList<Object> elementsUnsynced = new ArrayList<Object>();
        this.fillIn(query, elementsUnsynced);
        this.elements = Collections.synchronizedList(elementsUnsynced);
        this.maxFetchSize = maxFetchSize;
    }

    IncrementalListHelper createHelper(QueryMetadata metadata) {
        if (metadata.isFetchingDataRows()) {
            return new DataRowListHelper();
        }
        return new PersistentListHelper();
    }

    IncrementalListHelper getHelper() {
        if (this.helper == null) {
            this.helper = this.createHelper(this.metadata);
        }
        return this.helper;
    }

    protected void fillIn(Query query, List<Object> elementsList) {
        elementsList.clear();
        try (ResultIterator it = this.dataContext.performIteratedQuery(query);){
            while (it.hasNextRow()) {
                elementsList.add(it.nextRow());
            }
        }
        this.unfetchedObjects = elementsList.size();
    }

    public void resolveAll() {
        this.resolveInterval(0, this.size());
    }

    private void validateListObject(Object object) throws IllegalArgumentException {
        if (this.metadata.isFetchingDataRows()) {
            if (!(object instanceof Map)) {
                throw new IllegalArgumentException("Only Map objects can be stored in this list.");
            }
        } else if (!(object instanceof Persistent)) {
            throw new IllegalArgumentException("Only DataObjects can be stored in this list.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveInterval(int fromIndex, int toIndex) {
        if (fromIndex >= toIndex) {
            return;
        }
        List list = this.elements;
        synchronized (list) {
            if (this.elements.size() == 0) {
                return;
            }
            if (fromIndex < 0) {
                fromIndex = 0;
            }
            if (toIndex > this.elements.size()) {
                toIndex = this.elements.size();
            }
            ArrayList<Expression> quals = new ArrayList<Expression>(this.pageSize);
            ArrayList ids = new ArrayList(this.pageSize);
            for (int i = fromIndex; i < toIndex; ++i) {
                Object object = this.elements.get(i);
                if (!this.getHelper().unresolvedSuspect(object)) continue;
                quals.add(this.buildIdQualifier(object));
                ids.add(object);
            }
            int qualsSize = quals.size();
            if (qualsSize == 0) {
                return;
            }
            ArrayList<Object> objects = new ArrayList<Object>(qualsSize);
            int fetchSize = this.maxFetchSize > 0 ? this.maxFetchSize : Integer.MAX_VALUE;
            int fetchEnd = Math.min(qualsSize, fetchSize);
            int fetchBegin = 0;
            while (fetchBegin < qualsSize) {
                ObjectSelect<Persistent> query = this.createSelectQuery(quals.subList(fetchBegin, fetchEnd));
                objects.addAll(this.dataContext.performQuery(query));
                fetchBegin = fetchEnd;
                fetchEnd += Math.min(fetchSize, qualsSize - fetchEnd);
            }
            this.checkPageResultConsistency(objects, ids);
            this.updatePageWithResults(objects, fromIndex, toIndex);
        }
    }

    void updatePageWithResults(List<Object> objects, int fromIndex, int toIndex) {
        for (Object object : objects) {
            this.getHelper().updateWithResolvedObjectInRange(object, fromIndex, toIndex);
        }
        this.unfetchedObjects -= objects.size();
    }

    ObjectSelect<Persistent> createSelectQuery(List<Expression> expressions) {
        ObjectSelect<Persistent> query = ObjectSelect.query(Persistent.class).entityName(this.rootEntity.getName()).where(ExpressionFactory.joinExp(1, expressions));
        if (this.metadata.isFetchingDataRows()) {
            query.fetchDataRows();
        } else if (this.metadata.getPrefetchTree() != null) {
            query.prefetch(this.metadata.getPrefetchTree());
        }
        return query;
    }

    Expression buildIdQualifier(Object id) {
        Map map = (Map)id;
        if (map.isEmpty()) {
            throw new CayenneRuntimeException("Empty id map", new Object[0]);
        }
        return ExpressionFactory.matchAllDbExp(map, 3);
    }

    void checkPageResultConsistency(List<?> objects, List<?> ids) {
        if (objects.size() == ids.size()) {
            return;
        }
        if (objects.size() > ids.size()) {
            throw new CayenneRuntimeException("Expected %d objects, retrieved %d", ids.size(), objects.size());
        }
        StringBuilder buffer = null;
        boolean first = true;
        for (Object id : ids) {
            boolean found = false;
            for (Object object : objects) {
                if (!this.getHelper().replacesObject(object, id)) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (buffer == null) {
                buffer = new StringBuilder();
            }
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(id.toString());
        }
        if (buffer != null) {
            buffer.insert(0, "Some ObjectIds are missing from the database. Expected " + ids.size() + ", fetched " + objects.size());
            throw new CayenneRuntimeException(buffer.toString(), new Object[0]);
        }
    }

    public int pageIndex(int elementIndex) {
        if (elementIndex < 0 || elementIndex > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + elementIndex);
        }
        if (this.pageSize <= 0) {
            return -1;
        }
        return elementIndex / this.pageSize;
    }

    public int getMaxFetchSize() {
        return this.maxFetchSize;
    }

    public void setMaxFetchSize(int fetchSize) {
        this.maxFetchSize = fetchSize;
    }

    public DataContext getDataContext() {
        return this.dataContext;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public ListIterator<E> listIterator() {
        return new IncrementalListIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new IncrementalListIterator(index);
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int listIndex = 0;

            @Override
            public boolean hasNext() {
                return this.listIndex < IncrementalFaultList.this.elements.size();
            }

            @Override
            public E next() {
                if (this.listIndex >= IncrementalFaultList.this.elements.size()) {
                    throw new NoSuchElementException("no more elements");
                }
                return IncrementalFaultList.this.get(this.listIndex++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not supported.");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, Object element) {
        this.validateListObject(element);
        List list = this.elements;
        synchronized (list) {
            this.elements.add(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(Object o) {
        this.validateListObject(o);
        List list = this.elements;
        synchronized (list) {
            return this.elements.add(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        List list = this.elements;
        synchronized (list) {
            return this.elements.addAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        List list = this.elements;
        synchronized (list) {
            return this.elements.addAll(index, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        List list = this.elements;
        synchronized (list) {
            this.elements.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        List list = this.elements;
        synchronized (list) {
            return this.elements.contains(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        List list = this.elements;
        synchronized (list) {
            return this.elements.containsAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int index) {
        List list = this.elements;
        synchronized (list) {
            Object o = this.elements.get(index);
            if (this.getHelper().unresolvedSuspect(o)) {
                int pageStart = this.pageIndex(index) * this.pageSize;
                this.resolveInterval(pageStart, pageStart + this.pageSize);
                return this.elements.get(index);
            }
            return o;
        }
    }

    @Override
    public int indexOf(Object o) {
        return this.getHelper().indexOfObject(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        List list = this.elements;
        synchronized (list) {
            return this.elements.isEmpty();
        }
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.getHelper().lastIndexOfObject(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        List list = this.elements;
        synchronized (list) {
            E object = this.get(index);
            this.elements.remove(index);
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        List list = this.elements;
        synchronized (list) {
            return this.elements.remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        List list = this.elements;
        synchronized (list) {
            return this.elements.removeAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        List list = this.elements;
        synchronized (list) {
            return this.elements.retainAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, Object element) {
        this.validateListObject(element);
        List list = this.elements;
        synchronized (list) {
            return (E)this.elements.set(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        List list = this.elements;
        synchronized (list) {
            return this.elements.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        List list = this.elements;
        synchronized (list) {
            this.resolveInterval(fromIndex, toIndex);
            return this.elements.subList(fromIndex, toIndex);
        }
    }

    @Override
    public Object[] toArray() {
        this.resolveAll();
        return this.elements.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.resolveAll();
        return this.elements.toArray(a);
    }

    public int getUnfetchedObjects() {
        return this.unfetchedObjects;
    }

    class DataRowListHelper
    extends IncrementalListHelper {
        DataRowListHelper() {
        }

        @Override
        boolean unresolvedSuspect(Object object) {
            return !(object instanceof Map);
        }

        @Override
        boolean objectsAreEqual(Object object, Object objectInTheList) {
            if (object == null && objectInTheList == null) {
                return true;
            }
            if (object != null && objectInTheList != null) {
                Map id = (Map)objectInTheList;
                Map map = (Map)object;
                if (id.size() != map.size()) {
                    return false;
                }
                for (Map.Entry entry : id.entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (Util.nullSafeEquals(value, map.get(key))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        @Override
        boolean replacesObject(Object object, Object objectInTheList) {
            Map id = (Map)objectInTheList;
            if (id.size() > IncrementalFaultList.this.idWidth) {
                return false;
            }
            Map map = (Map)object;
            for (Map.Entry entry : id.entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (Util.nullSafeEquals(value, map.get(key))) continue;
                return false;
            }
            return true;
        }
    }

    class PersistentListHelper
    extends IncrementalListHelper {
        PersistentListHelper() {
        }

        @Override
        boolean unresolvedSuspect(Object object) {
            return !(object instanceof Persistent);
        }

        @Override
        boolean objectsAreEqual(Object object, Object objectInTheList) {
            if (objectInTheList instanceof Persistent) {
                return object == objectInTheList;
            }
            return ((Persistent)object).getObjectId().getIdSnapshot().equals(objectInTheList);
        }

        @Override
        boolean replacesObject(Object object, Object objectInTheList) {
            if (objectInTheList instanceof Persistent) {
                return false;
            }
            Persistent dataObject = (Persistent)object;
            return dataObject.getObjectId().getIdSnapshot().equals(objectInTheList);
        }
    }

    abstract class IncrementalListHelper
    implements Serializable {
        IncrementalListHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int indexOfObject(Object object) {
            if (this.unresolvedSuspect(object)) {
                return -1;
            }
            List list = IncrementalFaultList.this.elements;
            synchronized (list) {
                for (int i = 0; i < IncrementalFaultList.this.elements.size(); ++i) {
                    if (!this.objectsAreEqual(object, IncrementalFaultList.this.elements.get(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int lastIndexOfObject(Object object) {
            if (this.unresolvedSuspect(object)) {
                return -1;
            }
            List list = IncrementalFaultList.this.elements;
            synchronized (list) {
                for (int i = IncrementalFaultList.this.elements.size() - 1; i >= 0; --i) {
                    if (!this.objectsAreEqual(object, IncrementalFaultList.this.elements.get(i))) continue;
                    return i;
                }
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateWithResolvedObjectInRange(Object object, int from, int to) {
            boolean found = false;
            List list = IncrementalFaultList.this.elements;
            synchronized (list) {
                for (int i = from; i < to; ++i) {
                    if (!this.replacesObject(object, IncrementalFaultList.this.elements.get(i))) continue;
                    IncrementalFaultList.this.elements.set(i, object);
                    found = true;
                    break;
                }
            }
            if (!found) {
                throw new CayenneRuntimeException("Can't find id for %s", object);
            }
        }

        abstract boolean unresolvedSuspect(Object var1);

        abstract boolean objectsAreEqual(Object var1, Object var2);

        abstract boolean replacesObject(Object var1, Object var2);
    }

    class IncrementalListIterator
    implements ListIterator<E> {
        int listIndex;

        public IncrementalListIterator(int startIndex) {
            this.listIndex = startIndex;
        }

        @Override
        public void add(Object o) {
            throw new UnsupportedOperationException("add operation not supported");
        }

        @Override
        public boolean hasNext() {
            return this.listIndex < IncrementalFaultList.this.elements.size();
        }

        @Override
        public boolean hasPrevious() {
            return this.listIndex > 0;
        }

        @Override
        public E next() {
            if (this.listIndex >= IncrementalFaultList.this.elements.size()) {
                throw new NoSuchElementException("at the end of the list");
            }
            return IncrementalFaultList.this.get(this.listIndex++);
        }

        @Override
        public int nextIndex() {
            return this.listIndex;
        }

        @Override
        public E previous() {
            if (this.listIndex < 1) {
                throw new NoSuchElementException("at the beginning of the list");
            }
            return IncrementalFaultList.this.get(--this.listIndex);
        }

        @Override
        public int previousIndex() {
            return this.listIndex - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove operation not supported");
        }

        @Override
        public void set(Object o) {
            IncrementalFaultList.this.set(this.listIndex - 1, o);
        }
    }
}

