/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.crypto.transformer.bytes;

import java.security.Key;
import java.security.SecureRandom;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.crypto.Cipher;
import org.apache.cayenne.crypto.cipher.CipherFactory;
import org.apache.cayenne.crypto.key.KeySource;
import org.apache.cayenne.crypto.transformer.bytes.BytesDecryptor;
import org.apache.cayenne.crypto.transformer.bytes.BytesEncryptor;
import org.apache.cayenne.crypto.transformer.bytes.BytesTransformerFactory;
import org.apache.cayenne.crypto.transformer.bytes.CbcDecryptor;
import org.apache.cayenne.crypto.transformer.bytes.CbcEncryptor;
import org.apache.cayenne.crypto.transformer.bytes.GzipDecryptor;
import org.apache.cayenne.crypto.transformer.bytes.GzipEncryptor;
import org.apache.cayenne.crypto.transformer.bytes.Header;
import org.apache.cayenne.crypto.transformer.bytes.HeaderDecryptor;
import org.apache.cayenne.crypto.transformer.bytes.HeaderEncryptor;
import org.apache.cayenne.crypto.transformer.bytes.HmacEncryptor;

class CbcBytesTransformerFactory
implements BytesTransformerFactory {
    private CipherFactory cipherFactory;
    private Key key;
    private Header encryptionHeader;
    private int blockSize;
    private KeySource keySource;
    private Queue<SecureRandom> randoms = new ConcurrentLinkedQueue<SecureRandom>();

    CbcBytesTransformerFactory(CipherFactory cipherFactory, KeySource keySource, Header encryptionHeader) {
        this.keySource = keySource;
        this.cipherFactory = cipherFactory;
        this.blockSize = cipherFactory.blockSize();
        this.encryptionHeader = encryptionHeader;
        String keyName = keySource.getDefaultKeyAlias();
        this.key = keySource.getKey(keyName);
    }

    protected byte[] generateSeedIv() {
        byte[] iv = new byte[this.blockSize];
        SecureRandom random = this.randoms.poll();
        if (random == null) {
            random = this.createSecureRandom();
        }
        random.nextBytes(iv);
        this.randoms.add(random);
        return iv;
    }

    private SecureRandom createSecureRandom() {
        SecureRandom result = new SecureRandom();
        result.nextInt();
        return result;
    }

    @Override
    public BytesEncryptor encryptor() {
        Cipher cipher = this.cipherFactory.cipher();
        BytesEncryptor delegate = new CbcEncryptor(cipher, this.key, this.generateSeedIv());
        if (this.encryptionHeader.isCompressed()) {
            delegate = new GzipEncryptor(delegate);
        }
        if (this.encryptionHeader.haveHMAC()) {
            delegate = new HmacEncryptor(delegate, this.encryptionHeader, this.key);
        }
        return new HeaderEncryptor(delegate, this.encryptionHeader);
    }

    @Override
    public BytesDecryptor decryptor() {
        Cipher cipher = this.cipherFactory.cipher();
        CbcDecryptor cbcDecryptor = new CbcDecryptor(cipher);
        GzipDecryptor gzipDecryptor = new GzipDecryptor(cbcDecryptor);
        return new HeaderDecryptor(cbcDecryptor, gzipDecryptor, this.keySource);
    }
}

