/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.apache.causeway.client.kroviz.ui.panel

import io.kvision.core.CssSize
import io.kvision.core.UNIT
import io.kvision.maps.Maps
import io.kvision.panel.SimplePanel
import io.kvision.utils.obj
import org.apache.causeway.client.kroviz.utils.ScalableVectorGraphic

class SvgMap : SimplePanel() {

    @Deprecated("pass in as arg")
    val str =
        """<?xml version="1.0" encoding="UTF-8" standalone="no"?><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" contentScriptType="application/ecmascript" contentStyleType="text/css" height="4881.25px" preserveAspectRatio="none" style="width:6395px;height:4881px;" version="1.1" viewBox="0 0 6395 4881" width="6395.8333px" zoomAndPan="magnify"><defs><filter height="300%" id="f1o3ddckp2b3gs" width="300%" x="-1" y="-1"><feGaussianBlur result="blurOut" stdDeviation="4.166666666666667"/><feColorMatrix in="blurOut" result="blurOut2" type="matrix" values="0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 .4 0"/><feOffset dx="8.333333333333334" dy="8.333333333333334" in="blurOut2" result="blurOut3"/><feBlend in="SourceGraphic" in2="blurOut3" mode="normal"/></filter></defs><g><!--class root--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="215.2995" id="root" style="stroke: #A80036; stroke-width: 3.125;" width="164.5833" x="2752.0833" y="16.6667"/><ellipse cx="2807.7083" cy="50" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M2813.4701,41.4063 Q2813.7956,40.9505 2814.1862,40.7227 Q2814.5768,40.4948 2815.0326,40.4948 Q2815.8138,40.4948 2816.3021,41.0482 Q2816.7904,41.569 2816.7904,42.8385 L2816.7904,45.8659 Q2816.7904,47.1354 2816.3021,47.6888 Q2815.8138,48.2422 2815.0326,48.2422 Q2814.3164,48.2422 2813.8932,47.819 Q2813.4701,47.4284 2813.2422,46.3542 Q2813.1445,45.6055 2812.7539,45.2148 Q2812.0703,44.4336 2810.8008,43.9779 Q2809.5313,43.5221 2808.2292,43.5221 Q2806.6341,43.5221 2805.2995,44.2057 Q2803.9974,44.8893 2802.9557,46.4518 Q2801.9466,48.0143 2801.9466,50.1628 L2801.9466,52.4414 Q2801.9466,55.013 2803.8021,56.7383 Q2805.6576,58.431 2808.9779,58.431 Q2810.931,58.431 2812.2982,57.9102 Q2813.112,57.5846 2813.9909,56.6732 Q2814.5443,56.1198 2814.8372,55.957 Q2815.1628,55.7943 2815.5859,55.7943 Q2816.2695,55.7943 2816.7904,56.3477 Q2817.3438,56.8685 2817.3438,57.5846 Q2817.3438,58.3008 2816.6276,59.1471 Q2815.5859,60.3516 2813.9258,61.0352 Q2811.6797,61.9792 2808.9779,61.9792 Q2805.8203,61.9792 2803.3138,60.6771 Q2801.263,59.6354 2799.8307,57.4219 Q2798.3984,55.1758 2798.3984,52.5065 L2798.3984,50.0977 Q2798.3984,47.3307 2799.668,44.9544 Q2800.9701,42.5456 2803.2487,41.276 Q2805.5273,39.974 2808.099,39.974 Q2809.6289,39.974 2810.9635,40.332 Q2812.3307,40.6576 2813.4701,41.4063 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="43.75" x="2842.2917" y="60.2295">root</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="2754.1667" x2="2914.5833" y1="83.3333" y2="83.3333"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="139.5833" x="2764.5833" y="152.6143">cssClass: null</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2754.1667" x2="2783.3333" y1="114.4124" y2="114.4124"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="2783.3333" y="122.7478">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2885.4167" x2="2914.5833" y1="114.4124" y2="114.4124"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="125" x="2764.5833" y="218.5974">row: [Array]</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2754.1667" x2="2795.8333" y1="180.3955" y2="180.3955"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="77.0833" x="2795.8333" y="188.7309">Objects</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2872.9167" x2="2914.5833" y1="180.3955" y2="180.3955"/><!--class root.row--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="221.3786" id="root.row" style="stroke: #A80036; stroke-width: 3.125;" width="193.75" x="2737.5" y="356.25"/><ellipse cx="2807.1875" cy="389.5833" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M2812.9492,380.9896 Q2813.2747,380.5339 2813.6654,380.306 Q2814.056,380.0781 2814.5117,380.0781 Q2815.293,380.0781 2815.7813,380.6315 Q2816.2695,381.1523 2816.2695,382.4219 L2816.2695,385.4492 Q2816.2695,386.7188 2815.7813,387.2721 Q2815.293,387.8255 2814.5117,387.8255 Q2813.7956,387.8255 2813.3724,387.4023 Q2812.9492,387.0117 2812.7214,385.9375 Q2812.6237,385.1888 2812.2331,384.7982 Q2811.5495,384.0169 2810.2799,383.5612 Q2809.0104,383.1055 2807.7083,383.1055 Q2806.1133,383.1055 2804.7786,383.7891 Q2803.4766,384.4727 2802.4349,386.0352 Q2801.4258,387.5977 2801.4258,389.7461 L2801.4258,392.0247 Q2801.4258,394.5964 2803.2813,396.3216 Q2805.1367,398.0143 2808.457,398.0143 Q2810.4102,398.0143 2811.7773,397.4935 Q2812.5911,397.168 2813.4701,396.2565 Q2814.0234,395.7031 2814.3164,395.5404 Q2814.6419,395.3776 2815.0651,395.3776 Q2815.7487,395.3776 2816.2695,395.931 Q2816.8229,396.4518 2816.8229,397.168 Q2816.8229,397.8841 2816.1068,398.7305 Q2815.0651,399.9349 2813.4049,400.6185 Q2811.1589,401.5625 2808.457,401.5625 Q2805.2995,401.5625 2802.793,400.2604 Q2800.7422,399.2188 2799.3099,397.0052 Q2797.8776,394.7591 2797.8776,392.0898 L2797.8776,389.681 Q2797.8776,386.9141 2799.1471,384.5378 Q2800.4492,382.1289 2802.7279,380.8594 Q2805.0065,379.5573 2807.5781,379.5573 Q2809.1081,379.5573 2810.4427,379.9154 Q2811.8099,380.2409 2812.9492,380.9896 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="41.6667" x="2844.8958" y="399.8128">row</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="2739.5833" x2="2929.1667" y1="422.9167" y2="422.9167"/><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2739.5833" x2="2783.3333" y1="453.9958" y2="453.9958"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="2783.3333" y="462.3311">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2885.4167" x2="2929.1667" y1="453.9958" y2="453.9958"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="168.75" x="2750" y="535.435">0: [object Object]</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="168.75" x="2750" y="564.2598">1: [object Object]</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2739.5833" x2="2795.8333" y1="497.2331" y2="497.2331"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="77.0833" x="2795.8333" y="505.5684">Objects</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2872.9167" x2="2929.1667" y1="497.2331" y2="497.2331"/><!--class root.row.0--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="272.9492" id="root.row.0" style="stroke: #A80036; stroke-width: 3.125;" width="212.5" x="2580.2083" y="702.0833"/><ellipse cx="2670.5208" cy="735.4167" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M2676.2826,726.8229 Q2676.6081,726.3672 2676.9987,726.1393 Q2677.3893,725.9115 2677.8451,725.9115 Q2678.6263,725.9115 2679.1146,726.4648 Q2679.6029,726.9857 2679.6029,728.2552 L2679.6029,731.2826 Q2679.6029,732.5521 2679.1146,733.1055 Q2678.6263,733.6589 2677.8451,733.6589 Q2677.1289,733.6589 2676.7057,733.2357 Q2676.2826,732.8451 2676.0547,731.7708 Q2675.957,731.0221 2675.5664,730.6315 Q2674.8828,729.8503 2673.6133,729.3945 Q2672.3438,728.9388 2671.0417,728.9388 Q2669.4466,728.9388 2668.112,729.6224 Q2666.8099,730.306 2665.7682,731.8685 Q2664.7591,733.431 2664.7591,735.5794 L2664.7591,737.8581 Q2664.7591,740.4297 2666.6146,742.1549 Q2668.4701,743.8477 2671.7904,743.8477 Q2673.7435,743.8477 2675.1107,743.3268 Q2675.9245,743.0013 2676.8034,742.0898 Q2677.3568,741.5365 2677.6497,741.3737 Q2677.9753,741.2109 2678.3984,741.2109 Q2679.082,741.2109 2679.6029,741.7643 Q2680.1563,742.2852 2680.1563,743.0013 Q2680.1563,743.7174 2679.4401,744.5638 Q2678.3984,745.7682 2676.7383,746.4518 Q2674.4922,747.3958 2671.7904,747.3958 Q2668.6328,747.3958 2666.1263,746.0938 Q2664.0755,745.0521 2662.6432,742.8385 Q2661.2109,740.5924 2661.2109,737.9232 L2661.2109,735.5143 Q2661.2109,732.7474 2662.4805,730.3711 Q2663.7826,727.9622 2666.0612,726.6927 Q2668.3398,725.3906 2670.9115,725.3906 Q2672.4414,725.3906 2673.776,725.7487 Q2675.1432,726.0742 2676.2826,726.8229 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="14.5833" x="2712.8125" y="745.6462">0</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="2582.2917" x2="2790.625" y1="768.75" y2="768.75"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="187.5" x="2592.7083" y="838.031">metadataError: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="139.5833" x="2592.7083" y="866.8559">cssClass: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="62.5" x="2592.7083" y="895.6807">id: null</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2582.2917" x2="2635.4167" y1="799.8291" y2="799.8291"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="2635.4167" y="808.1645">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2737.5" x2="2790.625" y1="799.8291" y2="799.8291"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="125" x="2592.7083" y="961.6638">cols: [Array]</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2582.2917" x2="2647.9167" y1="923.4619" y2="923.4619"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="77.0833" x="2647.9167" y="931.7973">Objects</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2725" x2="2790.625" y1="923.4619" y2="923.4619"/><!--class root.row.0.cols--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="192.5537" id="root.row.0.cols" style="stroke: #A80036; stroke-width: 3.125;" width="193.75" x="2564.5833" y="1114.5833"/><ellipse cx="2631.4583" cy="1147.9167" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M2637.2201,1139.3229 Q2637.5456,1138.8672 2637.9362,1138.6393 Q2638.3268,1138.4115 2638.7826,1138.4115 Q2639.5638,1138.4115 2640.0521,1138.9648 Q2640.5404,1139.4857 2640.5404,1140.7552 L2640.5404,1143.7826 Q2640.5404,1145.0521 2640.0521,1145.6055 Q2639.5638,1146.1589 2638.7826,1146.1589 Q2638.0664,1146.1589 2637.6432,1145.7357 Q2637.2201,1145.3451 2636.9922,1144.2708 Q2636.8945,1143.5221 2636.5039,1143.1315 Q2635.8203,1142.3503 2634.5508,1141.8945 Q2633.2813,1141.4388 2631.9792,1141.4388 Q2630.3841,1141.4388 2629.0495,1142.1224 Q2627.7474,1142.806 2626.7057,1144.3685 Q2625.6966,1145.931 2625.6966,1148.0794 L2625.6966,1150.3581 Q2625.6966,1152.9297 2627.5521,1154.6549 Q2629.4076,1156.3477 2632.7279,1156.3477 Q2634.681,1156.3477 2636.0482,1155.8268 Q2636.862,1155.5013 2637.7409,1154.5898 Q2638.2943,1154.0365 2638.5872,1153.8737 Q2638.9128,1153.7109 2639.3359,1153.7109 Q2640.0195,1153.7109 2640.5404,1154.2643 Q2641.0938,1154.7852 2641.0938,1155.5013 Q2641.0938,1156.2174 2640.3776,1157.0638 Q2639.3359,1158.2682 2637.6758,1158.9518 Q2635.4297,1159.8958 2632.7279,1159.8958 Q2629.5703,1159.8958 2627.0638,1158.5938 Q2625.013,1157.5521 2623.5807,1155.3385 Q2622.1484,1153.0924 2622.1484,1150.4232 L2622.1484,1148.0143 Q2622.1484,1145.2474 2623.418,1142.8711 Q2624.7201,1140.4622 2626.9987,1139.1927 Q2629.2773,1137.8906 2631.849,1137.8906 Q2633.3789,1137.8906 2634.7135,1138.2487 Q2636.0807,1138.5742 2637.2201,1139.3229 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="47.9167" x="2668.5417" y="1158.1462">cols</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="2566.6667" x2="2756.25" y1="1181.25" y2="1181.25"/><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2566.6667" x2="2610.4167" y1="1212.3291" y2="1212.3291"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="2610.4167" y="1220.6645">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2712.5" x2="2756.25" y1="1212.3291" y2="1212.3291"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="168.75" x="2577.0833" y="1293.7683">0: [object Object]</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2566.6667" x2="2622.9167" y1="1255.5664" y2="1255.5664"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="77.0833" x="2622.9167" y="1263.9018">Objects</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2700" x2="2756.25" y1="1255.5664" y2="1255.5664"/><!--class root.row.0.cols.0--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="192.5537" id="root.row.0.cols.0" style="stroke: #A80036; stroke-width: 3.125;" width="210.4167" x="2220.8333" y="1445.8333"/><ellipse cx="2310.2083" cy="1479.1667" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M2315.9701,1470.5729 Q2316.2956,1470.1172 2316.6862,1469.8893 Q2317.0768,1469.6615 2317.5326,1469.6615 Q2318.3138,1469.6615 2318.8021,1470.2148 Q2319.2904,1470.7357 2319.2904,1472.0052 L2319.2904,1475.0326 Q2319.2904,1476.3021 2318.8021,1476.8555 Q2318.3138,1477.4089 2317.5326,1477.4089 Q2316.8164,1477.4089 2316.3932,1476.9857 Q2315.9701,1476.5951 2315.7422,1475.5208 Q2315.6445,1474.7721 2315.2539,1474.3815 Q2314.5703,1473.6003 2313.3008,1473.1445 Q2312.0313,1472.6888 2310.7292,1472.6888 Q2309.1341,1472.6888 2307.7995,1473.3724 Q2306.4974,1474.056 2305.4557,1475.6185 Q2304.4466,1477.181 2304.4466,1479.3294 L2304.4466,1481.6081 Q2304.4466,1484.1797 2306.3021,1485.9049 Q2308.1576,1487.5977 2311.4779,1487.5977 Q2313.431,1487.5977 2314.7982,1487.0768 Q2315.612,1486.7513 2316.4909,1485.8398 Q2317.0443,1485.2865 2317.3372,1485.1237 Q2317.6628,1484.9609 2318.0859,1484.9609 Q2318.7695,1484.9609 2319.2904,1485.5143 Q2319.8438,1486.0352 2319.8438,1486.7513 Q2319.8438,1487.4674 2319.1276,1488.3138 Q2318.0859,1489.5182 2316.4258,1490.2018 Q2314.1797,1491.1458 2311.4779,1491.1458 Q2308.3203,1491.1458 2305.8138,1489.8438 Q2303.763,1488.8021 2302.3307,1486.5885 Q2300.8984,1484.3424 2300.8984,1481.6732 L2300.8984,1479.2643 Q2300.8984,1476.4974 2302.168,1474.1211 Q2303.4701,1471.7122 2305.7487,1470.4427 Q2308.0273,1469.1406 2310.599,1469.1406 Q2312.1289,1469.1406 2313.4635,1469.4987 Q2314.8307,1469.8242 2315.9701,1470.5729 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="14.5833" x="2352.2917" y="1489.3962">0</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="2222.9167" x2="2429.1667" y1="1512.5" y2="1512.5"/><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2222.9167" x2="2275" y1="1543.5791" y2="1543.5791"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="2275" y="1551.9145">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2377.0833" x2="2429.1667" y1="1543.5791" y2="1543.5791"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="185.4167" x="2233.3333" y="1625.0183">col: [object Object]</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2222.9167" x2="2287.5" y1="1586.8164" y2="1586.8164"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="77.0833" x="2287.5" y="1595.1518">Objects</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2364.5833" x2="2429.1667" y1="1586.8164" y2="1586.8164"/><!--class root.row.0.cols.0.col--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="417.0736" id="root.row.0.cols.0.col" style="stroke: #A80036; stroke-width: 3.125;" width="316.6667" x="2161.4583" y="1762.5"/><ellipse cx="2294.2708" cy="1795.8333" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M2300.0326,1787.2396 Q2300.3581,1786.7839 2300.7487,1786.556 Q2301.1393,1786.3281 2301.5951,1786.3281 Q2302.3763,1786.3281 2302.8646,1786.8815 Q2303.3529,1787.4023 2303.3529,1788.6719 L2303.3529,1791.6992 Q2303.3529,1792.9688 2302.8646,1793.5221 Q2302.3763,1794.0755 2301.5951,1794.0755 Q2300.8789,1794.0755 2300.4557,1793.6523 Q2300.0326,1793.2617 2299.8047,1792.1875 Q2299.707,1791.4388 2299.3164,1791.0482 Q2298.6328,1790.2669 2297.3633,1789.8112 Q2296.0938,1789.3555 2294.7917,1789.3555 Q2293.1966,1789.3555 2291.862,1790.0391 Q2290.5599,1790.7227 2289.5182,1792.2852 Q2288.5091,1793.8477 2288.5091,1795.9961 L2288.5091,1798.2747 Q2288.5091,1800.8464 2290.3646,1802.5716 Q2292.2201,1804.2643 2295.5404,1804.2643 Q2297.4935,1804.2643 2298.8607,1803.7435 Q2299.6745,1803.418 2300.5534,1802.5065 Q2301.1068,1801.9531 2301.3997,1801.7904 Q2301.7253,1801.6276 2302.1484,1801.6276 Q2302.832,1801.6276 2303.3529,1802.181 Q2303.9063,1802.7018 2303.9063,1803.418 Q2303.9063,1804.1341 2303.1901,1804.9805 Q2302.1484,1806.1849 2300.4883,1806.8685 Q2298.2422,1807.8125 2295.5404,1807.8125 Q2292.3828,1807.8125 2289.8763,1806.5104 Q2287.8255,1805.4688 2286.3932,1803.2552 Q2284.9609,1801.0091 2284.9609,1798.3398 L2284.9609,1795.931 Q2284.9609,1793.1641 2286.2305,1790.7878 Q2287.5326,1788.3789 2289.8112,1787.1094 Q2292.0898,1785.8073 2294.6615,1785.8073 Q2296.1914,1785.8073 2297.526,1786.1654 Q2298.8932,1786.4909 2300.0326,1787.2396 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="33.3333" x="2336.9792" y="1806.0628">col</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="2163.5417" x2="2476.0417" y1="1829.1667" y2="1829.1667"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="187.5" x="2173.9583" y="1898.4477">metadataError: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="139.5833" x="2173.9583" y="1927.2725">cssClass: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="87.5" x="2173.9583" y="1956.0974">size: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="62.5" x="2173.9583" y="1984.9223">id: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="87.5" x="2173.9583" y="2013.7472">span: 12</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="266.6667" x="2173.9583" y="2042.572">unreferencedActions: true</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="291.6667" x="2173.9583" y="2071.3969">unreferencedCollections: null</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2163.5417" x2="2268.75" y1="1860.2458" y2="1860.2458"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="2268.75" y="1868.5811">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2370.8333" x2="2476.0417" y1="1860.2458" y2="1860.2458"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="291.6667" x="2173.9583" y="2137.38">domainObject: [object Object]</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="143.75" x="2173.9583" y="2166.2048">action: [Array]</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2163.5417" x2="2281.25" y1="2099.1781" y2="2099.1781"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="77.0833" x="2281.25" y="2107.5134">Objects</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2358.3333" x2="2476.0417" y1="2099.1781" y2="2099.1781"/><!--class root.row.0.cols.0.col.domainObject--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="445.8984" id="root.row.0.cols.0.col.domainObject" style="stroke: #A80036; stroke-width: 3.125;" width="266.6667" x="1538.5417" y="2304.1667"/><ellipse cx="1587.6042" cy="2337.5" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M1593.3659,2328.9063 Q1593.6914,2328.4505 1594.082,2328.2227 Q1594.4727,2327.9948 1594.9284,2327.9948 Q1595.7096,2327.9948 1596.1979,2328.5482 Q1596.6862,2329.069 1596.6862,2330.3385 L1596.6862,2333.3659 Q1596.6862,2334.6354 1596.1979,2335.1888 Q1595.7096,2335.7422 1594.9284,2335.7422 Q1594.2122,2335.7422 1593.7891,2335.319 Q1593.3659,2334.9284 1593.138,2333.8542 Q1593.0404,2333.1055 1592.6497,2332.7148 Q1591.9661,2331.9336 1590.6966,2331.4779 Q1589.4271,2331.0221 1588.125,2331.0221 Q1586.5299,2331.0221 1585.1953,2331.7057 Q1583.8932,2332.3893 1582.8516,2333.9518 Q1581.8424,2335.5143 1581.8424,2337.6628 L1581.8424,2339.9414 Q1581.8424,2342.513 1583.6979,2344.2383 Q1585.5534,2345.931 1588.8737,2345.931 Q1590.8268,2345.931 1592.194,2345.4102 Q1593.0078,2345.0846 1593.8867,2344.1732 Q1594.4401,2343.6198 1594.7331,2343.457 Q1595.0586,2343.2943 1595.4818,2343.2943 Q1596.1654,2343.2943 1596.6862,2343.8477 Q1597.2396,2344.3685 1597.2396,2345.0846 Q1597.2396,2345.8008 1596.5234,2346.6471 Q1595.4818,2347.8516 1593.8216,2348.5352 Q1591.5755,2349.4792 1588.8737,2349.4792 Q1585.7161,2349.4792 1583.2096,2348.1771 Q1581.1589,2347.1354 1579.7266,2344.9219 Q1578.2943,2342.6758 1578.2943,2340.0065 L1578.2943,2337.5977 Q1578.2943,2334.8307 1579.5638,2332.4544 Q1580.8659,2330.0456 1583.1445,2328.776 Q1585.4232,2327.474 1587.9948,2327.474 Q1589.5247,2327.474 1590.8594,2327.832 Q1592.2266,2328.1576 1593.3659,2328.9063 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="160.4167" x="1620.7292" y="2347.7295">domainObject</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="1540.625" x2="1803.125" y1="2370.8333" y2="2370.8333"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="112.5" x="1551.0417" y="2440.1143">named: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="175" x="1551.0417" y="2468.9392">describedAs: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="100" x="1551.0417" y="2497.7641">plural: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="187.5" x="1551.0417" y="2526.5889">metadataError: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="170.8333" x="1551.0417" y="2555.4138">bookmarking: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="139.5833" x="1551.0417" y="2584.2387">cssClass: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="164.5833" x="1551.0417" y="2613.0636">cssClassFa: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="241.6667" x="1551.0417" y="2641.8884">cssClassFaPosition: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="200" x="1551.0417" y="2670.7133">namedEscaped: null</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="1540.625" x2="1620.8333" y1="2401.9124" y2="2401.9124"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="1620.8333" y="2410.2478">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="1722.9167" x2="1803.125" y1="2401.9124" y2="2401.9124"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="187.5" x="1551.0417" y="2736.6964">link: [object Object]</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="1540.625" x2="1633.3333" y1="2698.4945" y2="2698.4945"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="77.0833" x="1633.3333" y="2706.8298">Objects</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="1710.4167" x2="1803.125" y1="2698.4945" y2="2698.4945"/><!--class root.row.0.cols.0.col.domainObject.link--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="235.791" id="root.row.0.cols.0.col.domainObject.link" style="stroke: #A80036; stroke-width: 3.125;" width="895.8333" x="796.875" y="3023.9583"/><ellipse cx="1216.1458" cy="3057.2917" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M1221.9076,3048.6979 Q1222.2331,3048.2422 1222.6237,3048.0143 Q1223.0143,3047.7865 1223.4701,3047.7865 Q1224.2513,3047.7865 1224.7396,3048.3398 Q1225.2279,3048.8607 1225.2279,3050.1302 L1225.2279,3053.1576 Q1225.2279,3054.4271 1224.7396,3054.9805 Q1224.2513,3055.5339 1223.4701,3055.5339 Q1222.7539,3055.5339 1222.3307,3055.1107 Q1221.9076,3054.7201 1221.6797,3053.6458 Q1221.582,3052.8971 1221.1914,3052.5065 Q1220.5078,3051.7253 1219.2383,3051.2695 Q1217.9688,3050.8138 1216.6667,3050.8138 Q1215.0716,3050.8138 1213.737,3051.4974 Q1212.4349,3052.181 1211.3932,3053.7435 Q1210.3841,3055.306 1210.3841,3057.4544 L1210.3841,3059.7331 Q1210.3841,3062.3047 1212.2396,3064.0299 Q1214.0951,3065.7227 1217.4154,3065.7227 Q1219.3685,3065.7227 1220.7357,3065.2018 Q1221.5495,3064.8763 1222.4284,3063.9648 Q1222.9818,3063.4115 1223.2747,3063.2487 Q1223.6003,3063.0859 1224.0234,3063.0859 Q1224.707,3063.0859 1225.2279,3063.6393 Q1225.7813,3064.1602 1225.7813,3064.8763 Q1225.7813,3065.5924 1225.0651,3066.4388 Q1224.0234,3067.6432 1222.3633,3068.3268 Q1220.1172,3069.2708 1217.4154,3069.2708 Q1214.2578,3069.2708 1211.7513,3067.9688 Q1209.7005,3066.9271 1208.2682,3064.7135 Q1206.8359,3062.4674 1206.8359,3059.7982 L1206.8359,3057.3893 Q1206.8359,3054.6224 1208.1055,3052.2461 Q1209.4076,3049.8372 1211.6862,3048.5677 Q1213.9648,3047.2656 1216.5365,3047.2656 Q1218.0664,3047.2656 1219.401,3047.6237 Q1220.7682,3047.9492 1221.9076,3048.6979 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="39.5833" x="1258.8542" y="3067.5212">link</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="798.9583" x2="1690.625" y1="3090.625" y2="3090.625"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="381.25" x="809.375" y="3159.906">rel: urn:org.restfulobjects:rels/element</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="127.0833" x="809.375" y="3188.7309">method: GET</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="658.3333" x="809.375" y="3217.5557">href: http://localhost:8080/restful/objects/isisApplib.FixtureResult/;</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="870.8333" x="809.375" y="3246.3806">type: application/jsonprofile&amp;#x3D;&amp;quot;urn:org.restfulobjects:repr-types/object&amp;quot;</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="798.9583" x2="1193.75" y1="3121.7041" y2="3121.7041"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="1193.75" y="3130.0395">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="1295.8333" x2="1690.625" y1="3121.7041" y2="3121.7041"/><!--class root.row.0.cols.0.col.action--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="279.0283" id="root.row.0.cols.0.col.action" style="stroke: #A80036; stroke-width: 3.125;" width="193.75" x="2222.9167" y="2387.5"/><ellipse cx="2280.4167" cy="2420.8333" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M2286.1784,2412.2396 Q2286.5039,2411.7839 2286.8945,2411.556 Q2287.2852,2411.3281 2287.7409,2411.3281 Q2288.5221,2411.3281 2289.0104,2411.8815 Q2289.4987,2412.4023 2289.4987,2413.6719 L2289.4987,2416.6992 Q2289.4987,2417.9688 2289.0104,2418.5221 Q2288.5221,2419.0755 2287.7409,2419.0755 Q2287.0247,2419.0755 2286.6016,2418.6523 Q2286.1784,2418.2617 2285.9505,2417.1875 Q2285.8529,2416.4388 2285.4622,2416.0482 Q2284.7786,2415.2669 2283.5091,2414.8112 Q2282.2396,2414.3555 2280.9375,2414.3555 Q2279.3424,2414.3555 2278.0078,2415.0391 Q2276.7057,2415.7227 2275.6641,2417.2852 Q2274.6549,2418.8477 2274.6549,2420.9961 L2274.6549,2423.2747 Q2274.6549,2425.8464 2276.5104,2427.5716 Q2278.3659,2429.2643 2281.6862,2429.2643 Q2283.6393,2429.2643 2285.0065,2428.7435 Q2285.8203,2428.418 2286.6992,2427.5065 Q2287.2526,2426.9531 2287.5456,2426.7904 Q2287.8711,2426.6276 2288.2943,2426.6276 Q2288.9779,2426.6276 2289.4987,2427.181 Q2290.0521,2427.7018 2290.0521,2428.418 Q2290.0521,2429.1341 2289.3359,2429.9805 Q2288.2943,2431.1849 2286.6341,2431.8685 Q2284.388,2432.8125 2281.6862,2432.8125 Q2278.5286,2432.8125 2276.0221,2431.5104 Q2273.9714,2430.4688 2272.5391,2428.2552 Q2271.1068,2426.0091 2271.1068,2423.3398 L2271.1068,2420.931 Q2271.1068,2418.1641 2272.3763,2415.7878 Q2273.6784,2413.3789 2275.957,2412.1094 Q2278.2357,2410.8073 2280.8073,2410.8073 Q2282.3372,2410.8073 2283.6719,2411.1654 Q2285.0391,2411.4909 2286.1784,2412.2396 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="68.75" x="2315.4167" y="2431.0628">action</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="2225" x2="2414.5833" y1="2454.1667" y2="2454.1667"/><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2225" x2="2268.75" y1="2485.2458" y2="2485.2458"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="2268.75" y="2493.5811">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2370.8333" x2="2414.5833" y1="2485.2458" y2="2485.2458"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="168.75" x="2235.4167" y="2566.685">0: [object Object]</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="168.75" x="2235.4167" y="2595.5098">1: [object Object]</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="168.75" x="2235.4167" y="2624.3347">2: [object Object]</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="168.75" x="2235.4167" y="2653.1596">3: [object Object]</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2225" x2="2281.25" y1="2528.4831" y2="2528.4831"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="77.0833" x="2281.25" y="2536.8184">Objects</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2358.3333" x2="2414.5833" y1="2528.4831" y2="2528.4831"/><!--class root.row.0.cols.0.col.action.0--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="532.373" id="root.row.0.cols.0.col.action.0" style="stroke: #A80036; stroke-width: 3.125;" width="266.6667" x="1765.625" y="2875"/><ellipse cx="1882.8125" cy="2908.3333" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M1888.5742,2899.7396 Q1888.8997,2899.2839 1889.2904,2899.056 Q1889.681,2898.8281 1890.1367,2898.8281 Q1890.918,2898.8281 1891.4063,2899.3815 Q1891.8945,2899.9023 1891.8945,2901.1719 L1891.8945,2904.1992 Q1891.8945,2905.4688 1891.4063,2906.0221 Q1890.918,2906.5755 1890.1367,2906.5755 Q1889.4206,2906.5755 1888.9974,2906.1523 Q1888.5742,2905.7617 1888.3464,2904.6875 Q1888.2487,2903.9388 1887.8581,2903.5482 Q1887.1745,2902.7669 1885.9049,2902.3112 Q1884.6354,2901.8555 1883.3333,2901.8555 Q1881.7383,2901.8555 1880.4036,2902.5391 Q1879.1016,2903.2227 1878.0599,2904.7852 Q1877.0508,2906.3477 1877.0508,2908.4961 L1877.0508,2910.7747 Q1877.0508,2913.3464 1878.9063,2915.0716 Q1880.7617,2916.7643 1884.082,2916.7643 Q1886.0352,2916.7643 1887.4023,2916.2435 Q1888.2161,2915.918 1889.0951,2915.0065 Q1889.6484,2914.4531 1889.9414,2914.2904 Q1890.2669,2914.1276 1890.6901,2914.1276 Q1891.3737,2914.1276 1891.8945,2914.681 Q1892.4479,2915.2018 1892.4479,2915.918 Q1892.4479,2916.6341 1891.7318,2917.4805 Q1890.6901,2918.6849 1889.0299,2919.3685 Q1886.7839,2920.3125 1884.082,2920.3125 Q1880.9245,2920.3125 1878.418,2919.0104 Q1876.3672,2917.9688 1874.9349,2915.7552 Q1873.5026,2913.5091 1873.5026,2910.8398 L1873.5026,2908.431 Q1873.5026,2905.6641 1874.7721,2903.2878 Q1876.0742,2900.8789 1878.3529,2899.6094 Q1880.6315,2898.3073 1883.2031,2898.3073 Q1884.7331,2898.3073 1886.0677,2898.6654 Q1887.4349,2898.9909 1888.5742,2899.7396 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="14.5833" x="1925.5208" y="2918.5628">0</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="1767.7083" x2="2030.2083" y1="2941.6667" y2="2941.6667"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="112.5" x="1778.125" y="3010.9477">named: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="175" x="1778.125" y="3039.7725">describedAs: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="187.5" x="1778.125" y="3068.5974">metadataError: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="129.1667" x="1778.125" y="3097.4223">id: clearHints</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="170.8333" x="1778.125" y="3126.2472">bookmarking: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="139.5833" x="1778.125" y="3155.072">cssClass: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="164.5833" x="1778.125" y="3183.8969">cssClassFa: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="241.6667" x="1778.125" y="3212.7218">cssClassFaPosition: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="112.5" x="1778.125" y="3241.5466">hidden: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="200" x="1778.125" y="3270.3715">namedEscaped: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="122.9167" x="1778.125" y="3299.1964">position: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="164.5833" x="1778.125" y="3328.0212">promptStyle: null</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="1767.7083" x2="1847.9167" y1="2972.7458" y2="2972.7458"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="1847.9167" y="2981.0811">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="1950" x2="2030.2083" y1="2972.7458" y2="2972.7458"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="187.5" x="1778.125" y="3394.0043">link: [object Object]</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="1767.7083" x2="1860.4167" y1="3355.8024" y2="3355.8024"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="77.0833" x="1860.4167" y="3364.1378">Objects</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="1937.5" x2="2030.2083" y1="3355.8024" y2="3355.8024"/><!--class root.row.0.cols.0.col.action.0.link--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="235.791" id="root.row.0.cols.0.col.action.0.link" style="stroke: #A80036; stroke-width: 3.125;" width="964.5833" x="12.5" y="3555.2083"/><ellipse cx="466.1458" cy="3588.5417" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M471.9076,3579.9479 Q472.2331,3579.4922 472.6237,3579.2643 Q473.0143,3579.0365 473.4701,3579.0365 Q474.2513,3579.0365 474.7396,3579.5898 Q475.2279,3580.1107 475.2279,3581.3802 L475.2279,3584.4076 Q475.2279,3585.6771 474.7396,3586.2305 Q474.2513,3586.7839 473.4701,3586.7839 Q472.7539,3586.7839 472.3307,3586.3607 Q471.9076,3585.9701 471.6797,3584.8958 Q471.582,3584.1471 471.1914,3583.7565 Q470.5078,3582.9753 469.2383,3582.5195 Q467.9688,3582.0638 466.6667,3582.0638 Q465.0716,3582.0638 463.737,3582.7474 Q462.4349,3583.431 461.3932,3584.9935 Q460.3841,3586.556 460.3841,3588.7044 L460.3841,3590.9831 Q460.3841,3593.5547 462.2396,3595.2799 Q464.0951,3596.9727 467.4154,3596.9727 Q469.3685,3596.9727 470.7357,3596.4518 Q471.5495,3596.1263 472.4284,3595.2148 Q472.9818,3594.6615 473.2747,3594.4987 Q473.6003,3594.3359 474.0234,3594.3359 Q474.707,3594.3359 475.2279,3594.8893 Q475.7813,3595.4102 475.7813,3596.1263 Q475.7813,3596.8424 475.0651,3597.6888 Q474.0234,3598.8932 472.3633,3599.5768 Q470.1172,3600.5208 467.4154,3600.5208 Q464.2578,3600.5208 461.7513,3599.2188 Q459.7005,3598.1771 458.2682,3595.9635 Q456.8359,3593.7174 456.8359,3591.0482 L456.8359,3588.6393 Q456.8359,3585.8724 458.1055,3583.4961 Q459.4076,3581.0872 461.6862,3579.8177 Q463.9648,3578.5156 466.5365,3578.5156 Q468.0664,3578.5156 469.401,3578.8737 Q470.7682,3579.1992 471.9076,3579.9479 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="39.5833" x="508.8542" y="3598.7712">link</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="14.5833" x2="975" y1="3621.875" y2="3621.875"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="364.5833" x="25" y="3691.156">rel: urn:org.restfulobjects:rels/action</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="127.0833" x="25" y="3719.9809">method: GET</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="843.75" x="25" y="3748.8057">href: http://localhost:8080/restful/objects/isisApplib.FixtureResult/;/actions/clearHints</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="939.5833" x="25" y="3777.6306">type: application/jsonprofile&amp;#x3D;&amp;quot;urn:org.restfulobjects:repr-types/object-action&amp;quot;</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="14.5833" x2="443.75" y1="3652.9541" y2="3652.9541"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="443.75" y="3661.2895">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="545.8333" x2="975" y1="3652.9541" y2="3652.9541"/><!--class root.row.0.cols.0.col.action.1--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="532.373" id="root.row.0.cols.0.col.action.1" style="stroke: #A80036; stroke-width: 3.125;" width="266.6667" x="2105.2083" y="2875"/><ellipse cx="2222.3958" cy="2908.3333" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M2228.1576,2899.7396 Q2228.4831,2899.2839 2228.8737,2899.056 Q2229.2643,2898.8281 2229.7201,2898.8281 Q2230.5013,2898.8281 2230.9896,2899.3815 Q2231.4779,2899.9023 2231.4779,2901.1719 L2231.4779,2904.1992 Q2231.4779,2905.4688 2230.9896,2906.0221 Q2230.5013,2906.5755 2229.7201,2906.5755 Q2229.0039,2906.5755 2228.5807,2906.1523 Q2228.1576,2905.7617 2227.9297,2904.6875 Q2227.832,2903.9388 2227.4414,2903.5482 Q2226.7578,2902.7669 2225.4883,2902.3112 Q2224.2188,2901.8555 2222.9167,2901.8555 Q2221.3216,2901.8555 2219.987,2902.5391 Q2218.6849,2903.2227 2217.6432,2904.7852 Q2216.6341,2906.3477 2216.6341,2908.4961 L2216.6341,2910.7747 Q2216.6341,2913.3464 2218.4896,2915.0716 Q2220.3451,2916.7643 2223.6654,2916.7643 Q2225.6185,2916.7643 2226.9857,2916.2435 Q2227.7995,2915.918 2228.6784,2915.0065 Q2229.2318,2914.4531 2229.5247,2914.2904 Q2229.8503,2914.1276 2230.2734,2914.1276 Q2230.957,2914.1276 2231.4779,2914.681 Q2232.0313,2915.2018 2232.0313,2915.918 Q2232.0313,2916.6341 2231.3151,2917.4805 Q2230.2734,2918.6849 2228.6133,2919.3685 Q2226.3672,2920.3125 2223.6654,2920.3125 Q2220.5078,2920.3125 2218.0013,2919.0104 Q2215.9505,2917.9688 2214.5182,2915.7552 Q2213.0859,2913.5091 2213.0859,2910.8398 L2213.0859,2908.431 Q2213.0859,2905.6641 2214.3555,2903.2878 Q2215.6576,2900.8789 2217.9362,2899.6094 Q2220.2148,2898.3073 2222.7865,2898.3073 Q2224.3164,2898.3073 2225.651,2898.6654 Q2227.0182,2898.9909 2228.1576,2899.7396 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="14.5833" x="2265.1042" y="2918.5628">1</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="2107.2917" x2="2369.7917" y1="2941.6667" y2="2941.6667"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="112.5" x="2117.7083" y="3010.9477">named: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="175" x="2117.7083" y="3039.7725">describedAs: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="187.5" x="2117.7083" y="3068.5974">metadataError: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="233.3333" x="2117.7083" y="3097.4223">id: downloadLayoutXml</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="170.8333" x="2117.7083" y="3126.2472">bookmarking: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="139.5833" x="2117.7083" y="3155.072">cssClass: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="164.5833" x="2117.7083" y="3183.8969">cssClassFa: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="241.6667" x="2117.7083" y="3212.7218">cssClassFaPosition: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="112.5" x="2117.7083" y="3241.5466">hidden: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="200" x="2117.7083" y="3270.3715">namedEscaped: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="122.9167" x="2117.7083" y="3299.1964">position: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="164.5833" x="2117.7083" y="3328.0212">promptStyle: null</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2107.2917" x2="2187.5" y1="2972.7458" y2="2972.7458"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="2187.5" y="2981.0811">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2289.5833" x2="2369.7917" y1="2972.7458" y2="2972.7458"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="187.5" x="2117.7083" y="3394.0043">link: [object Object]</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2107.2917" x2="2200" y1="3355.8024" y2="3355.8024"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="77.0833" x="2200" y="3364.1378">Objects</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2277.0833" x2="2369.7917" y1="3355.8024" y2="3355.8024"/><!--class root.row.0.cols.0.col.action.1.link--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="235.791" id="root.row.0.cols.0.col.action.1.link" style="stroke: #A80036; stroke-width: 3.125;" width="972.9167" x="1050" y="3555.2083"/><ellipse cx="1507.8125" cy="3588.5417" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M1513.5742,3579.9479 Q1513.8997,3579.4922 1514.2904,3579.2643 Q1514.681,3579.0365 1515.1367,3579.0365 Q1515.918,3579.0365 1516.4063,3579.5898 Q1516.8945,3580.1107 1516.8945,3581.3802 L1516.8945,3584.4076 Q1516.8945,3585.6771 1516.4063,3586.2305 Q1515.918,3586.7839 1515.1367,3586.7839 Q1514.4206,3586.7839 1513.9974,3586.3607 Q1513.5742,3585.9701 1513.3464,3584.8958 Q1513.2487,3584.1471 1512.8581,3583.7565 Q1512.1745,3582.9753 1510.9049,3582.5195 Q1509.6354,3582.0638 1508.3333,3582.0638 Q1506.7383,3582.0638 1505.4036,3582.7474 Q1504.1016,3583.431 1503.0599,3584.9935 Q1502.0508,3586.556 1502.0508,3588.7044 L1502.0508,3590.9831 Q1502.0508,3593.5547 1503.9063,3595.2799 Q1505.7617,3596.9727 1509.082,3596.9727 Q1511.0352,3596.9727 1512.4023,3596.4518 Q1513.2161,3596.1263 1514.0951,3595.2148 Q1514.6484,3594.6615 1514.9414,3594.4987 Q1515.2669,3594.3359 1515.6901,3594.3359 Q1516.3737,3594.3359 1516.8945,3594.8893 Q1517.4479,3595.4102 1517.4479,3596.1263 Q1517.4479,3596.8424 1516.7318,3597.6888 Q1515.6901,3598.8932 1514.0299,3599.5768 Q1511.7839,3600.5208 1509.082,3600.5208 Q1505.9245,3600.5208 1503.418,3599.2188 Q1501.3672,3598.1771 1499.9349,3595.9635 Q1498.5026,3593.7174 1498.5026,3591.0482 L1498.5026,3588.6393 Q1498.5026,3585.8724 1499.7721,3583.4961 Q1501.0742,3581.0872 1503.3529,3579.8177 Q1505.6315,3578.5156 1508.2031,3578.5156 Q1509.7331,3578.5156 1511.0677,3578.8737 Q1512.4349,3579.1992 1513.5742,3579.9479 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="39.5833" x="1550.5208" y="3598.7712">link</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="1052.0833" x2="2020.8333" y1="3621.875" y2="3621.875"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="364.5833" x="1062.5" y="3691.156">rel: urn:org.restfulobjects:rels/action</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="127.0833" x="1062.5" y="3719.9809">method: GET</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="947.9167" x="1062.5" y="3748.8057">href: http://localhost:8080/restful/objects/isisApplib.FixtureResult/;/actions/downloadLayoutXml</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="939.5833" x="1062.5" y="3777.6306">type: application/jsonprofile&amp;#x3D;&amp;quot;urn:org.restfulobjects:repr-types/object-action&amp;quot;</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="1052.0833" x2="1485.4167" y1="3652.9541" y2="3652.9541"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="1485.4167" y="3661.2895">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="1587.5" x2="2020.8333" y1="3652.9541" y2="3652.9541"/><!--class root.row.0.cols.0.col.action.2--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="532.373" id="root.row.0.cols.0.col.action.2" style="stroke: #A80036; stroke-width: 3.125;" width="266.6667" x="2444.7917" y="2875"/><ellipse cx="2561.9792" cy="2908.3333" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M2567.7409,2899.7396 Q2568.0664,2899.2839 2568.457,2899.056 Q2568.8477,2898.8281 2569.3034,2898.8281 Q2570.0846,2898.8281 2570.5729,2899.3815 Q2571.0612,2899.9023 2571.0612,2901.1719 L2571.0612,2904.1992 Q2571.0612,2905.4688 2570.5729,2906.0221 Q2570.0846,2906.5755 2569.3034,2906.5755 Q2568.5872,2906.5755 2568.1641,2906.1523 Q2567.7409,2905.7617 2567.513,2904.6875 Q2567.4154,2903.9388 2567.0247,2903.5482 Q2566.3411,2902.7669 2565.0716,2902.3112 Q2563.8021,2901.8555 2562.5,2901.8555 Q2560.9049,2901.8555 2559.5703,2902.5391 Q2558.2682,2903.2227 2557.2266,2904.7852 Q2556.2174,2906.3477 2556.2174,2908.4961 L2556.2174,2910.7747 Q2556.2174,2913.3464 2558.0729,2915.0716 Q2559.9284,2916.7643 2563.2487,2916.7643 Q2565.2018,2916.7643 2566.569,2916.2435 Q2567.3828,2915.918 2568.2617,2915.0065 Q2568.8151,2914.4531 2569.1081,2914.2904 Q2569.4336,2914.1276 2569.8568,2914.1276 Q2570.5404,2914.1276 2571.0612,2914.681 Q2571.6146,2915.2018 2571.6146,2915.918 Q2571.6146,2916.6341 2570.8984,2917.4805 Q2569.8568,2918.6849 2568.1966,2919.3685 Q2565.9505,2920.3125 2563.2487,2920.3125 Q2560.0911,2920.3125 2557.5846,2919.0104 Q2555.5339,2917.9688 2554.1016,2915.7552 Q2552.6693,2913.5091 2552.6693,2910.8398 L2552.6693,2908.431 Q2552.6693,2905.6641 2553.9388,2903.2878 Q2555.2409,2900.8789 2557.5195,2899.6094 Q2559.7982,2898.3073 2562.3698,2898.3073 Q2563.8997,2898.3073 2565.2344,2898.6654 Q2566.6016,2898.9909 2567.7409,2899.7396 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="14.5833" x="2604.6875" y="2918.5628">2</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="2446.875" x2="2709.375" y1="2941.6667" y2="2941.6667"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="112.5" x="2457.2917" y="3010.9477">named: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="175" x="2457.2917" y="3039.7725">describedAs: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="187.5" x="2457.2917" y="3068.5974">metadataError: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="202.0833" x="2457.2917" y="3097.4223">id: rebuildMetamodel</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="170.8333" x="2457.2917" y="3126.2472">bookmarking: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="139.5833" x="2457.2917" y="3155.072">cssClass: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="164.5833" x="2457.2917" y="3183.8969">cssClassFa: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="241.6667" x="2457.2917" y="3212.7218">cssClassFaPosition: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="112.5" x="2457.2917" y="3241.5466">hidden: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="200" x="2457.2917" y="3270.3715">namedEscaped: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="122.9167" x="2457.2917" y="3299.1964">position: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="164.5833" x="2457.2917" y="3328.0212">promptStyle: null</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2446.875" x2="2527.0833" y1="2972.7458" y2="2972.7458"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="2527.0833" y="2981.0811">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2629.1667" x2="2709.375" y1="2972.7458" y2="2972.7458"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="187.5" x="2457.2917" y="3394.0043">link: [object Object]</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2446.875" x2="2539.5833" y1="3355.8024" y2="3355.8024"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="77.0833" x="2539.5833" y="3364.1378">Objects</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2616.6667" x2="2709.375" y1="3355.8024" y2="3355.8024"/><!--class root.row.0.cols.0.col.action.2.link--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="235.791" id="root.row.0.cols.0.col.action.2.link" style="stroke: #A80036; stroke-width: 3.125;" width="964.5833" x="2095.8333" y="3555.2083"/><ellipse cx="2549.4792" cy="3588.5417" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M2555.2409,3579.9479 Q2555.5664,3579.4922 2555.957,3579.2643 Q2556.3477,3579.0365 2556.8034,3579.0365 Q2557.5846,3579.0365 2558.0729,3579.5898 Q2558.5612,3580.1107 2558.5612,3581.3802 L2558.5612,3584.4076 Q2558.5612,3585.6771 2558.0729,3586.2305 Q2557.5846,3586.7839 2556.8034,3586.7839 Q2556.0872,3586.7839 2555.6641,3586.3607 Q2555.2409,3585.9701 2555.013,3584.8958 Q2554.9154,3584.1471 2554.5247,3583.7565 Q2553.8411,3582.9753 2552.5716,3582.5195 Q2551.3021,3582.0638 2550,3582.0638 Q2548.4049,3582.0638 2547.0703,3582.7474 Q2545.7682,3583.431 2544.7266,3584.9935 Q2543.7174,3586.556 2543.7174,3588.7044 L2543.7174,3590.9831 Q2543.7174,3593.5547 2545.5729,3595.2799 Q2547.4284,3596.9727 2550.7487,3596.9727 Q2552.7018,3596.9727 2554.069,3596.4518 Q2554.8828,3596.1263 2555.7617,3595.2148 Q2556.3151,3594.6615 2556.6081,3594.4987 Q2556.9336,3594.3359 2557.3568,3594.3359 Q2558.0404,3594.3359 2558.5612,3594.8893 Q2559.1146,3595.4102 2559.1146,3596.1263 Q2559.1146,3596.8424 2558.3984,3597.6888 Q2557.3568,3598.8932 2555.6966,3599.5768 Q2553.4505,3600.5208 2550.7487,3600.5208 Q2547.5911,3600.5208 2545.0846,3599.2188 Q2543.0339,3598.1771 2541.6016,3595.9635 Q2540.1693,3593.7174 2540.1693,3591.0482 L2540.1693,3588.6393 Q2540.1693,3585.8724 2541.4388,3583.4961 Q2542.7409,3581.0872 2545.0195,3579.8177 Q2547.2982,3578.5156 2549.8698,3578.5156 Q2551.3997,3578.5156 2552.7344,3578.8737 Q2554.1016,3579.1992 2555.2409,3579.9479 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="39.5833" x="2592.1875" y="3598.7712">link</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="2097.9167" x2="3058.3333" y1="3621.875" y2="3621.875"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="364.5833" x="2108.3333" y="3691.156">rel: urn:org.restfulobjects:rels/action</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="127.0833" x="2108.3333" y="3719.9809">method: GET</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="916.6667" x="2108.3333" y="3748.8057">href: http://localhost:8080/restful/objects/isisApplib.FixtureResult/;/actions/rebuildMetamodel</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="939.5833" x="2108.3333" y="3777.6306">type: application/jsonprofile&amp;#x3D;&amp;quot;urn:org.restfulobjects:repr-types/object-action&amp;quot;</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2097.9167" x2="2527.0833" y1="3652.9541" y2="3652.9541"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="2527.0833" y="3661.2895">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2629.1667" x2="3058.3333" y1="3652.9541" y2="3652.9541"/><!--class root.row.0.cols.0.col.action.3--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="532.373" id="root.row.0.cols.0.col.action.3" style="stroke: #A80036; stroke-width: 3.125;" width="266.6667" x="3132.2917" y="2875"/><ellipse cx="3249.4792" cy="2908.3333" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M3255.2409,2899.7396 Q3255.5664,2899.2839 3255.957,2899.056 Q3256.3477,2898.8281 3256.8034,2898.8281 Q3257.5846,2898.8281 3258.0729,2899.3815 Q3258.5612,2899.9023 3258.5612,2901.1719 L3258.5612,2904.1992 Q3258.5612,2905.4688 3258.0729,2906.0221 Q3257.5846,2906.5755 3256.8034,2906.5755 Q3256.0872,2906.5755 3255.6641,2906.1523 Q3255.2409,2905.7617 3255.013,2904.6875 Q3254.9154,2903.9388 3254.5247,2903.5482 Q3253.8411,2902.7669 3252.5716,2902.3112 Q3251.3021,2901.8555 3250,2901.8555 Q3248.4049,2901.8555 3247.0703,2902.5391 Q3245.7682,2903.2227 3244.7266,2904.7852 Q3243.7174,2906.3477 3243.7174,2908.4961 L3243.7174,2910.7747 Q3243.7174,2913.3464 3245.5729,2915.0716 Q3247.4284,2916.7643 3250.7487,2916.7643 Q3252.7018,2916.7643 3254.069,2916.2435 Q3254.8828,2915.918 3255.7617,2915.0065 Q3256.3151,2914.4531 3256.6081,2914.2904 Q3256.9336,2914.1276 3257.3568,2914.1276 Q3258.0404,2914.1276 3258.5612,2914.681 Q3259.1146,2915.2018 3259.1146,2915.918 Q3259.1146,2916.6341 3258.3984,2917.4805 Q3257.3568,2918.6849 3255.6966,2919.3685 Q3253.4505,2920.3125 3250.7487,2920.3125 Q3247.5911,2920.3125 3245.0846,2919.0104 Q3243.0339,2917.9688 3241.6016,2915.7552 Q3240.1693,2913.5091 3240.1693,2910.8398 L3240.1693,2908.431 Q3240.1693,2905.6641 3241.4388,2903.2878 Q3242.7409,2900.8789 3245.0195,2899.6094 Q3247.2982,2898.3073 3249.8698,2898.3073 Q3251.3997,2898.3073 3252.7344,2898.6654 Q3254.1016,2898.9909 3255.2409,2899.7396 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="14.5833" x="3292.1875" y="2918.5628">3</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="3134.375" x2="3396.875" y1="2941.6667" y2="2941.6667"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="112.5" x="3144.7917" y="3010.9477">named: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="175" x="3144.7917" y="3039.7725">describedAs: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="187.5" x="3144.7917" y="3068.5974">metadataError: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="158.3333" x="3144.7917" y="3097.4223">id: openRestApi</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="170.8333" x="3144.7917" y="3126.2472">bookmarking: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="139.5833" x="3144.7917" y="3155.072">cssClass: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="164.5833" x="3144.7917" y="3183.8969">cssClassFa: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="241.6667" x="3144.7917" y="3212.7218">cssClassFaPosition: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="112.5" x="3144.7917" y="3241.5466">hidden: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="200" x="3144.7917" y="3270.3715">namedEscaped: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="122.9167" x="3144.7917" y="3299.1964">position: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="164.5833" x="3144.7917" y="3328.0212">promptStyle: null</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3134.375" x2="3214.5833" y1="2972.7458" y2="2972.7458"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="3214.5833" y="2981.0811">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3316.6667" x2="3396.875" y1="2972.7458" y2="2972.7458"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="187.5" x="3144.7917" y="3394.0043">link: [object Object]</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3134.375" x2="3227.0833" y1="3355.8024" y2="3355.8024"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="77.0833" x="3227.0833" y="3364.1378">Objects</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3304.1667" x2="3396.875" y1="3355.8024" y2="3355.8024"/><!--class root.row.0.cols.0.col.action.3.link--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="235.791" id="root.row.0.cols.0.col.action.3.link" style="stroke: #A80036; stroke-width: 3.125;" width="964.5833" x="3133.3333" y="3555.2083"/><ellipse cx="3586.9792" cy="3588.5417" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M3592.7409,3579.9479 Q3593.0664,3579.4922 3593.457,3579.2643 Q3593.8477,3579.0365 3594.3034,3579.0365 Q3595.0846,3579.0365 3595.5729,3579.5898 Q3596.0612,3580.1107 3596.0612,3581.3802 L3596.0612,3584.4076 Q3596.0612,3585.6771 3595.5729,3586.2305 Q3595.0846,3586.7839 3594.3034,3586.7839 Q3593.5872,3586.7839 3593.1641,3586.3607 Q3592.7409,3585.9701 3592.513,3584.8958 Q3592.4154,3584.1471 3592.0247,3583.7565 Q3591.3411,3582.9753 3590.0716,3582.5195 Q3588.8021,3582.0638 3587.5,3582.0638 Q3585.9049,3582.0638 3584.5703,3582.7474 Q3583.2682,3583.431 3582.2266,3584.9935 Q3581.2174,3586.556 3581.2174,3588.7044 L3581.2174,3590.9831 Q3581.2174,3593.5547 3583.0729,3595.2799 Q3584.9284,3596.9727 3588.2487,3596.9727 Q3590.2018,3596.9727 3591.569,3596.4518 Q3592.3828,3596.1263 3593.2617,3595.2148 Q3593.8151,3594.6615 3594.1081,3594.4987 Q3594.4336,3594.3359 3594.8568,3594.3359 Q3595.5404,3594.3359 3596.0612,3594.8893 Q3596.6146,3595.4102 3596.6146,3596.1263 Q3596.6146,3596.8424 3595.8984,3597.6888 Q3594.8568,3598.8932 3593.1966,3599.5768 Q3590.9505,3600.5208 3588.2487,3600.5208 Q3585.0911,3600.5208 3582.5846,3599.2188 Q3580.5339,3598.1771 3579.1016,3595.9635 Q3577.6693,3593.7174 3577.6693,3591.0482 L3577.6693,3588.6393 Q3577.6693,3585.8724 3578.9388,3583.4961 Q3580.2409,3581.0872 3582.5195,3579.8177 Q3584.7982,3578.5156 3587.3698,3578.5156 Q3588.8997,3578.5156 3590.2344,3578.8737 Q3591.6016,3579.1992 3592.7409,3579.9479 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="39.5833" x="3629.6875" y="3598.7712">link</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="3135.4167" x2="4095.8333" y1="3621.875" y2="3621.875"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="364.5833" x="3145.8333" y="3691.156">rel: urn:org.restfulobjects:rels/action</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="127.0833" x="3145.8333" y="3719.9809">method: GET</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="872.9167" x="3145.8333" y="3748.8057">href: http://localhost:8080/restful/objects/isisApplib.FixtureResult/;/actions/openRestApi</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="939.5833" x="3145.8333" y="3777.6306">type: application/jsonprofile&amp;#x3D;&amp;quot;urn:org.restfulobjects:repr-types/object-action&amp;quot;</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3135.4167" x2="3564.5833" y1="3652.9541" y2="3652.9541"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="3564.5833" y="3661.2895">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3666.6667" x2="4095.8333" y1="3652.9541" y2="3652.9541"/><!--class root.row.1--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="272.9492" id="root.row.1" style="stroke: #A80036; stroke-width: 3.125;" width="212.5" x="2878.125" y="702.0833"/><ellipse cx="2968.4375" cy="735.4167" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M2974.1992,726.8229 Q2974.5247,726.3672 2974.9154,726.1393 Q2975.306,725.9115 2975.7617,725.9115 Q2976.543,725.9115 2977.0313,726.4648 Q2977.5195,726.9857 2977.5195,728.2552 L2977.5195,731.2826 Q2977.5195,732.5521 2977.0313,733.1055 Q2976.543,733.6589 2975.7617,733.6589 Q2975.0456,733.6589 2974.6224,733.2357 Q2974.1992,732.8451 2973.9714,731.7708 Q2973.8737,731.0221 2973.4831,730.6315 Q2972.7995,729.8503 2971.5299,729.3945 Q2970.2604,728.9388 2968.9583,728.9388 Q2967.3633,728.9388 2966.0286,729.6224 Q2964.7266,730.306 2963.6849,731.8685 Q2962.6758,733.431 2962.6758,735.5794 L2962.6758,737.8581 Q2962.6758,740.4297 2964.5313,742.1549 Q2966.3867,743.8477 2969.707,743.8477 Q2971.6602,743.8477 2973.0273,743.3268 Q2973.8411,743.0013 2974.7201,742.0898 Q2975.2734,741.5365 2975.5664,741.3737 Q2975.8919,741.2109 2976.3151,741.2109 Q2976.9987,741.2109 2977.5195,741.7643 Q2978.0729,742.2852 2978.0729,743.0013 Q2978.0729,743.7174 2977.3568,744.5638 Q2976.3151,745.7682 2974.6549,746.4518 Q2972.4089,747.3958 2969.707,747.3958 Q2966.5495,747.3958 2964.043,746.0938 Q2961.9922,745.0521 2960.5599,742.8385 Q2959.1276,740.5924 2959.1276,737.9232 L2959.1276,735.5143 Q2959.1276,732.7474 2960.3971,730.3711 Q2961.6992,727.9622 2963.9779,726.6927 Q2966.2565,725.3906 2968.8281,725.3906 Q2970.3581,725.3906 2971.6927,725.7487 Q2973.0599,726.0742 2974.1992,726.8229 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="14.5833" x="3010.7292" y="745.6462">1</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="2880.2083" x2="3088.5417" y1="768.75" y2="768.75"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="187.5" x="2890.625" y="838.031">metadataError: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="139.5833" x="2890.625" y="866.8559">cssClass: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="62.5" x="2890.625" y="895.6807">id: null</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2880.2083" x2="2933.3333" y1="799.8291" y2="799.8291"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="2933.3333" y="808.1645">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3035.4167" x2="3088.5417" y1="799.8291" y2="799.8291"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="125" x="2890.625" y="961.6638">cols: [Array]</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2880.2083" x2="2945.8333" y1="923.4619" y2="923.4619"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="77.0833" x="2945.8333" y="931.7973">Objects</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3022.9167" x2="3088.5417" y1="923.4619" y2="923.4619"/><!--class root.row.1.cols--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="221.3786" id="root.row.1.cols" style="stroke: #A80036; stroke-width: 3.125;" width="193.75" x="2939.5833" y="1100"/><ellipse cx="3006.4583" cy="1133.3333" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M3012.2201,1124.7396 Q3012.5456,1124.2839 3012.9362,1124.056 Q3013.3268,1123.8281 3013.7826,1123.8281 Q3014.5638,1123.8281 3015.0521,1124.3815 Q3015.5404,1124.9023 3015.5404,1126.1719 L3015.5404,1129.1992 Q3015.5404,1130.4688 3015.0521,1131.0221 Q3014.5638,1131.5755 3013.7826,1131.5755 Q3013.0664,1131.5755 3012.6432,1131.1523 Q3012.2201,1130.7617 3011.9922,1129.6875 Q3011.8945,1128.9388 3011.5039,1128.5482 Q3010.8203,1127.7669 3009.5508,1127.3112 Q3008.2813,1126.8555 3006.9792,1126.8555 Q3005.3841,1126.8555 3004.0495,1127.5391 Q3002.7474,1128.2227 3001.7057,1129.7852 Q3000.6966,1131.3477 3000.6966,1133.4961 L3000.6966,1135.7747 Q3000.6966,1138.3464 3002.5521,1140.0716 Q3004.4076,1141.7643 3007.7279,1141.7643 Q3009.681,1141.7643 3011.0482,1141.2435 Q3011.862,1140.918 3012.7409,1140.0065 Q3013.2943,1139.4531 3013.5872,1139.2904 Q3013.9128,1139.1276 3014.3359,1139.1276 Q3015.0195,1139.1276 3015.5404,1139.681 Q3016.0938,1140.2018 3016.0938,1140.918 Q3016.0938,1141.6341 3015.3776,1142.4805 Q3014.3359,1143.6849 3012.6758,1144.3685 Q3010.4297,1145.3125 3007.7279,1145.3125 Q3004.5703,1145.3125 3002.0638,1144.0104 Q3000.013,1142.9688 2998.5807,1140.7552 Q2997.1484,1138.5091 2997.1484,1135.8398 L2997.1484,1133.431 Q2997.1484,1130.6641 2998.418,1128.2878 Q2999.7201,1125.8789 3001.9987,1124.6094 Q3004.2773,1123.3073 3006.849,1123.3073 Q3008.3789,1123.3073 3009.7135,1123.6654 Q3011.0807,1123.9909 3012.2201,1124.7396 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="47.9167" x="3043.5417" y="1143.5628">cols</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="2941.6667" x2="3131.25" y1="1166.6667" y2="1166.6667"/><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2941.6667" x2="2985.4167" y1="1197.7458" y2="1197.7458"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="2985.4167" y="1206.0811">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3087.5" x2="3131.25" y1="1197.7458" y2="1197.7458"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="168.75" x="2952.0833" y="1279.185">0: [object Object]</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="168.75" x="2952.0833" y="1308.0098">1: [object Object]</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2941.6667" x2="2997.9167" y1="1240.9831" y2="1240.9831"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="77.0833" x="2997.9167" y="1249.3184">Objects</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3075" x2="3131.25" y1="1240.9831" y2="1240.9831"/><!--class root.row.1.cols.0--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="192.5537" id="root.row.1.cols.0" style="stroke: #A80036; stroke-width: 3.125;" width="210.4167" x="2931.25" y="1445.8333"/><ellipse cx="3020.625" cy="1479.1667" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M3026.3867,1470.5729 Q3026.7122,1470.1172 3027.1029,1469.8893 Q3027.4935,1469.6615 3027.9492,1469.6615 Q3028.7305,1469.6615 3029.2188,1470.2148 Q3029.707,1470.7357 3029.707,1472.0052 L3029.707,1475.0326 Q3029.707,1476.3021 3029.2188,1476.8555 Q3028.7305,1477.4089 3027.9492,1477.4089 Q3027.2331,1477.4089 3026.8099,1476.9857 Q3026.3867,1476.5951 3026.1589,1475.5208 Q3026.0612,1474.7721 3025.6706,1474.3815 Q3024.987,1473.6003 3023.7174,1473.1445 Q3022.4479,1472.6888 3021.1458,1472.6888 Q3019.5508,1472.6888 3018.2161,1473.3724 Q3016.9141,1474.056 3015.8724,1475.6185 Q3014.8633,1477.181 3014.8633,1479.3294 L3014.8633,1481.6081 Q3014.8633,1484.1797 3016.7188,1485.9049 Q3018.5742,1487.5977 3021.8945,1487.5977 Q3023.8477,1487.5977 3025.2148,1487.0768 Q3026.0286,1486.7513 3026.9076,1485.8398 Q3027.4609,1485.2865 3027.7539,1485.1237 Q3028.0794,1484.9609 3028.5026,1484.9609 Q3029.1862,1484.9609 3029.707,1485.5143 Q3030.2604,1486.0352 3030.2604,1486.7513 Q3030.2604,1487.4674 3029.5443,1488.3138 Q3028.5026,1489.5182 3026.8424,1490.2018 Q3024.5964,1491.1458 3021.8945,1491.1458 Q3018.737,1491.1458 3016.2305,1489.8438 Q3014.1797,1488.8021 3012.7474,1486.5885 Q3011.3151,1484.3424 3011.3151,1481.6732 L3011.3151,1479.2643 Q3011.3151,1476.4974 3012.5846,1474.1211 Q3013.8867,1471.7122 3016.1654,1470.4427 Q3018.444,1469.1406 3021.0156,1469.1406 Q3022.5456,1469.1406 3023.8802,1469.4987 Q3025.2474,1469.8242 3026.3867,1470.5729 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="14.5833" x="3062.7083" y="1489.3962">0</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="2933.3333" x2="3139.5833" y1="1512.5" y2="1512.5"/><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2933.3333" x2="2985.4167" y1="1543.5791" y2="1543.5791"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="2985.4167" y="1551.9145">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3087.5" x2="3139.5833" y1="1543.5791" y2="1543.5791"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="185.4167" x="2943.75" y="1625.0183">col: [object Object]</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2933.3333" x2="2997.9167" y1="1586.8164" y2="1586.8164"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="77.0833" x="2997.9167" y="1595.1518">Objects</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3075" x2="3139.5833" y1="1586.8164" y2="1586.8164"/><!--class root.row.1.cols.0.col--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="417.0736" id="root.row.1.cols.0.col" style="stroke: #A80036; stroke-width: 3.125;" width="316.6667" x="2878.125" y="1762.5"/><ellipse cx="3010.9375" cy="1795.8333" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M3016.6992,1787.2396 Q3017.0247,1786.7839 3017.4154,1786.556 Q3017.806,1786.3281 3018.2617,1786.3281 Q3019.043,1786.3281 3019.5313,1786.8815 Q3020.0195,1787.4023 3020.0195,1788.6719 L3020.0195,1791.6992 Q3020.0195,1792.9688 3019.5313,1793.5221 Q3019.043,1794.0755 3018.2617,1794.0755 Q3017.5456,1794.0755 3017.1224,1793.6523 Q3016.6992,1793.2617 3016.4714,1792.1875 Q3016.3737,1791.4388 3015.9831,1791.0482 Q3015.2995,1790.2669 3014.0299,1789.8112 Q3012.7604,1789.3555 3011.4583,1789.3555 Q3009.8633,1789.3555 3008.5286,1790.0391 Q3007.2266,1790.7227 3006.1849,1792.2852 Q3005.1758,1793.8477 3005.1758,1795.9961 L3005.1758,1798.2747 Q3005.1758,1800.8464 3007.0313,1802.5716 Q3008.8867,1804.2643 3012.207,1804.2643 Q3014.1602,1804.2643 3015.5273,1803.7435 Q3016.3411,1803.418 3017.2201,1802.5065 Q3017.7734,1801.9531 3018.0664,1801.7904 Q3018.3919,1801.6276 3018.8151,1801.6276 Q3019.4987,1801.6276 3020.0195,1802.181 Q3020.5729,1802.7018 3020.5729,1803.418 Q3020.5729,1804.1341 3019.8568,1804.9805 Q3018.8151,1806.1849 3017.1549,1806.8685 Q3014.9089,1807.8125 3012.207,1807.8125 Q3009.0495,1807.8125 3006.543,1806.5104 Q3004.4922,1805.4688 3003.0599,1803.2552 Q3001.6276,1801.0091 3001.6276,1798.3398 L3001.6276,1795.931 Q3001.6276,1793.1641 3002.8971,1790.7878 Q3004.1992,1788.3789 3006.4779,1787.1094 Q3008.7565,1785.8073 3011.3281,1785.8073 Q3012.8581,1785.8073 3014.1927,1786.1654 Q3015.5599,1786.4909 3016.6992,1787.2396 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="33.3333" x="3053.6458" y="1806.0628">col</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="2880.2083" x2="3192.7083" y1="1829.1667" y2="1829.1667"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="181.25" x="2890.625" y="1898.4477">domainObject: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="187.5" x="2890.625" y="1927.2725">metadataError: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="139.5833" x="2890.625" y="1956.0974">cssClass: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="87.5" x="2890.625" y="1984.9223">size: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="62.5" x="2890.625" y="2013.7472">id: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="75" x="2890.625" y="2042.572">span: 4</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="260.4167" x="2890.625" y="2071.3969">unreferencedActions: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="291.6667" x="2890.625" y="2100.2218">unreferencedCollections: null</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2880.2083" x2="2985.4167" y1="1860.2458" y2="1860.2458"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="2985.4167" y="1868.5811">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3087.5" x2="3192.7083" y1="1860.2458" y2="1860.2458"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="158.3333" x="2890.625" y="2166.2048">fieldSet: [Array]</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2880.2083" x2="2997.9167" y1="2128.0029" y2="2128.0029"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="77.0833" x="2997.9167" y="2136.3383">Objects</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3075" x2="3192.7083" y1="2128.0029" y2="2128.0029"/><!--class root.row.1.cols.0.col.fieldSet--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="192.5537" id="root.row.1.cols.0.col.fieldSet" style="stroke: #A80036; stroke-width: 3.125;" width="193.75" x="3102.0833" y="2431.25"/><ellipse cx="3152.0833" cy="2464.5833" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M3157.8451,2455.9896 Q3158.1706,2455.5339 3158.5612,2455.306 Q3158.9518,2455.0781 3159.4076,2455.0781 Q3160.1888,2455.0781 3160.6771,2455.6315 Q3161.1654,2456.1523 3161.1654,2457.4219 L3161.1654,2460.4492 Q3161.1654,2461.7188 3160.6771,2462.2721 Q3160.1888,2462.8255 3159.4076,2462.8255 Q3158.6914,2462.8255 3158.2682,2462.4023 Q3157.8451,2462.0117 3157.6172,2460.9375 Q3157.5195,2460.1888 3157.1289,2459.7982 Q3156.4453,2459.0169 3155.1758,2458.5612 Q3153.9063,2458.1055 3152.6042,2458.1055 Q3151.0091,2458.1055 3149.6745,2458.7891 Q3148.3724,2459.4727 3147.3307,2461.0352 Q3146.3216,2462.5977 3146.3216,2464.7461 L3146.3216,2467.0247 Q3146.3216,2469.5964 3148.1771,2471.3216 Q3150.0326,2473.0143 3153.3529,2473.0143 Q3155.306,2473.0143 3156.6732,2472.4935 Q3157.487,2472.168 3158.3659,2471.2565 Q3158.9193,2470.7031 3159.2122,2470.5404 Q3159.5378,2470.3776 3159.9609,2470.3776 Q3160.6445,2470.3776 3161.1654,2470.931 Q3161.7188,2471.4518 3161.7188,2472.168 Q3161.7188,2472.8841 3161.0026,2473.7305 Q3159.9609,2474.9349 3158.3008,2475.6185 Q3156.0547,2476.5625 3153.3529,2476.5625 Q3150.1953,2476.5625 3147.6888,2475.2604 Q3145.638,2474.2188 3144.2057,2472.0052 Q3142.7734,2469.7591 3142.7734,2467.0898 L3142.7734,2464.681 Q3142.7734,2461.9141 3144.043,2459.5378 Q3145.3451,2457.1289 3147.6237,2455.8594 Q3149.9023,2454.5573 3152.474,2454.5573 Q3154.0039,2454.5573 3155.3385,2454.9154 Q3156.7057,2455.2409 3157.8451,2455.9896 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="85.4167" x="3185.4167" y="2474.8128">fieldSet</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="3104.1667" x2="3293.75" y1="2497.9167" y2="2497.9167"/><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3104.1667" x2="3147.9167" y1="2528.9958" y2="2528.9958"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="3147.9167" y="2537.3311">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3250" x2="3293.75" y1="2528.9958" y2="2528.9958"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="168.75" x="3114.5833" y="2610.435">0: [object Object]</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3104.1667" x2="3160.4167" y1="2572.2331" y2="2572.2331"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="77.0833" x="3160.4167" y="2580.5684">Objects</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3237.5" x2="3293.75" y1="2572.2331" y2="2572.2331"/><!--class root.row.1.cols.0.col.fieldSet.0--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="330.599" id="root.row.1.cols.0.col.fieldSet.0" style="stroke: #A80036; stroke-width: 3.125;" width="316.6667" x="3790.625" y="2976.0417"/><ellipse cx="3932.8125" cy="3009.375" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M3938.5742,3000.7813 Q3938.8997,3000.3255 3939.2904,3000.0977 Q3939.681,2999.8698 3940.1367,2999.8698 Q3940.918,2999.8698 3941.4063,3000.4232 Q3941.8945,3000.944 3941.8945,3002.2135 L3941.8945,3005.2409 Q3941.8945,3006.5104 3941.4063,3007.0638 Q3940.918,3007.6172 3940.1367,3007.6172 Q3939.4206,3007.6172 3938.9974,3007.194 Q3938.5742,3006.8034 3938.3464,3005.7292 Q3938.2487,3004.9805 3937.8581,3004.5898 Q3937.1745,3003.8086 3935.9049,3003.3529 Q3934.6354,3002.8971 3933.3333,3002.8971 Q3931.7383,3002.8971 3930.4036,3003.5807 Q3929.1016,3004.2643 3928.0599,3005.8268 Q3927.0508,3007.3893 3927.0508,3009.5378 L3927.0508,3011.8164 Q3927.0508,3014.388 3928.9063,3016.1133 Q3930.7617,3017.806 3934.082,3017.806 Q3936.0352,3017.806 3937.4023,3017.2852 Q3938.2161,3016.9596 3939.0951,3016.0482 Q3939.6484,3015.4948 3939.9414,3015.332 Q3940.2669,3015.1693 3940.6901,3015.1693 Q3941.3737,3015.1693 3941.8945,3015.7227 Q3942.4479,3016.2435 3942.4479,3016.9596 Q3942.4479,3017.6758 3941.7318,3018.5221 Q3940.6901,3019.7266 3939.0299,3020.4102 Q3936.7839,3021.3542 3934.082,3021.3542 Q3930.9245,3021.3542 3928.418,3020.0521 Q3926.3672,3019.0104 3924.9349,3016.7969 Q3923.5026,3014.5508 3923.5026,3011.8815 L3923.5026,3009.4727 Q3923.5026,3006.7057 3924.7721,3004.3294 Q3926.0742,3001.9206 3928.3529,3000.651 Q3930.6315,2999.349 3933.2031,2999.349 Q3934.7331,2999.349 3936.0677,2999.707 Q3937.4349,3000.0326 3938.5742,3000.7813 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="14.5833" x="3975.5208" y="3019.6045">0</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="3792.7083" x2="4105.2083" y1="3042.7083" y2="3042.7083"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="145.8333" x="3803.125" y="3111.9893">name: General</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="187.5" x="3803.125" y="3140.8142">metadataError: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="104.1667" x="3803.125" y="3169.6391">id: general</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="260.4167" x="3803.125" y="3198.4639">unreferencedActions: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="291.6667" x="3803.125" y="3227.2888">unreferencedProperties: true</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3792.7083" x2="3897.9167" y1="3073.7874" y2="3073.7874"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="3897.9167" y="3082.1228">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="4000" x2="4105.2083" y1="3073.7874" y2="3073.7874"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="168.75" x="3803.125" y="3293.2719">property: [Array]</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3792.7083" x2="3910.4167" y1="3255.07" y2="3255.07"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="77.0833" x="3910.4167" y="3263.4054">Objects</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3987.5" x2="4105.2083" y1="3255.07" y2="3255.07"/><!--class root.row.1.cols.0.col.fieldSet.0.property--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="279.0283" id="root.row.1.cols.0.col.fieldSet.0.property" style="stroke: #A80036; stroke-width: 3.125;" width="193.75" x="4170.8333" y="3533.3333"/><ellipse cx="4218.0208" cy="3566.6667" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M4223.7826,3558.0729 Q4224.1081,3557.6172 4224.4987,3557.3893 Q4224.8893,3557.1615 4225.3451,3557.1615 Q4226.1263,3557.1615 4226.6146,3557.7148 Q4227.1029,3558.2357 4227.1029,3559.5052 L4227.1029,3562.5326 Q4227.1029,3563.8021 4226.6146,3564.3555 Q4226.1263,3564.9089 4225.3451,3564.9089 Q4224.6289,3564.9089 4224.2057,3564.4857 Q4223.7826,3564.0951 4223.5547,3563.0208 Q4223.457,3562.2721 4223.0664,3561.8815 Q4222.3828,3561.1003 4221.1133,3560.6445 Q4219.8438,3560.1888 4218.5417,3560.1888 Q4216.9466,3560.1888 4215.612,3560.8724 Q4214.3099,3561.556 4213.2682,3563.1185 Q4212.2591,3564.681 4212.2591,3566.8294 L4212.2591,3569.1081 Q4212.2591,3571.6797 4214.1146,3573.4049 Q4215.9701,3575.0977 4219.2904,3575.0977 Q4221.2435,3575.0977 4222.6107,3574.5768 Q4223.4245,3574.2513 4224.3034,3573.3398 Q4224.8568,3572.7865 4225.1497,3572.6237 Q4225.4753,3572.4609 4225.8984,3572.4609 Q4226.582,3572.4609 4227.1029,3573.0143 Q4227.6563,3573.5352 4227.6563,3574.2513 Q4227.6563,3574.9674 4226.9401,3575.8138 Q4225.8984,3577.0182 4224.2383,3577.7018 Q4221.9922,3578.6458 4219.2904,3578.6458 Q4216.1328,3578.6458 4213.6263,3577.3438 Q4211.5755,3576.3021 4210.1432,3574.0885 Q4208.7109,3571.8424 4208.7109,3569.1732 L4208.7109,3566.7643 Q4208.7109,3563.9974 4209.9805,3561.6211 Q4211.2826,3559.2122 4213.5612,3557.9427 Q4215.8398,3556.6406 4218.4115,3556.6406 Q4219.9414,3556.6406 4221.276,3556.9987 Q4222.6432,3557.3242 4223.7826,3558.0729 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="91.6667" x="4250.7292" y="3576.8962">property</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="4172.9167" x2="4362.5" y1="3600" y2="3600"/><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="4172.9167" x2="4216.6667" y1="3631.0791" y2="3631.0791"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="4216.6667" y="3639.4145">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="4318.75" x2="4362.5" y1="3631.0791" y2="3631.0791"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="168.75" x="4183.3333" y="3712.5183">0: [object Object]</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="168.75" x="4183.3333" y="3741.3432">1: [object Object]</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="168.75" x="4183.3333" y="3770.1681">2: [object Object]</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="168.75" x="4183.3333" y="3798.9929">3: [object Object]</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="4172.9167" x2="4229.1667" y1="3674.3164" y2="3674.3164"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="77.0833" x="4229.1667" y="3682.6518">Objects</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="4306.25" x2="4362.5" y1="3674.3164" y2="3674.3164"/><!--class root.row.1.cols.0.col.fieldSet.0.property.0--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="561.1979" id="root.row.1.cols.0.col.fieldSet.0.property.0" style="stroke: #A80036; stroke-width: 3.125;" width="300" x="2851.0417" y="3937.5"/><ellipse cx="2984.8958" cy="3970.8333" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M2990.6576,3962.2396 Q2990.9831,3961.7839 2991.3737,3961.556 Q2991.7643,3961.3281 2992.2201,3961.3281 Q2993.0013,3961.3281 2993.4896,3961.8815 Q2993.9779,3962.4023 2993.9779,3963.6719 L2993.9779,3966.6992 Q2993.9779,3967.9688 2993.4896,3968.5221 Q2993.0013,3969.0755 2992.2201,3969.0755 Q2991.5039,3969.0755 2991.0807,3968.6523 Q2990.6576,3968.2617 2990.4297,3967.1875 Q2990.332,3966.4388 2989.9414,3966.0482 Q2989.2578,3965.2669 2987.9883,3964.8112 Q2986.7188,3964.3555 2985.4167,3964.3555 Q2983.8216,3964.3555 2982.487,3965.0391 Q2981.1849,3965.7227 2980.1432,3967.2852 Q2979.1341,3968.8477 2979.1341,3970.9961 L2979.1341,3973.2747 Q2979.1341,3975.8464 2980.9896,3977.5716 Q2982.8451,3979.2643 2986.1654,3979.2643 Q2988.1185,3979.2643 2989.4857,3978.7435 Q2990.2995,3978.418 2991.1784,3977.5065 Q2991.7318,3976.9531 2992.0247,3976.7904 Q2992.3503,3976.6276 2992.7734,3976.6276 Q2993.457,3976.6276 2993.9779,3977.181 Q2994.5313,3977.7018 2994.5313,3978.418 Q2994.5313,3979.1341 2993.8151,3979.9805 Q2992.7734,3981.1849 2991.1133,3981.8685 Q2988.8672,3982.8125 2986.1654,3982.8125 Q2983.0078,3982.8125 2980.5013,3981.5104 Q2978.4505,3980.4688 2977.0182,3978.2552 Q2975.5859,3976.0091 2975.5859,3973.3398 L2975.5859,3970.931 Q2975.5859,3968.1641 2976.8555,3965.7878 Q2978.1576,3963.3789 2980.4362,3962.1094 Q2982.7148,3960.8073 2985.2865,3960.8073 Q2986.8164,3960.8073 2988.151,3961.1654 Q2989.5182,3961.4909 2990.6576,3962.2396 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="14.5833" x="3027.6042" y="3981.0628">0</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="2853.125" x2="3148.9583" y1="4004.1667" y2="4004.1667"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="112.5" x="2863.5417" y="4073.4477">named: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="175" x="2863.5417" y="4102.2725">describedAs: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="187.5" x="2863.5417" y="4131.0974">metadataError: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="139.5833" x="2863.5417" y="4159.9223">id: className</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="139.5833" x="2863.5417" y="4188.7472">cssClass: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="112.5" x="2863.5417" y="4217.572">hidden: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="168.75" x="2863.5417" y="4246.3969">labelPosition: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="131.25" x="2863.5417" y="4275.2218">multiLine: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="200" x="2863.5417" y="4304.0466">namedEscaped: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="164.5833" x="2863.5417" y="4332.8715">promptStyle: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="275" x="2863.5417" y="4361.6964">renderedAsDayBefore: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="179.1667" x="2863.5417" y="4390.5212">typicalLength: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="162.5" x="2863.5417" y="4419.3461">unchanging: null</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2853.125" x2="2950" y1="4035.2458" y2="4035.2458"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="2950" y="4043.5811">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3052.0833" x2="3148.9583" y1="4035.2458" y2="4035.2458"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="187.5" x="2863.5417" y="4485.3292">link: [object Object]</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2853.125" x2="2962.5" y1="4447.1273" y2="4447.1273"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="77.0833" x="2962.5" y="4455.4626">Objects</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3039.5833" x2="3148.9583" y1="4447.1273" y2="4447.1273"/><!--class root.row.1.cols.0.col.fieldSet.0.property.0.link--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="235.791" id="root.row.1.cols.0.col.fieldSet.0.property.0.link" style="stroke: #A80036; stroke-width: 3.125;" width="989.5833" x="2150" y="4622.9167"/><ellipse cx="2616.1458" cy="4656.25" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M2621.9076,4647.6563 Q2622.2331,4647.2005 2622.6237,4646.9727 Q2623.0143,4646.7448 2623.4701,4646.7448 Q2624.2513,4646.7448 2624.7396,4647.2982 Q2625.2279,4647.819 2625.2279,4649.0885 L2625.2279,4652.1159 Q2625.2279,4653.3854 2624.7396,4653.9388 Q2624.2513,4654.4922 2623.4701,4654.4922 Q2622.7539,4654.4922 2622.3307,4654.069 Q2621.9076,4653.6784 2621.6797,4652.6042 Q2621.582,4651.8555 2621.1914,4651.4648 Q2620.5078,4650.6836 2619.2383,4650.2279 Q2617.9688,4649.7721 2616.6667,4649.7721 Q2615.0716,4649.7721 2613.737,4650.4557 Q2612.4349,4651.1393 2611.3932,4652.7018 Q2610.3841,4654.2643 2610.3841,4656.4128 L2610.3841,4658.6914 Q2610.3841,4661.263 2612.2396,4662.9883 Q2614.0951,4664.681 2617.4154,4664.681 Q2619.3685,4664.681 2620.7357,4664.1602 Q2621.5495,4663.8346 2622.4284,4662.9232 Q2622.9818,4662.3698 2623.2747,4662.207 Q2623.6003,4662.0443 2624.0234,4662.0443 Q2624.707,4662.0443 2625.2279,4662.5977 Q2625.7813,4663.1185 2625.7813,4663.8346 Q2625.7813,4664.5508 2625.0651,4665.3971 Q2624.0234,4666.6016 2622.3633,4667.2852 Q2620.1172,4668.2292 2617.4154,4668.2292 Q2614.2578,4668.2292 2611.7513,4666.9271 Q2609.7005,4665.8854 2608.2682,4663.6719 Q2606.8359,4661.4258 2606.8359,4658.7565 L2606.8359,4656.3477 Q2606.8359,4653.5807 2608.1055,4651.2044 Q2609.4076,4648.7956 2611.6862,4647.526 Q2613.9648,4646.224 2616.5365,4646.224 Q2618.0664,4646.224 2619.401,4646.582 Q2620.7682,4646.9076 2621.9076,4647.6563 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="39.5833" x="2658.8542" y="4666.4795">link</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="2152.0833" x2="3137.5" y1="4689.5833" y2="4689.5833"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="389.5833" x="2162.5" y="4758.8643">rel: urn:org.restfulobjects:rels/property</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="127.0833" x="2162.5" y="4787.6892">method: GET</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="883.3333" x="2162.5" y="4816.5141">href: http://localhost:8080/restful/objects/isisApplib.FixtureResult/;/properties/className</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="964.5833" x="2162.5" y="4845.3389">type: application/jsonprofile&amp;#x3D;&amp;quot;urn:org.restfulobjects:repr-types/object-property&amp;quot;</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2152.0833" x2="2593.75" y1="4720.6624" y2="4720.6624"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="2593.75" y="4728.9978">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="2695.8333" x2="3137.5" y1="4720.6624" y2="4720.6624"/><!--class root.row.1.cols.0.col.fieldSet.0.property.1--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="561.1979" id="root.row.1.cols.0.col.fieldSet.0.property.1" style="stroke: #A80036; stroke-width: 3.125;" width="300" x="3755.2083" y="3937.5"/><ellipse cx="3889.0625" cy="3970.8333" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M3894.8242,3962.2396 Q3895.1497,3961.7839 3895.5404,3961.556 Q3895.931,3961.3281 3896.3867,3961.3281 Q3897.168,3961.3281 3897.6563,3961.8815 Q3898.1445,3962.4023 3898.1445,3963.6719 L3898.1445,3966.6992 Q3898.1445,3967.9688 3897.6563,3968.5221 Q3897.168,3969.0755 3896.3867,3969.0755 Q3895.6706,3969.0755 3895.2474,3968.6523 Q3894.8242,3968.2617 3894.5964,3967.1875 Q3894.4987,3966.4388 3894.1081,3966.0482 Q3893.4245,3965.2669 3892.1549,3964.8112 Q3890.8854,3964.3555 3889.5833,3964.3555 Q3887.9883,3964.3555 3886.6536,3965.0391 Q3885.3516,3965.7227 3884.3099,3967.2852 Q3883.3008,3968.8477 3883.3008,3970.9961 L3883.3008,3973.2747 Q3883.3008,3975.8464 3885.1563,3977.5716 Q3887.0117,3979.2643 3890.332,3979.2643 Q3892.2852,3979.2643 3893.6523,3978.7435 Q3894.4661,3978.418 3895.3451,3977.5065 Q3895.8984,3976.9531 3896.1914,3976.7904 Q3896.5169,3976.6276 3896.9401,3976.6276 Q3897.6237,3976.6276 3898.1445,3977.181 Q3898.6979,3977.7018 3898.6979,3978.418 Q3898.6979,3979.1341 3897.9818,3979.9805 Q3896.9401,3981.1849 3895.2799,3981.8685 Q3893.0339,3982.8125 3890.332,3982.8125 Q3887.1745,3982.8125 3884.668,3981.5104 Q3882.6172,3980.4688 3881.1849,3978.2552 Q3879.7526,3976.0091 3879.7526,3973.3398 L3879.7526,3970.931 Q3879.7526,3968.1641 3881.0221,3965.7878 Q3882.3242,3963.3789 3884.6029,3962.1094 Q3886.8815,3960.8073 3889.4531,3960.8073 Q3890.9831,3960.8073 3892.3177,3961.1654 Q3893.6849,3961.4909 3894.8242,3962.2396 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="14.5833" x="3931.7708" y="3981.0628">1</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="3757.2917" x2="4053.125" y1="4004.1667" y2="4004.1667"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="112.5" x="3767.7083" y="4073.4477">named: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="175" x="3767.7083" y="4102.2725">describedAs: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="187.5" x="3767.7083" y="4131.0974">metadataError: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="264.5833" x="3767.7083" y="4159.9223">id: fixtureScriptClassName</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="139.5833" x="3767.7083" y="4188.7472">cssClass: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="112.5" x="3767.7083" y="4217.572">hidden: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="168.75" x="3767.7083" y="4246.3969">labelPosition: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="131.25" x="3767.7083" y="4275.2218">multiLine: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="200" x="3767.7083" y="4304.0466">namedEscaped: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="164.5833" x="3767.7083" y="4332.8715">promptStyle: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="275" x="3767.7083" y="4361.6964">renderedAsDayBefore: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="179.1667" x="3767.7083" y="4390.5212">typicalLength: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="162.5" x="3767.7083" y="4419.3461">unchanging: null</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3757.2917" x2="3854.1667" y1="4035.2458" y2="4035.2458"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="3854.1667" y="4043.5811">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3956.25" x2="4053.125" y1="4035.2458" y2="4035.2458"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="187.5" x="3767.7083" y="4485.3292">link: [object Object]</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3757.2917" x2="3866.6667" y1="4447.1273" y2="4447.1273"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="77.0833" x="3866.6667" y="4455.4626">Objects</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3943.75" x2="4053.125" y1="4447.1273" y2="4447.1273"/><!--class root.row.1.cols.0.col.fieldSet.0.property.1.link--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="235.791" id="root.row.1.cols.0.col.fieldSet.0.property.1.link" style="stroke: #A80036; stroke-width: 3.125;" width="1033.3333" x="3213.5417" y="4622.9167"/><ellipse cx="3701.5625" cy="4656.25" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M3707.3242,4647.6563 Q3707.6497,4647.2005 3708.0404,4646.9727 Q3708.431,4646.7448 3708.8867,4646.7448 Q3709.668,4646.7448 3710.1563,4647.2982 Q3710.6445,4647.819 3710.6445,4649.0885 L3710.6445,4652.1159 Q3710.6445,4653.3854 3710.1563,4653.9388 Q3709.668,4654.4922 3708.8867,4654.4922 Q3708.1706,4654.4922 3707.7474,4654.069 Q3707.3242,4653.6784 3707.0964,4652.6042 Q3706.9987,4651.8555 3706.6081,4651.4648 Q3705.9245,4650.6836 3704.6549,4650.2279 Q3703.3854,4649.7721 3702.0833,4649.7721 Q3700.4883,4649.7721 3699.1536,4650.4557 Q3697.8516,4651.1393 3696.8099,4652.7018 Q3695.8008,4654.2643 3695.8008,4656.4128 L3695.8008,4658.6914 Q3695.8008,4661.263 3697.6563,4662.9883 Q3699.5117,4664.681 3702.832,4664.681 Q3704.7852,4664.681 3706.1523,4664.1602 Q3706.9661,4663.8346 3707.8451,4662.9232 Q3708.3984,4662.3698 3708.6914,4662.207 Q3709.0169,4662.0443 3709.4401,4662.0443 Q3710.1237,4662.0443 3710.6445,4662.5977 Q3711.1979,4663.1185 3711.1979,4663.8346 Q3711.1979,4664.5508 3710.4818,4665.3971 Q3709.4401,4666.6016 3707.7799,4667.2852 Q3705.5339,4668.2292 3702.832,4668.2292 Q3699.6745,4668.2292 3697.168,4666.9271 Q3695.1172,4665.8854 3693.6849,4663.6719 Q3692.2526,4661.4258 3692.2526,4658.7565 L3692.2526,4656.3477 Q3692.2526,4653.5807 3693.5221,4651.2044 Q3694.8242,4648.7956 3697.1029,4647.526 Q3699.3815,4646.224 3701.9531,4646.224 Q3703.4831,4646.224 3704.8177,4646.582 Q3706.1849,4646.9076 3707.3242,4647.6563 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="39.5833" x="3744.2708" y="4666.4795">link</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="3215.625" x2="4244.7917" y1="4689.5833" y2="4689.5833"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="389.5833" x="3226.0417" y="4758.8643">rel: urn:org.restfulobjects:rels/property</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="127.0833" x="3226.0417" y="4787.6892">method: GET</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="1008.3333" x="3226.0417" y="4816.5141">href: http://localhost:8080/restful/objects/isisApplib.FixtureResult/;/properties/fixtureScriptClassName</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="964.5833" x="3226.0417" y="4845.3389">type: application/jsonprofile&amp;#x3D;&amp;quot;urn:org.restfulobjects:repr-types/object-property&amp;quot;</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3215.625" x2="3679.1667" y1="4720.6624" y2="4720.6624"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="3679.1667" y="4728.9978">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3781.25" x2="4244.7917" y1="4720.6624" y2="4720.6624"/><!--class root.row.1.cols.0.col.fieldSet.0.property.2--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="561.1979" id="root.row.1.cols.0.col.fieldSet.0.property.2" style="stroke: #A80036; stroke-width: 3.125;" width="300" x="4478.125" y="3937.5"/><ellipse cx="4611.9792" cy="3970.8333" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M4617.7409,3962.2396 Q4618.0664,3961.7839 4618.457,3961.556 Q4618.8477,3961.3281 4619.3034,3961.3281 Q4620.0846,3961.3281 4620.5729,3961.8815 Q4621.0612,3962.4023 4621.0612,3963.6719 L4621.0612,3966.6992 Q4621.0612,3967.9688 4620.5729,3968.5221 Q4620.0846,3969.0755 4619.3034,3969.0755 Q4618.5872,3969.0755 4618.1641,3968.6523 Q4617.7409,3968.2617 4617.513,3967.1875 Q4617.4154,3966.4388 4617.0247,3966.0482 Q4616.3411,3965.2669 4615.0716,3964.8112 Q4613.8021,3964.3555 4612.5,3964.3555 Q4610.9049,3964.3555 4609.5703,3965.0391 Q4608.2682,3965.7227 4607.2266,3967.2852 Q4606.2174,3968.8477 4606.2174,3970.9961 L4606.2174,3973.2747 Q4606.2174,3975.8464 4608.0729,3977.5716 Q4609.9284,3979.2643 4613.2487,3979.2643 Q4615.2018,3979.2643 4616.569,3978.7435 Q4617.3828,3978.418 4618.2617,3977.5065 Q4618.8151,3976.9531 4619.1081,3976.7904 Q4619.4336,3976.6276 4619.8568,3976.6276 Q4620.5404,3976.6276 4621.0612,3977.181 Q4621.6146,3977.7018 4621.6146,3978.418 Q4621.6146,3979.1341 4620.8984,3979.9805 Q4619.8568,3981.1849 4618.1966,3981.8685 Q4615.9505,3982.8125 4613.2487,3982.8125 Q4610.0911,3982.8125 4607.5846,3981.5104 Q4605.5339,3980.4688 4604.1016,3978.2552 Q4602.6693,3976.0091 4602.6693,3973.3398 L4602.6693,3970.931 Q4602.6693,3968.1641 4603.9388,3965.7878 Q4605.2409,3963.3789 4607.5195,3962.1094 Q4609.7982,3960.8073 4612.3698,3960.8073 Q4613.8997,3960.8073 4615.2344,3961.1654 Q4616.6016,3961.4909 4617.7409,3962.2396 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="14.5833" x="4654.6875" y="3981.0628">2</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="4480.2083" x2="4776.0417" y1="4004.1667" y2="4004.1667"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="112.5" x="4490.625" y="4073.4477">named: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="175" x="4490.625" y="4102.2725">describedAs: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="187.5" x="4490.625" y="4131.0974">metadataError: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="64.5833" x="4490.625" y="4159.9223">id: key</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="139.5833" x="4490.625" y="4188.7472">cssClass: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="112.5" x="4490.625" y="4217.572">hidden: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="168.75" x="4490.625" y="4246.3969">labelPosition: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="131.25" x="4490.625" y="4275.2218">multiLine: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="200" x="4490.625" y="4304.0466">namedEscaped: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="164.5833" x="4490.625" y="4332.8715">promptStyle: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="275" x="4490.625" y="4361.6964">renderedAsDayBefore: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="179.1667" x="4490.625" y="4390.5212">typicalLength: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="162.5" x="4490.625" y="4419.3461">unchanging: null</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="4480.2083" x2="4577.0833" y1="4035.2458" y2="4035.2458"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="4577.0833" y="4043.5811">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="4679.1667" x2="4776.0417" y1="4035.2458" y2="4035.2458"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="187.5" x="4490.625" y="4485.3292">link: [object Object]</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="4480.2083" x2="4589.5833" y1="4447.1273" y2="4447.1273"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="77.0833" x="4589.5833" y="4455.4626">Objects</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="4666.6667" x2="4776.0417" y1="4447.1273" y2="4447.1273"/><!--class root.row.1.cols.0.col.fieldSet.0.property.2.link--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="235.791" id="root.row.1.cols.0.col.fieldSet.0.property.2.link" style="stroke: #A80036; stroke-width: 3.125;" width="989.5833" x="4320.8333" y="4622.9167"/><ellipse cx="4786.9792" cy="4656.25" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M4792.7409,4647.6563 Q4793.0664,4647.2005 4793.457,4646.9727 Q4793.8477,4646.7448 4794.3034,4646.7448 Q4795.0846,4646.7448 4795.5729,4647.2982 Q4796.0612,4647.819 4796.0612,4649.0885 L4796.0612,4652.1159 Q4796.0612,4653.3854 4795.5729,4653.9388 Q4795.0846,4654.4922 4794.3034,4654.4922 Q4793.5872,4654.4922 4793.1641,4654.069 Q4792.7409,4653.6784 4792.513,4652.6042 Q4792.4154,4651.8555 4792.0247,4651.4648 Q4791.3411,4650.6836 4790.0716,4650.2279 Q4788.8021,4649.7721 4787.5,4649.7721 Q4785.9049,4649.7721 4784.5703,4650.4557 Q4783.2682,4651.1393 4782.2266,4652.7018 Q4781.2174,4654.2643 4781.2174,4656.4128 L4781.2174,4658.6914 Q4781.2174,4661.263 4783.0729,4662.9883 Q4784.9284,4664.681 4788.2487,4664.681 Q4790.2018,4664.681 4791.569,4664.1602 Q4792.3828,4663.8346 4793.2617,4662.9232 Q4793.8151,4662.3698 4794.1081,4662.207 Q4794.4336,4662.0443 4794.8568,4662.0443 Q4795.5404,4662.0443 4796.0612,4662.5977 Q4796.6146,4663.1185 4796.6146,4663.8346 Q4796.6146,4664.5508 4795.8984,4665.3971 Q4794.8568,4666.6016 4793.1966,4667.2852 Q4790.9505,4668.2292 4788.2487,4668.2292 Q4785.0911,4668.2292 4782.5846,4666.9271 Q4780.5339,4665.8854 4779.1016,4663.6719 Q4777.6693,4661.4258 4777.6693,4658.7565 L4777.6693,4656.3477 Q4777.6693,4653.5807 4778.9388,4651.2044 Q4780.2409,4648.7956 4782.5195,4647.526 Q4784.7982,4646.224 4787.3698,4646.224 Q4788.8997,4646.224 4790.2344,4646.582 Q4791.6016,4646.9076 4792.7409,4647.6563 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="39.5833" x="4829.6875" y="4666.4795">link</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="4322.9167" x2="5308.3333" y1="4689.5833" y2="4689.5833"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="389.5833" x="4333.3333" y="4758.8643">rel: urn:org.restfulobjects:rels/property</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="127.0833" x="4333.3333" y="4787.6892">method: GET</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="808.3333" x="4333.3333" y="4816.5141">href: http://localhost:8080/restful/objects/isisApplib.FixtureResult/;/properties/key</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="964.5833" x="4333.3333" y="4845.3389">type: application/jsonprofile&amp;#x3D;&amp;quot;urn:org.restfulobjects:repr-types/object-property&amp;quot;</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="4322.9167" x2="4764.5833" y1="4720.6624" y2="4720.6624"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="4764.5833" y="4728.9978">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="4866.6667" x2="5308.3333" y1="4720.6624" y2="4720.6624"/><!--class root.row.1.cols.0.col.fieldSet.0.property.3--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="561.1979" id="root.row.1.cols.0.col.fieldSet.0.property.3" style="stroke: #A80036; stroke-width: 3.125;" width="300" x="5551.0417" y="3937.5"/><ellipse cx="5684.8958" cy="3970.8333" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M5690.6576,3962.2396 Q5690.9831,3961.7839 5691.3737,3961.556 Q5691.7643,3961.3281 5692.2201,3961.3281 Q5693.0013,3961.3281 5693.4896,3961.8815 Q5693.9779,3962.4023 5693.9779,3963.6719 L5693.9779,3966.6992 Q5693.9779,3967.9688 5693.4896,3968.5221 Q5693.0013,3969.0755 5692.2201,3969.0755 Q5691.5039,3969.0755 5691.0807,3968.6523 Q5690.6576,3968.2617 5690.4297,3967.1875 Q5690.332,3966.4388 5689.9414,3966.0482 Q5689.2578,3965.2669 5687.9883,3964.8112 Q5686.7188,3964.3555 5685.4167,3964.3555 Q5683.8216,3964.3555 5682.487,3965.0391 Q5681.1849,3965.7227 5680.1432,3967.2852 Q5679.1341,3968.8477 5679.1341,3970.9961 L5679.1341,3973.2747 Q5679.1341,3975.8464 5680.9896,3977.5716 Q5682.8451,3979.2643 5686.1654,3979.2643 Q5688.1185,3979.2643 5689.4857,3978.7435 Q5690.2995,3978.418 5691.1784,3977.5065 Q5691.7318,3976.9531 5692.0247,3976.7904 Q5692.3503,3976.6276 5692.7734,3976.6276 Q5693.457,3976.6276 5693.9779,3977.181 Q5694.5313,3977.7018 5694.5313,3978.418 Q5694.5313,3979.1341 5693.8151,3979.9805 Q5692.7734,3981.1849 5691.1133,3981.8685 Q5688.8672,3982.8125 5686.1654,3982.8125 Q5683.0078,3982.8125 5680.5013,3981.5104 Q5678.4505,3980.4688 5677.0182,3978.2552 Q5675.5859,3976.0091 5675.5859,3973.3398 L5675.5859,3970.931 Q5675.5859,3968.1641 5676.8555,3965.7878 Q5678.1576,3963.3789 5680.4362,3962.1094 Q5682.7148,3960.8073 5685.2865,3960.8073 Q5686.8164,3960.8073 5688.151,3961.1654 Q5689.5182,3961.4909 5690.6576,3962.2396 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="14.5833" x="5727.6042" y="3981.0628">3</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="5553.125" x2="5848.9583" y1="4004.1667" y2="4004.1667"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="112.5" x="5563.5417" y="4073.4477">named: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="175" x="5563.5417" y="4102.2725">describedAs: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="187.5" x="5563.5417" y="4131.0974">metadataError: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="89.5833" x="5563.5417" y="4159.9223">id: object</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="139.5833" x="5563.5417" y="4188.7472">cssClass: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="112.5" x="5563.5417" y="4217.572">hidden: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="168.75" x="5563.5417" y="4246.3969">labelPosition: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="131.25" x="5563.5417" y="4275.2218">multiLine: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="200" x="5563.5417" y="4304.0466">namedEscaped: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="164.5833" x="5563.5417" y="4332.8715">promptStyle: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="275" x="5563.5417" y="4361.6964">renderedAsDayBefore: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="179.1667" x="5563.5417" y="4390.5212">typicalLength: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="162.5" x="5563.5417" y="4419.3461">unchanging: null</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="5553.125" x2="5650" y1="4035.2458" y2="4035.2458"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="5650" y="4043.5811">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="5752.0833" x2="5848.9583" y1="4035.2458" y2="4035.2458"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="187.5" x="5563.5417" y="4485.3292">link: [object Object]</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="5553.125" x2="5662.5" y1="4447.1273" y2="4447.1273"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="77.0833" x="5662.5" y="4455.4626">Objects</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="5739.5833" x2="5848.9583" y1="4447.1273" y2="4447.1273"/><!--class root.row.1.cols.0.col.fieldSet.0.property.3.link--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="235.791" id="root.row.1.cols.0.col.fieldSet.0.property.3.link" style="stroke: #A80036; stroke-width: 3.125;" width="989.5833" x="5383.3333" y="4622.9167"/><ellipse cx="5849.4792" cy="4656.25" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M5855.2409,4647.6563 Q5855.5664,4647.2005 5855.957,4646.9727 Q5856.3477,4646.7448 5856.8034,4646.7448 Q5857.5846,4646.7448 5858.0729,4647.2982 Q5858.5612,4647.819 5858.5612,4649.0885 L5858.5612,4652.1159 Q5858.5612,4653.3854 5858.0729,4653.9388 Q5857.5846,4654.4922 5856.8034,4654.4922 Q5856.0872,4654.4922 5855.6641,4654.069 Q5855.2409,4653.6784 5855.013,4652.6042 Q5854.9154,4651.8555 5854.5247,4651.4648 Q5853.8411,4650.6836 5852.5716,4650.2279 Q5851.3021,4649.7721 5850,4649.7721 Q5848.4049,4649.7721 5847.0703,4650.4557 Q5845.7682,4651.1393 5844.7266,4652.7018 Q5843.7174,4654.2643 5843.7174,4656.4128 L5843.7174,4658.6914 Q5843.7174,4661.263 5845.5729,4662.9883 Q5847.4284,4664.681 5850.7487,4664.681 Q5852.7018,4664.681 5854.069,4664.1602 Q5854.8828,4663.8346 5855.7617,4662.9232 Q5856.3151,4662.3698 5856.6081,4662.207 Q5856.9336,4662.0443 5857.3568,4662.0443 Q5858.0404,4662.0443 5858.5612,4662.5977 Q5859.1146,4663.1185 5859.1146,4663.8346 Q5859.1146,4664.5508 5858.3984,4665.3971 Q5857.3568,4666.6016 5855.6966,4667.2852 Q5853.4505,4668.2292 5850.7487,4668.2292 Q5847.5911,4668.2292 5845.0846,4666.9271 Q5843.0339,4665.8854 5841.6016,4663.6719 Q5840.1693,4661.4258 5840.1693,4658.7565 L5840.1693,4656.3477 Q5840.1693,4653.5807 5841.4388,4651.2044 Q5842.7409,4648.7956 5845.0195,4647.526 Q5847.2982,4646.224 5849.8698,4646.224 Q5851.3997,4646.224 5852.7344,4646.582 Q5854.1016,4646.9076 5855.2409,4647.6563 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="39.5833" x="5892.1875" y="4666.4795">link</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="5385.4167" x2="6370.8333" y1="4689.5833" y2="4689.5833"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="389.5833" x="5395.8333" y="4758.8643">rel: urn:org.restfulobjects:rels/property</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="127.0833" x="5395.8333" y="4787.6892">method: GET</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="833.3333" x="5395.8333" y="4816.5141">href: http://localhost:8080/restful/objects/isisApplib.FixtureResult/;/properties/object</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="964.5833" x="5395.8333" y="4845.3389">type: application/jsonprofile&amp;#x3D;&amp;quot;urn:org.restfulobjects:repr-types/object-property&amp;quot;</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="5385.4167" x2="5827.0833" y1="4720.6624" y2="4720.6624"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="5827.0833" y="4728.9978">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="5929.1667" x2="6370.8333" y1="4720.6624" y2="4720.6624"/><!--class root.row.1.cols.1--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="192.5537" id="root.row.1.cols.1" style="stroke: #A80036; stroke-width: 3.125;" width="210.4167" x="3268.75" y="1445.8333"/><ellipse cx="3358.125" cy="1479.1667" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M3363.8867,1470.5729 Q3364.2122,1470.1172 3364.6029,1469.8893 Q3364.9935,1469.6615 3365.4492,1469.6615 Q3366.2305,1469.6615 3366.7188,1470.2148 Q3367.207,1470.7357 3367.207,1472.0052 L3367.207,1475.0326 Q3367.207,1476.3021 3366.7188,1476.8555 Q3366.2305,1477.4089 3365.4492,1477.4089 Q3364.7331,1477.4089 3364.3099,1476.9857 Q3363.8867,1476.5951 3363.6589,1475.5208 Q3363.5612,1474.7721 3363.1706,1474.3815 Q3362.487,1473.6003 3361.2174,1473.1445 Q3359.9479,1472.6888 3358.6458,1472.6888 Q3357.0508,1472.6888 3355.7161,1473.3724 Q3354.4141,1474.056 3353.3724,1475.6185 Q3352.3633,1477.181 3352.3633,1479.3294 L3352.3633,1481.6081 Q3352.3633,1484.1797 3354.2188,1485.9049 Q3356.0742,1487.5977 3359.3945,1487.5977 Q3361.3477,1487.5977 3362.7148,1487.0768 Q3363.5286,1486.7513 3364.4076,1485.8398 Q3364.9609,1485.2865 3365.2539,1485.1237 Q3365.5794,1484.9609 3366.0026,1484.9609 Q3366.6862,1484.9609 3367.207,1485.5143 Q3367.7604,1486.0352 3367.7604,1486.7513 Q3367.7604,1487.4674 3367.0443,1488.3138 Q3366.0026,1489.5182 3364.3424,1490.2018 Q3362.0964,1491.1458 3359.3945,1491.1458 Q3356.237,1491.1458 3353.7305,1489.8438 Q3351.6797,1488.8021 3350.2474,1486.5885 Q3348.8151,1484.3424 3348.8151,1481.6732 L3348.8151,1479.2643 Q3348.8151,1476.4974 3350.0846,1474.1211 Q3351.3867,1471.7122 3353.6654,1470.4427 Q3355.944,1469.1406 3358.5156,1469.1406 Q3360.0456,1469.1406 3361.3802,1469.4987 Q3362.7474,1469.8242 3363.8867,1470.5729 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="14.5833" x="3400.2083" y="1489.3962">1</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="3270.8333" x2="3477.0833" y1="1512.5" y2="1512.5"/><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3270.8333" x2="3322.9167" y1="1543.5791" y2="1543.5791"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="3322.9167" y="1551.9145">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3425" x2="3477.0833" y1="1543.5791" y2="1543.5791"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="185.4167" x="3281.25" y="1625.0183">col: [object Object]</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3270.8333" x2="3335.4167" y1="1586.8164" y2="1586.8164"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="77.0833" x="3335.4167" y="1595.1518">Objects</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3412.5" x2="3477.0833" y1="1586.8164" y2="1586.8164"/><!--class root.row.1.cols.1.col--><rect fill="#FEFECE" filter="url(#f1o3ddckp2b3gs)" height="351.0905" id="root.row.1.cols.1.col" style="stroke: #A80036; stroke-width: 3.125;" width="322.9167" x="3268.75" y="1794.7917"/><ellipse cx="3404.6875" cy="1828.125" fill="#ADD1B2" rx="22.9167" ry="22.9167" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><path d="M3410.4492,1819.5313 Q3410.7747,1819.0755 3411.1654,1818.8477 Q3411.556,1818.6198 3412.0117,1818.6198 Q3412.793,1818.6198 3413.2813,1819.1732 Q3413.7695,1819.694 3413.7695,1820.9635 L3413.7695,1823.9909 Q3413.7695,1825.2604 3413.2813,1825.8138 Q3412.793,1826.3672 3412.0117,1826.3672 Q3411.2956,1826.3672 3410.8724,1825.944 Q3410.4492,1825.5534 3410.2214,1824.4792 Q3410.1237,1823.7305 3409.7331,1823.3398 Q3409.0495,1822.5586 3407.7799,1822.1029 Q3406.5104,1821.6471 3405.2083,1821.6471 Q3403.6133,1821.6471 3402.2786,1822.3307 Q3400.9766,1823.0143 3399.9349,1824.5768 Q3398.9258,1826.1393 3398.9258,1828.2878 L3398.9258,1830.5664 Q3398.9258,1833.138 3400.7813,1834.8633 Q3402.6367,1836.556 3405.957,1836.556 Q3407.9102,1836.556 3409.2773,1836.0352 Q3410.0911,1835.7096 3410.9701,1834.7982 Q3411.5234,1834.2448 3411.8164,1834.082 Q3412.1419,1833.9193 3412.5651,1833.9193 Q3413.2487,1833.9193 3413.7695,1834.4727 Q3414.3229,1834.9935 3414.3229,1835.7096 Q3414.3229,1836.4258 3413.6068,1837.2721 Q3412.5651,1838.4766 3410.9049,1839.1602 Q3408.6589,1840.1042 3405.957,1840.1042 Q3402.7995,1840.1042 3400.293,1838.8021 Q3398.2422,1837.7604 3396.8099,1835.5469 Q3395.3776,1833.3008 3395.3776,1830.6315 L3395.3776,1828.2227 Q3395.3776,1825.4557 3396.6471,1823.0794 Q3397.9492,1820.6706 3400.2279,1819.401 Q3402.5065,1818.099 3405.0781,1818.099 Q3406.6081,1818.099 3407.9427,1818.457 Q3409.3099,1818.7826 3410.4492,1819.5313 Z "/><text fill="#000000" font-family="sans-serif" font-size="25" lengthAdjust="spacingAndGlyphs" textLength="33.3333" x="3447.3958" y="1838.3545">col</text><line style="stroke: #A80036; stroke-width: 3.125;" x1="3270.8333" x2="3589.5833" y1="1861.4583" y2="1861.4583"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="181.25" x="3281.25" y="1930.7393">domainObject: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="187.5" x="3281.25" y="1959.5642">metadataError: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="139.5833" x="3281.25" y="1988.3891">cssClass: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="87.5" x="3281.25" y="2017.2139">size: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="62.5" x="3281.25" y="2046.0388">id: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="75" x="3281.25" y="2074.8637">span: 8</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="260.4167" x="3281.25" y="2103.6886">unreferencedActions: null</text><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="297.9167" x="3281.25" y="2132.5134">unreferencedCollections: true</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3270.8333" x2="3379.1667" y1="1892.5374" y2="1892.5374"/><text fill="#000000" font-family="sans-serif" font-size="22.9167" lengthAdjust="spacingAndGlyphs" textLength="102.0833" x="3379.1667" y="1900.8728">Properties</text><line style="stroke: #A80036; stroke-width: 2.0833333333333335; stroke-dasharray: 1.0,2.0;" x1="3481.25" x2="3589.5833" y1="1892.5374" y2="1892.5374"/><!--link root.row.0.cols.0.col.domainObject to root.row.0.cols.0.col.domainObject.link--><path d="M1538.5,2719.7917 C1468.9917,2819.1417 1386.2271,2937.4354 1326.2979,3023.0896 " fill="none" id="root.row.0.cols.0.col.domainObject-root.row.0.cols.0.col.domainObject.link" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.0.cols.0.col.action.0 to root.row.0.cols.0.col.action.0.link--><path d="M1765.3813,3378.2521 C1753.7563,3389.4021 1741.3417,3399.5729 1728.125,3408.3333 C1459.3813,3586.4583 1328.4542,3464.1875 1013.5417,3533.3333 C982.8292,3540.0771 951.1958,3547.4333 919.4229,3555.1208 " fill="none" id="root.row.0.cols.0.col.action.0-root.row.0.cols.0.col.action.0.link" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.0.cols.0.col.action.1 to root.row.0.cols.0.col.action.1.link--><path d="M2105.0417,3370.2188 C2093.2313,3383.8208 2080.7667,3396.6896 2067.7083,3408.3333 C2001.675,3467.2146 1920.0542,3516.1583 1840.7708,3555.1979 " fill="none" id="root.row.0.cols.0.col.action.1-root.row.0.cols.0.col.action.1.link" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.0.cols.0.col.action.2 to root.row.0.cols.0.col.action.2.link--><path d="M2578.125,3408.8354 C2578.125,3460.1063 2578.125,3511.3 2578.125,3554.6521 " fill="none" id="root.row.0.cols.0.col.action.2-root.row.0.cols.0.col.action.2.link" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.0.cols.0.col.action.3 to root.row.0.cols.0.col.action.3.link--><path d="M3399.4375,3345.2729 C3446.5208,3416.1854 3497.8333,3493.4479 3538.6458,3554.9021 " fill="none" id="root.row.0.cols.0.col.action.3-root.row.0.cols.0.col.action.3.link" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.0.cols.0.col.action to root.row.0.cols.0.col.action.0--><path d="M2222.6875,2658.3542 C2175.0208,2722.7708 2117.3333,2802.275 2067.7083,2875 C2056.1917,2891.875 2044.4292,2909.4854 2032.7375,2927.25 " fill="none" id="root.row.0.cols.0.col.action-root.row.0.cols.0.col.action.0" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.0.cols.0.col.action to root.row.0.cols.0.col.action.1--><path d="M2301.4583,2666.9167 C2293.2708,2728.4583 2283.3333,2803.1417 2273.7917,2874.8042 " fill="none" id="root.row.0.cols.0.col.action-root.row.0.cols.0.col.action.1" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.0.cols.0.col.action to root.row.0.cols.0.col.action.2--><path d="M2378.0833,2666.9167 C2404.125,2728.4583 2435.75,2803.1417 2466.0625,2874.8042 " fill="none" id="root.row.0.cols.0.col.action-root.row.0.cols.0.col.action.2" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.0.cols.0.col.action to root.row.0.cols.0.col.action.3--><path d="M2417.4583,2592.1875 C2587.8333,2702.1667 2939.6042,2929.1813 3132.2708,3053.5271 " fill="none" id="root.row.0.cols.0.col.action-root.row.0.cols.0.col.action.3" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.0.cols.0.col to root.row.0.cols.0.col.domainObject--><path d="M2161.2917,2107.9792 C2052.0854,2201.0208 1908.5896,2323.2917 1805.2438,2411.3542 " fill="none" id="root.row.0.cols.0.col-root.row.0.cols.0.col.domainObject" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.0.cols.0.col to root.row.0.cols.0.col.action--><path d="M2319.7917,2179.2708 C2319.7917,2248.5 2319.7917,2323.9583 2319.7917,2386.6875 " fill="none" id="root.row.0.cols.0.col-root.row.0.cols.0.col.action" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.0.cols.0 to root.row.0.cols.0.col--><path d="M2324.6667,1637.5417 C2324.125,1674.4583 2323.4792,1718.3958 2322.8333,1762.0208 " fill="none" id="root.row.0.cols.0-root.row.0.cols.0.col" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.0.cols to root.row.0.cols.0--><path d="M2564.4375,1307.1042 C2519.75,1350.6875 2466.8542,1402.2708 2422.25,1445.75 " fill="none" id="root.row.0.cols-root.row.0.cols.0" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.0 to root.row.0.cols--><path d="M2677.2917,975.4583 C2674.1458,1021.5833 2670.7083,1072.125 2667.8542,1114.3125 " fill="none" id="root.row.0-root.row.0.cols" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.1.cols.0.col.fieldSet.0.property.0 to root.row.1.cols.0.col.fieldSet.0.property.0.link--><path d="M2851,4438.2854 C2807.4375,4501.6938 2761.6042,4568.4479 2724.2292,4622.8688 " fill="none" id="root.row.1.cols.0.col.fieldSet.0.property.0-root.row.1.cols.0.col.fieldSet.0.property.0.link" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.1.cols.0.col.fieldSet.0.property.1 to root.row.1.cols.0.col.fieldSet.0.property.1.link--><path d="M3811.3125,4498.1479 C3796.4583,4542.1333 3781.875,4585.3854 3769.25,4622.8104 " fill="none" id="root.row.1.cols.0.col.fieldSet.0.property.1-root.row.1.cols.0.col.fieldSet.0.property.1.link" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.1.cols.0.col.fieldSet.0.property.2 to root.row.1.cols.0.col.fieldSet.0.property.2.link--><path d="M4728.7292,4498.1479 C4744.625,4542.1333 4760.2708,4585.3854 4773.7917,4622.8104 " fill="none" id="root.row.1.cols.0.col.fieldSet.0.property.2-root.row.1.cols.0.col.fieldSet.0.property.2.link" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.1.cols.0.col.fieldSet.0.property.3 to root.row.1.cols.0.col.fieldSet.0.property.3.link--><path d="M5796.0625,4498.1479 C5811.0833,4542.1333 5825.8333,4585.3854 5838.625,4622.8104 " fill="none" id="root.row.1.cols.0.col.fieldSet.0.property.3-root.row.1.cols.0.col.fieldSet.0.property.3.link" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.1.cols.0.col.fieldSet.0.property to root.row.1.cols.0.col.fieldSet.0.property.0--><path d="M4170.5625,3786.0771 C4159.0208,3795.8521 4146.875,3804.9021 4134.375,3812.5 C3969.1667,3912.9146 3900.5625,3874.7 3717.7083,3937.5 C3519.8542,4005.4542 3295.6042,4094.4646 3151.4583,4153.2688 " fill="none" id="root.row.1.cols.0.col.fieldSet.0.property-root.row.1.cols.0.col.fieldSet.0.property.0" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.1.cols.0.col.fieldSet.0.property to root.row.1.cols.0.col.fieldSet.0.property.1--><path d="M4175.2917,3812.8208 C4138.8958,3867.0979 4096.1667,3930.8458 4055.5417,3991.4104 " fill="none" id="root.row.1.cols.0.col.fieldSet.0.property-root.row.1.cols.0.col.fieldSet.0.property.1" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.1.cols.0.col.fieldSet.0.property to root.row.1.cols.0.col.fieldSet.0.property.2--><path d="M4359.5833,3812.8208 C4395.5625,3866.7854 4437.7917,3930.1104 4477.9583,3990.3625 " fill="none" id="root.row.1.cols.0.col.fieldSet.0.property-root.row.1.cols.0.col.fieldSet.0.property.2" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.1.cols.0.col.fieldSet.0.property to root.row.1.cols.0.col.fieldSet.0.property.3--><path d="M4365.1042,3711.7333 C4610.6875,3804.3604 5256.5208,4047.9583 5550.9167,4159.0042 " fill="none" id="root.row.1.cols.0.col.fieldSet.0.property-root.row.1.cols.0.col.fieldSet.0.property.3" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.1.cols.0.col.fieldSet.0 to root.row.1.cols.0.col.fieldSet.0.property--><path d="M4048.0625,3307.6333 C4091.75,3379.8583 4142.5,3463.7958 4184.2083,3532.7729 " fill="none" id="root.row.1.cols.0.col.fieldSet.0-root.row.1.cols.0.col.fieldSet.0.property" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.1.cols.0.col.fieldSet to root.row.1.cols.0.col.fieldSet.0--><path d="M3296.2292,2608.3333 C3421.4792,2710.2708 3640.7708,2888.7479 3790.2917,3010.45 " fill="none" id="root.row.1.cols.0.col.fieldSet-root.row.1.cols.0.col.fieldSet.0" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.1.cols.0.col to root.row.1.cols.0.col.fieldSet--><path d="M3097.2083,2179.2708 C3122.625,2265.6458 3150.9167,2361.75 3171.1875,2430.6667 " fill="none" id="root.row.1.cols.0.col-root.row.1.cols.0.col.fieldSet" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.1.cols.0 to root.row.1.cols.0.col--><path d="M3036.4583,1637.5417 C3036.4583,1674.4583 3036.4583,1718.3958 3036.4583,1762.0208 " fill="none" id="root.row.1.cols.0-root.row.1.cols.0.col" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.1.cols.1 to root.row.1.cols.1.col--><path d="M3386.375,1637.5417 C3392.4792,1683.75 3400.0625,1740.9583 3407.1875,1794.7708 " fill="none" id="root.row.1.cols.1-root.row.1.cols.1.col" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.1.cols to root.row.1.cols.0--><path d="M3036.4583,1321.4167 C3036.4583,1361.5625 3036.4583,1406.6667 3036.4583,1445.3958 " fill="none" id="root.row.1.cols-root.row.1.cols.0" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.1.cols to root.row.1.cols.1--><path d="M3134.0833,1307.1042 C3179.0417,1350.6875 3232.2708,1402.2708 3277.1458,1445.75 " fill="none" id="root.row.1.cols-root.row.1.cols.1" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row.1 to root.row.1.cols--><path d="M3003.4792,975.4583 C3009.2708,1016.4583 3015.5833,1060.9583 3021.1042,1099.9583 " fill="none" id="root.row.1-root.row.1.cols" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row to root.row.0--><path d="M2790.7917,577.0833 C2775.125,616.0625 2757.2292,660.5208 2740.75,701.5 " fill="none" id="root.row-root.row.0" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root.row to root.row.1--><path d="M2878.5625,577.0833 C2894.4792,616.0625 2912.6042,660.5208 2929.3125,701.5 " fill="none" id="root.row-root.row.1" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--link root to root.row--><path d="M2834.375,231.3125 C2834.375,270.8958 2834.375,315.9792 2834.375,355.875 " fill="none" id="root-root.row" style="stroke: #A80036; stroke-width: 2.0833333333333335;"/><!--
@startuml
skinparam dpi 200

class "root" as root {
.. Properties ..
cssClass: null
.. Objects ..
row: [Array]
}
class "row" as root.row {
.. Properties ..
.. Objects ..
0: [object Object]
1: [object Object]
}
class "0" as root.row.0 {
.. Properties ..
metadataError: null
cssClass: null
id: null
.. Objects ..
cols: [Array]
}
class "cols" as root.row.0.cols {
.. Properties ..
.. Objects ..
0: [object Object]
}
class "0" as root.row.0.cols.0 {
.. Properties ..
.. Objects ..
col: [object Object]
}
class "col" as root.row.0.cols.0.col {
.. Properties ..
metadataError: null
cssClass: null
size: null
id: null
span: 12
unreferencedActions: true
unreferencedCollections: null
.. Objects ..
domainObject: [object Object]
action: [Array]
}
class "domainObject" as root.row.0.cols.0.col.domainObject {
.. Properties ..
named: null
describedAs: null
plural: null
metadataError: null
bookmarking: null
cssClass: null
cssClassFa: null
cssClassFaPosition: null
namedEscaped: null
.. Objects ..
link: [object Object]
}
class "link" as root.row.0.cols.0.col.domainObject.link {
.. Properties ..
rel: urn:org.restfulobjects:rels/element
method: GET
href: http://localhost:8080/restful/objects/isisApplib.FixtureResult/;
type: application/jsonprofile&#x3D;&quot;urn:org.restfulobjects:repr-types/object&quot;
}
class "action" as root.row.0.cols.0.col.action {
.. Properties ..
.. Objects ..
0: [object Object]
1: [object Object]
2: [object Object]
3: [object Object]
}
class "0" as root.row.0.cols.0.col.action.0 {
.. Properties ..
named: null
describedAs: null
metadataError: null
id: clearHints
bookmarking: null
cssClass: null
cssClassFa: null
cssClassFaPosition: null
hidden: null
namedEscaped: null
position: null
promptStyle: null
.. Objects ..
link: [object Object]
}
class "link" as root.row.0.cols.0.col.action.0.link {
.. Properties ..
rel: urn:org.restfulobjects:rels/action
method: GET
href: http://localhost:8080/restful/objects/isisApplib.FixtureResult/;/actions/clearHints
type: application/jsonprofile&#x3D;&quot;urn:org.restfulobjects:repr-types/object-action&quot;
}
class "1" as root.row.0.cols.0.col.action.1 {
.. Properties ..
named: null
describedAs: null
metadataError: null
id: downloadLayoutXml
bookmarking: null
cssClass: null
cssClassFa: null
cssClassFaPosition: null
hidden: null
namedEscaped: null
position: null
promptStyle: null
.. Objects ..
link: [object Object]
}
class "link" as root.row.0.cols.0.col.action.1.link {
.. Properties ..
rel: urn:org.restfulobjects:rels/action
method: GET
href: http://localhost:8080/restful/objects/isisApplib.FixtureResult/;/actions/downloadLayoutXml
type: application/jsonprofile&#x3D;&quot;urn:org.restfulobjects:repr-types/object-action&quot;
}
class "2" as root.row.0.cols.0.col.action.2 {
.. Properties ..
named: null
describedAs: null
metadataError: null
id: rebuildMetamodel
bookmarking: null
cssClass: null
cssClassFa: null
cssClassFaPosition: null
hidden: null
namedEscaped: null
position: null
promptStyle: null
.. Objects ..
link: [object Object]
}
class "link" as root.row.0.cols.0.col.action.2.link {
.. Properties ..
rel: urn:org.restfulobjects:rels/action
method: GET
href: http://localhost:8080/restful/objects/isisApplib.FixtureResult/;/actions/rebuildMetamodel
type: application/jsonprofile&#x3D;&quot;urn:org.restfulobjects:repr-types/object-action&quot;
}
class "3" as root.row.0.cols.0.col.action.3 {
.. Properties ..
named: null
describedAs: null
metadataError: null
id: openRestApi
bookmarking: null
cssClass: null
cssClassFa: null
cssClassFaPosition: null
hidden: null
namedEscaped: null
position: null
promptStyle: null
.. Objects ..
link: [object Object]
}
class "link" as root.row.0.cols.0.col.action.3.link {
.. Properties ..
rel: urn:org.restfulobjects:rels/action
method: GET
href: http://localhost:8080/restful/objects/isisApplib.FixtureResult/;/actions/openRestApi
type: application/jsonprofile&#x3D;&quot;urn:org.restfulobjects:repr-types/object-action&quot;
}
class "1" as root.row.1 {
.. Properties ..
metadataError: null
cssClass: null
id: null
.. Objects ..
cols: [Array]
}
class "cols" as root.row.1.cols {
.. Properties ..
.. Objects ..
0: [object Object]
1: [object Object]
}
class "0" as root.row.1.cols.0 {
.. Properties ..
.. Objects ..
col: [object Object]
}
class "col" as root.row.1.cols.0.col {
.. Properties ..
domainObject: null
metadataError: null
cssClass: null
size: null
id: null
span: 4
unreferencedActions: null
unreferencedCollections: null
.. Objects ..
fieldSet: [Array]
}
class "fieldSet" as root.row.1.cols.0.col.fieldSet {
.. Properties ..
.. Objects ..
0: [object Object]
}
class "0" as root.row.1.cols.0.col.fieldSet.0 {
.. Properties ..
name: General
metadataError: null
id: general
unreferencedActions: null
unreferencedProperties: true
.. Objects ..
property: [Array]
}
class "property" as root.row.1.cols.0.col.fieldSet.0.property {
.. Properties ..
.. Objects ..
0: [object Object]
1: [object Object]
2: [object Object]
3: [object Object]
}
class "0" as root.row.1.cols.0.col.fieldSet.0.property.0 {
.. Properties ..
named: null
describedAs: null
metadataError: null
id: className
cssClass: null
hidden: null
labelPosition: null
multiLine: null
namedEscaped: null
promptStyle: null
renderedAsDayBefore: null
typicalLength: null
unchanging: null
.. Objects ..
link: [object Object]
}
class "link" as root.row.1.cols.0.col.fieldSet.0.property.0.link {
.. Properties ..
rel: urn:org.restfulobjects:rels/property
method: GET
href: http://localhost:8080/restful/objects/isisApplib.FixtureResult/;/properties/className
type: application/jsonprofile&#x3D;&quot;urn:org.restfulobjects:repr-types/object-property&quot;
}
class "1" as root.row.1.cols.0.col.fieldSet.0.property.1 {
.. Properties ..
named: null
describedAs: null
metadataError: null
id: fixtureScriptClassName
cssClass: null
hidden: null
labelPosition: null
multiLine: null
namedEscaped: null
promptStyle: null
renderedAsDayBefore: null
typicalLength: null
unchanging: null
.. Objects ..
link: [object Object]
}
class "link" as root.row.1.cols.0.col.fieldSet.0.property.1.link {
.. Properties ..
rel: urn:org.restfulobjects:rels/property
method: GET
href: http://localhost:8080/restful/objects/isisApplib.FixtureResult/;/properties/fixtureScriptClassName
type: application/jsonprofile&#x3D;&quot;urn:org.restfulobjects:repr-types/object-property&quot;
}
class "2" as root.row.1.cols.0.col.fieldSet.0.property.2 {
.. Properties ..
named: null
describedAs: null
metadataError: null
id: key
cssClass: null
hidden: null
labelPosition: null
multiLine: null
namedEscaped: null
promptStyle: null
renderedAsDayBefore: null
typicalLength: null
unchanging: null
.. Objects ..
link: [object Object]
}
class "link" as root.row.1.cols.0.col.fieldSet.0.property.2.link {
.. Properties ..
rel: urn:org.restfulobjects:rels/property
method: GET
href: http://localhost:8080/restful/objects/isisApplib.FixtureResult/;/properties/key
type: application/jsonprofile&#x3D;&quot;urn:org.restfulobjects:repr-types/object-property&quot;
}
class "3" as root.row.1.cols.0.col.fieldSet.0.property.3 {
.. Properties ..
named: null
describedAs: null
metadataError: null
id: object
cssClass: null
hidden: null
labelPosition: null
multiLine: null
namedEscaped: null
promptStyle: null
renderedAsDayBefore: null
typicalLength: null
unchanging: null
.. Objects ..
link: [object Object]
}
class "link" as root.row.1.cols.0.col.fieldSet.0.property.3.link {
.. Properties ..
rel: urn:org.restfulobjects:rels/property
method: GET
href: http://localhost:8080/restful/objects/isisApplib.FixtureResult/;/properties/object
type: application/jsonprofile&#x3D;&quot;urn:org.restfulobjects:repr-types/object-property&quot;
}
class "1" as root.row.1.cols.1 {
.. Properties ..
.. Objects ..
col: [object Object]
}
class "col" as root.row.1.cols.1.col {
.. Properties ..
domainObject: null
metadataError: null
cssClass: null
size: null
id: null
span: 8
unreferencedActions: null
unreferencedCollections: true
}
root.row.0.cols.0.col.domainObject - - root.row.0.cols.0.col.domainObject.link
root.row.0.cols.0.col.action.0 - - root.row.0.cols.0.col.action.0.link
root.row.0.cols.0.col.action.1 - - root.row.0.cols.0.col.action.1.link
root.row.0.cols.0.col.action.2 - - root.row.0.cols.0.col.action.2.link
root.row.0.cols.0.col.action.3 - - root.row.0.cols.0.col.action.3.link
root.row.0.cols.0.col.action - - root.row.0.cols.0.col.action.0
root.row.0.cols.0.col.action - - root.row.0.cols.0.col.action.1
root.row.0.cols.0.col.action - - root.row.0.cols.0.col.action.2
root.row.0.cols.0.col.action - - root.row.0.cols.0.col.action.3
root.row.0.cols.0.col - - root.row.0.cols.0.col.domainObject
root.row.0.cols.0.col - - root.row.0.cols.0.col.action
root.row.0.cols.0 - - root.row.0.cols.0.col
root.row.0.cols - - root.row.0.cols.0
root.row.0 - - root.row.0.cols
root.row.1.cols.0.col.fieldSet.0.property.0 - - root.row.1.cols.0.col.fieldSet.0.property.0.link
root.row.1.cols.0.col.fieldSet.0.property.1 - - root.row.1.cols.0.col.fieldSet.0.property.1.link
root.row.1.cols.0.col.fieldSet.0.property.2 - - root.row.1.cols.0.col.fieldSet.0.property.2.link
root.row.1.cols.0.col.fieldSet.0.property.3 - - root.row.1.cols.0.col.fieldSet.0.property.3.link
root.row.1.cols.0.col.fieldSet.0.property - - root.row.1.cols.0.col.fieldSet.0.property.0
root.row.1.cols.0.col.fieldSet.0.property - - root.row.1.cols.0.col.fieldSet.0.property.1
root.row.1.cols.0.col.fieldSet.0.property - - root.row.1.cols.0.col.fieldSet.0.property.2
root.row.1.cols.0.col.fieldSet.0.property - - root.row.1.cols.0.col.fieldSet.0.property.3
root.row.1.cols.0.col.fieldSet.0 - - root.row.1.cols.0.col.fieldSet.0.property
root.row.1.cols.0.col.fieldSet - - root.row.1.cols.0.col.fieldSet.0
root.row.1.cols.0.col - - root.row.1.cols.0.col.fieldSet
root.row.1.cols.0 - - root.row.1.cols.0.col
root.row.1.cols.1 - - root.row.1.cols.1.col
root.row.1.cols - - root.row.1.cols.0
root.row.1.cols - - root.row.1.cols.1
root.row.1 - - root.row.1.cols
root.row - - root.row.0
root.row - - root.row.1
root - - root.row
@enduml

PlantUML version 1.2019.07(Mon Jun 24 21:59:20 CEST 2019)
(GPL source distribution)
Java Runtime: OpenJDK Runtime Environment
JVM: OpenJDK 64-Bit Server VM
Java Version: 12.0.1+12
Operating System: Windows 10
OS Version: 10.0
Default Encoding: UTF-8
Language: en
Country: US
--></g></svg>
"""

    init {
        val map = Maps {
            width = CssSize(100, UNIT.pc)
            height = CssSize(100, UNIT.pc)
            margin = CssSize(10, UNIT.px)
        }

        map.configureLeafletMap {
            val optionsDynamic: dynamic = options.asDynamic()
            optionsDynamic.contextmenuItems = listOf(
                obj {
                    text = "Zoom in"
                    icon = "images/zoom-in.png"
                },
                "-",
                obj {
                    text = "Center map here"
                    callback = { e: dynamic ->
                        this@configureLeafletMap.panTo(e.latlng)
                    }
                },
            )

            val svg = ScalableVectorGraphic(str)
            svg.scaleHorizontally()
            val svgDoc = svg.document
            val svgElement = svgDoc.documentElement
            console.log("[SvgMap]$svgElement")

//TODO implement extension function  and adopt new version of kvsion.maps
            /*        val bounds = LatLngBounds(
                        LatLng(0, 0),
                        LatLng(0.1, 0.1))
                map.svgOverlay(svgElement, bounds)*/
        }

    }
}
