/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.utils;

import java.util.Objects;

public class MetricUtils {
    private static final String DATA = "Data.db";
    private static final String COMPRESSION = "CompressionInfo.db";
    private static final String DIGEST = "Digest.crc32";
    private static final String FILTER = "Filter.db";
    private static final String INDEX = "Index.db";
    private static final String STATISTICS = "Statistics.db";
    private static final String SUMMARY = "Summary.db";

    public static String parseSSTableComponent(String filename) {
        Objects.requireNonNull(filename, "Filename can not be null for SSTable component parsing");
        String trimmedFilename = filename.trim();
        if (trimmedFilename.endsWith(DATA)) {
            return DATA;
        }
        if (trimmedFilename.endsWith(COMPRESSION)) {
            return COMPRESSION;
        }
        if (trimmedFilename.endsWith(DIGEST)) {
            return DIGEST;
        }
        if (trimmedFilename.endsWith(FILTER)) {
            return FILTER;
        }
        if (trimmedFilename.endsWith(INDEX)) {
            return INDEX;
        }
        if (trimmedFilename.endsWith(STATISTICS)) {
            return STATISTICS;
        }
        if (trimmedFilename.endsWith(SUMMARY)) {
            return SUMMARY;
        }
        return "unknown";
    }
}

