/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.livemigration;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.common.response.InstanceFileInfo;
import org.apache.cassandra.sidecar.config.LiveMigrationConfiguration;
import org.apache.cassandra.sidecar.livemigration.CassandraInstanceFiles;
import org.apache.cassandra.sidecar.livemigration.DirVisitor;
import org.apache.cassandra.sidecar.livemigration.LiveMigrationInstanceMetadataUtil;
import org.apache.cassandra.sidecar.livemigration.LiveMigrationPlaceholderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraInstanceFilesImpl
implements CassandraInstanceFiles {
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraInstanceFilesImpl.class);
    private final InstanceMetadata instanceMetadata;
    private final LiveMigrationConfiguration configuration;

    public CassandraInstanceFilesImpl(InstanceMetadata instanceMetadata, LiveMigrationConfiguration configuration) {
        this.instanceMetadata = instanceMetadata;
        this.configuration = configuration;
    }

    @Override
    public List<InstanceFileInfo> files() throws IOException {
        return this.files(this.configuration.filesToExclude(), this.configuration.directoriesToExclude());
    }

    private List<InstanceFileInfo> files(Set<String> filesToExclude, Set<String> dirsToExclude) throws IOException {
        List<DirVisitor> dirVisitors = this.dirVisitorList(filesToExclude, dirsToExclude);
        ArrayList<InstanceFileInfo> instanceFileInfos = new ArrayList<InstanceFileInfo>();
        for (DirVisitor dirVisitor : dirVisitors) {
            instanceFileInfos.addAll(dirVisitor.files());
        }
        LOGGER.info("{} number of files are getting listed", (Object)instanceFileInfos.size());
        return instanceFileInfos;
    }

    private List<DirVisitor> dirVisitorList(Set<String> filesToExclude, Set<String> dirsToExclude) {
        ArrayList<DirVisitor> dataFilesToVisit = new ArrayList<DirVisitor>();
        List<String> dirsToCopy = LiveMigrationInstanceMetadataUtil.dirsToCopy(this.instanceMetadata);
        Map<String, String> dirPathPrefix = LiveMigrationInstanceMetadataUtil.dirPathPrefixMap(this.instanceMetadata);
        Map<String, Set<String>> dirPlaceholderMap = LiveMigrationInstanceMetadataUtil.dirPlaceHoldersMap(this.instanceMetadata);
        for (String dir : dirsToCopy) {
            this.dirToVisit(dir, dirPlaceholderMap.get(dir), dirPathPrefix.get(dir), filesToExclude, dirsToExclude).ifPresent(dataFilesToVisit::add);
        }
        return dataFilesToVisit;
    }

    private Optional<DirVisitor> dirToVisit(String homeDir, Set<String> placeholders, String pathPrefix, Set<String> filesToExclude, Set<String> dirsToExclude) {
        if (null == homeDir) {
            return Optional.empty();
        }
        Objects.requireNonNull(placeholders, "placeholders are required");
        Objects.requireNonNull(pathPrefix, "pathPrefix is required");
        Path homeDirPath = Paths.get(homeDir, new String[0]);
        if (!Files.exists(homeDirPath, new LinkOption[0])) {
            LOGGER.info("Directory {} does not exist.", (Object)homeDir);
            return Optional.empty();
        }
        List<PathMatcher> fileExclusionMatchers = this.toPathMatchers(filesToExclude, placeholders, homeDir);
        List<PathMatcher> dirExclusionMatchers = this.toPathMatchers(dirsToExclude, placeholders, homeDir);
        return Optional.of(new DirVisitor(homeDir, pathPrefix, fileExclusionMatchers, dirExclusionMatchers));
    }

    List<PathMatcher> toPathMatchers(Set<String> exclusions, Set<String> homeDirPlaceholders, String homeDir) {
        if (null == exclusions || exclusions.isEmpty()) {
            return Collections.emptyList();
        }
        return exclusions.stream().filter(exclusion -> !LiveMigrationPlaceholderUtil.hasAnyPlaceholder(exclusion) || LiveMigrationPlaceholderUtil.hasAnyPlaceholder(exclusion, homeDirPlaceholders)).map(file -> LiveMigrationPlaceholderUtil.replacePlaceholder(file, homeDirPlaceholders, homeDir)).filter(Objects::nonNull).map(file -> FileSystems.getDefault().getPathMatcher((String)file)).collect(Collectors.toList());
    }
}

