/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers.snapshots;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.io.FileNotFoundException;
import java.nio.file.NoSuchFileException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.common.response.ListSnapshotFilesResponse;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.config.CacheConfiguration;
import org.apache.cassandra.sidecar.config.ServiceConfiguration;
import org.apache.cassandra.sidecar.handlers.AbstractHandler;
import org.apache.cassandra.sidecar.handlers.AccessProtected;
import org.apache.cassandra.sidecar.handlers.data.SnapshotRequestParam;
import org.apache.cassandra.sidecar.metrics.CacheStatsCounter;
import org.apache.cassandra.sidecar.metrics.SidecarMetrics;
import org.apache.cassandra.sidecar.snapshots.SnapshotPathBuilder;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.apache.cassandra.sidecar.utils.RequestUtils;
import org.jetbrains.annotations.NotNull;

@Singleton
public class ListSnapshotHandler
extends AbstractHandler<SnapshotRequestParam>
implements AccessProtected {
    private static final String INCLUDE_SECONDARY_INDEX_FILES_QUERY_PARAM = "includeSecondaryIndexFiles";
    public static final String SNAPSHOT_CACHE_NAME = "snapshot_cache";
    private final SnapshotPathBuilder builder;
    private final ServiceConfiguration configuration;
    private final CacheConfiguration cacheConfiguration;
    private final Cache<String, Future<ListSnapshotFilesResponse>> cache;

    @Inject
    public ListSnapshotHandler(SnapshotPathBuilder builder, ServiceConfiguration configuration, InstanceMetadataFetcher metadataFetcher, CassandraInputValidator validator, ExecutorPools executorPools, SidecarMetrics sidecarMetrics) {
        super(metadataFetcher, executorPools, validator);
        this.builder = builder;
        this.configuration = configuration;
        this.cacheConfiguration = configuration.sstableSnapshotConfiguration().snapshotListCacheConfiguration();
        this.cache = this.initializeCache(this.cacheConfiguration, sidecarMetrics.server().cache().snapshotCacheMetrics);
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Collections.singleton(BasicPermissions.READ_SNAPSHOT.toAuthorization());
    }

    @Override
    public void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, SnapshotRequestParam request) {
        this.cachedResponseOrProcess(host, request).onSuccess(response -> {
            if (response.snapshotFilesInfo().isEmpty()) {
                String payload = "Snapshot '" + request.snapshotName() + "' not found";
                context.fail((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.NOT_FOUND, payload));
            } else {
                this.logger.debug("SnapshotsHandler handled request={}, remoteAddress={}, instance={}", new Object[]{request, remoteAddress, host});
                context.json(response);
            }
        }).onFailure(cause -> this.processFailure((Throwable)cause, context, host, remoteAddress, request));
    }

    @Override
    protected void processFailure(Throwable cause, RoutingContext context, String host, SocketAddress remoteAddress, SnapshotRequestParam request) {
        this.logger.error("SnapshotsHandler failed for request={}, remoteAddress={}, instance={}, method={}", new Object[]{request, remoteAddress, host, context.request().method(), cause});
        if (cause instanceof FileNotFoundException || cause instanceof NoSuchFileException) {
            context.fail((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.NOT_FOUND, cause.getMessage()));
        } else {
            super.processFailure(cause, context, host, remoteAddress, request);
        }
    }

    @Override
    protected SnapshotRequestParam extractParamsOrThrow(RoutingContext context) {
        boolean includeSecondaryIndexFiles = RequestUtils.parseBooleanQueryParam(context.request(), INCLUDE_SECONDARY_INDEX_FILES_QUERY_PARAM, false);
        return SnapshotRequestParam.builder().qualifiedTableName(this.qualifiedTableName(context)).snapshotName(context.pathParam("snapshot")).includeSecondaryIndexFiles(includeSecondaryIndexFiles).build();
    }

    protected Future<ListSnapshotFilesResponse> cachedResponseOrProcess(String host, SnapshotRequestParam request) {
        if (this.cache != null && this.cacheConfiguration.enabled()) {
            String key = host + ":" + request;
            return (Future)this.cache.get((Object)key, k -> this.processResponse(host, request));
        }
        return this.processResponse(host, request);
    }

    protected Future<ListSnapshotFilesResponse> processResponse(String host, SnapshotRequestParam request) {
        return this.dataPaths(host, request.keyspace(), request.tableName()).compose(dataDirectoryList -> this.builder.streamSnapshotFiles((List<String>)dataDirectoryList, request.snapshotName(), request.includeSecondaryIndexFiles())).compose(snapshotFileStream -> this.buildResponse(host, request, (Stream<SnapshotPathBuilder.SnapshotFile>)snapshotFileStream));
    }

    protected Future<List<String>> dataPaths(String host, String keyspace, String table) {
        return this.executorPools.service().executeBlocking(() -> this.metadataFetcher.delegate(host).tableOperations().getDataPaths(keyspace, table));
    }

    protected Future<ListSnapshotFilesResponse> buildResponse(String host, SnapshotRequestParam request, Stream<SnapshotPathBuilder.SnapshotFile> snapshotFileStream) {
        int sidecarPort = this.configuration.port();
        ListSnapshotFilesResponse response = new ListSnapshotFilesResponse();
        snapshotFileStream.forEach(file -> {
            String tableNameAndId = file.tableId != null ? request.tableName() + "-" + file.tableId : request.tableName();
            response.addSnapshotFile(new ListSnapshotFilesResponse.FileInfo(file.size, host, sidecarPort, file.dataDirectoryIndex, request.snapshotName(), request.keyspace(), tableNameAndId, file.name));
        });
        return Future.succeededFuture((Object)response);
    }

    protected Cache<String, Future<ListSnapshotFilesResponse>> initializeCache(CacheConfiguration cacheConfiguration, CacheStatsCounter snapshotCacheMetrics) {
        if (cacheConfiguration == null) {
            return null;
        }
        return Caffeine.newBuilder().maximumSize(cacheConfiguration.maximumSize()).expireAfterAccess(cacheConfiguration.expireAfterAccess().quantity(), cacheConfiguration.expireAfterAccess().unit()).recordStats(() -> snapshotCacheMetrics).removalListener((key, value, cause) -> this.logger.debug("Removed from cache={}, entry={}, key={}, cause={}", new Object[]{SNAPSHOT_CACHE_NAME, value, key, cause})).build();
    }
}

