/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.Future;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.nio.file.NoSuchFileException;
import java.util.List;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.acl.authorization.CassandraPermissions;
import org.apache.cassandra.sidecar.acl.authorization.ResourceScopes;
import org.apache.cassandra.sidecar.common.server.StorageOperations;
import org.apache.cassandra.sidecar.common.server.TableOperations;
import org.apache.cassandra.sidecar.common.server.data.Name;
import org.apache.cassandra.sidecar.common.server.data.QualifiedTableName;
import org.apache.cassandra.sidecar.common.server.utils.ThrowableUtils;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.handlers.AbstractHandler;
import org.apache.cassandra.sidecar.handlers.AccessProtected;
import org.apache.cassandra.sidecar.handlers.data.StreamSSTableComponentRequestParam;
import org.apache.cassandra.sidecar.snapshots.SnapshotPathBuilder;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.NotNull;

@Singleton
public class StreamSSTableComponentHandler
extends AbstractHandler<StreamSSTableComponentRequestParam>
implements AccessProtected {
    private final SnapshotPathBuilder snapshotPathBuilder;

    @Inject
    public StreamSSTableComponentHandler(InstanceMetadataFetcher metadataFetcher, SnapshotPathBuilder snapshotPathBuilder, CassandraInputValidator validator, ExecutorPools executorPools) {
        super(metadataFetcher, executorPools, validator);
        this.snapshotPathBuilder = snapshotPathBuilder;
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        Set<String> eligibleResources = ResourceScopes.TABLE_SCOPE.expandedResources();
        Authorization stream = BasicPermissions.STREAM_SNAPSHOT.toAuthorization();
        Authorization select = CassandraPermissions.SELECT.toAuthorization(eligibleResources);
        return Set.of(stream, select);
    }

    @Override
    public void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, StreamSSTableComponentRequestParam request) {
        this.resolveComponentPathFromRequest(host, request).onSuccess(path -> {
            this.logger.debug("{} resolved. path={}, request={}, remoteAddress={}, instance={}", new Object[]{this.getClass().getSimpleName(), path, request, remoteAddress, host});
            context.put("fileToTransfer", path).next();
        }).onFailure(cause -> this.processFailure((Throwable)cause, context, host, remoteAddress, request));
    }

    private Future<String> resolveComponentPathFromRequest(String host, StreamSSTableComponentRequestParam request) {
        return this.executorPools.internal().executeBlocking(() -> {
            int dataDirIndex = request.dataDirectoryIndex();
            if (request.tableId() != null) {
                StorageOperations storageOperations = this.metadataFetcher.delegate(host).storageOperations();
                List dataDirList = storageOperations.dataFileLocations();
                if (dataDirIndex < 0 || dataDirIndex >= dataDirList.size()) {
                    throw HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, "Invalid data directory index: " + dataDirIndex);
                }
                return this.snapshotPathBuilder.resolveComponentPathFromDataDirectory((String)dataDirList.get(dataDirIndex), request);
            }
            this.logger.debug("Streaming SSTable component without a table Id. request={}, instance={}", (Object)request, (Object)host);
            TableOperations tableOperations = this.metadataFetcher.delegate(host).tableOperations();
            List tableDirList = tableOperations.getDataPaths(request.keyspace(), request.tableName());
            if (dataDirIndex < 0 || dataDirIndex >= tableDirList.size()) {
                throw HttpExceptions.wrapHttpException(HttpResponseStatus.BAD_REQUEST, "Invalid data directory index: " + dataDirIndex);
            }
            return this.snapshotPathBuilder.resolveComponentPathFromTableDirectory((String)tableDirList.get(dataDirIndex), request);
        });
    }

    @Override
    protected void processFailure(Throwable cause, RoutingContext context, String host, SocketAddress remoteAddress, StreamSSTableComponentRequestParam request) {
        String errMsg = "StreamSSTableComponentHandler failed. request={}, remoteAddress={}, instance={}";
        this.logger.error(errMsg, new Object[]{request, remoteAddress, host, cause});
        if (cause instanceof NoSuchFileException) {
            context.fail((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.NOT_FOUND, cause.getMessage()));
        } else {
            InstanceNotFoundException instanceNotFoundException = (InstanceNotFoundException)ThrowableUtils.getCause((Throwable)cause, InstanceNotFoundException.class);
            if (instanceNotFoundException != null) {
                context.fail((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.NOT_FOUND, "keyspace/table combination not found"));
            } else {
                super.processFailure(cause, context, host, remoteAddress, request);
            }
        }
    }

    @Override
    protected StreamSSTableComponentRequestParam extractParamsOrThrow(RoutingContext context) {
        String tableNameParam = context.pathParam("table");
        Name tableName = this.validator.validateTableName(this.snapshotPathBuilder.maybeRemoveTableId(tableNameParam));
        QualifiedTableName qualifiedTableName = new QualifiedTableName(this.keyspace(context, true), tableName);
        return StreamSSTableComponentRequestParam.from(qualifiedTableName, context);
    }
}

