/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.common.server.utils.MillisecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.WorkerPoolConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerPoolConfigurationImpl
implements WorkerPoolConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkerPoolConfigurationImpl.class);
    @JsonProperty(value="name")
    protected final String workerPoolName;
    @JsonProperty(value="size")
    protected final int workerPoolSize;
    protected MillisecondBoundConfiguration workerMaxExecutionTime;

    public WorkerPoolConfigurationImpl() {
        this(null, 20, MillisecondBoundConfiguration.parse((String)"60s"));
    }

    public WorkerPoolConfigurationImpl(String workerPoolName, int workerPoolSize, MillisecondBoundConfiguration workerMaxExecutionTime) {
        this.workerPoolName = workerPoolName;
        this.workerPoolSize = workerPoolSize;
        this.workerMaxExecutionTime = workerMaxExecutionTime;
    }

    @Override
    @JsonProperty(value="name")
    public String workerPoolName() {
        return this.workerPoolName;
    }

    @Override
    @JsonProperty(value="size")
    public int workerPoolSize() {
        return this.workerPoolSize;
    }

    @Override
    @JsonProperty(value="max_execution_time")
    public MillisecondBoundConfiguration workerMaxExecutionTime() {
        return this.workerMaxExecutionTime;
    }

    @JsonProperty(value="max_execution_time")
    public void setWorkerMaxExecutionTime(MillisecondBoundConfiguration workerMaxExecutionTime) {
        this.workerMaxExecutionTime = workerMaxExecutionTime;
    }

    @JsonProperty(value="max_execution_time_millis")
    @Deprecated
    public void setWorkerMaxExecutionTimeMillis(long workerMaxExecutionTimeMillis) {
        LOGGER.warn("'max_execution_time_millis' is deprecated, use 'max_execution_time' instead");
        this.setWorkerMaxExecutionTime(new MillisecondBoundConfiguration(workerMaxExecutionTimeMillis, TimeUnit.MILLISECONDS));
    }
}

