/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authorization;

import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.auth.authorization.impl.WildcardPermissionBasedAuthorizationImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.sidecar.acl.authorization.CompositePermission;
import org.apache.cassandra.sidecar.acl.authorization.DomainAwarePermission;
import org.apache.cassandra.sidecar.acl.authorization.FeaturePermission;
import org.apache.cassandra.sidecar.acl.authorization.Permission;
import org.apache.cassandra.sidecar.acl.authorization.PermissionFactory;
import org.apache.cassandra.sidecar.acl.authorization.StandardPermission;

public class PermissionFactoryImpl
implements PermissionFactory {
    private static final String FORBIDDEN_PERMISSION_PREFIX = "*:";
    static final String FORBIDDEN_PREFIX_ERR_MSG = String.format("Permission with prefix %s are forbidden", "*:");
    private final List<CompositePermission> supportedFeaturePermissions;

    public PermissionFactoryImpl() {
        this(Collections.unmodifiableList(FeaturePermission.ALL_FEATURE_PERMISSIONS));
    }

    public PermissionFactoryImpl(List<CompositePermission> supportedFeaturePermissions) {
        this.supportedFeaturePermissions = supportedFeaturePermissions;
    }

    public List<CompositePermission> supportedFeaturePermissions() {
        return this.supportedFeaturePermissions;
    }

    @Override
    public Permission createPermission(String name) {
        Objects.requireNonNull(name, "name cannot be null");
        if (name.startsWith(FORBIDDEN_PERMISSION_PREFIX)) {
            throw new IllegalArgumentException(FORBIDDEN_PREFIX_ERR_MSG);
        }
        CompositePermission permission = this.createFeaturePermission(name);
        if (permission != null) {
            return permission;
        }
        boolean isDomainAware = name.contains(":");
        return isDomainAware ? new DomainAwarePermission(name) : new StandardPermission(name);
    }

    @Override
    public CompositePermission createFeaturePermission(String name) {
        ArrayList<Permission> combinedPermissions = new ArrayList<Permission>();
        WildcardPermissionBasedAuthorizationImpl requestedAuthorization = new WildcardPermissionBasedAuthorizationImpl(name);
        for (CompositePermission featurePermission : this.supportedFeaturePermissions()) {
            if (!requestedAuthorization.verify((Authorization)featurePermission.nameAuthorization())) continue;
            combinedPermissions.addAll(featurePermission.childPermissions());
        }
        return combinedPermissions.isEmpty() ? null : new CompositePermission(name, combinedPermissions);
    }
}

