/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.acl.authorization;

import java.util.Collections;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.ResourceScope;
import org.apache.cassandra.sidecar.common.utils.StringUtils;

public class DataResourceScope
implements ResourceScope {
    public static final String DATA = "data";
    public static final String DATA_WITH_KEYSPACE = String.format("data/{%s}", "keyspace");
    public static final String DATA_WITH_KEYSPACE_ALL_TABLES = String.format("data/{%s}/*", "keyspace");
    public static final String DATA_WITH_KEYSPACE_TABLE = String.format("data/{%s}/{%s}", "keyspace", "table");
    public static final DataResourceScope DATA_SCOPE = new DataResourceScope(false, false);
    public static final DataResourceScope KEYSPACE_SCOPE = new DataResourceScope(true, false);
    public static final DataResourceScope TABLE_SCOPE = new DataResourceScope(true, true);
    private static final String RESOURCE_PART_SPLITTER = "/";
    private final boolean keyspaceScoped;
    private final boolean tableScoped;
    private final Set<String> expandedResources;

    private DataResourceScope(boolean keyspaceScoped, boolean tableScoped) {
        this.keyspaceScoped = keyspaceScoped;
        this.tableScoped = tableScoped;
        this.expandedResources = this.initializeExpandedResources();
    }

    private Set<String> initializeExpandedResources() {
        if (this.tableScoped) {
            return Set.of(DATA, DATA_WITH_KEYSPACE, DATA_WITH_KEYSPACE_ALL_TABLES, DATA_WITH_KEYSPACE_TABLE);
        }
        if (this.keyspaceScoped) {
            return Set.of(DATA, DATA_WITH_KEYSPACE);
        }
        return Collections.singleton(DATA);
    }

    @Override
    public String variableAwareResource() {
        if (this.tableScoped) {
            return DATA_WITH_KEYSPACE_TABLE;
        }
        if (this.keyspaceScoped) {
            return DATA_WITH_KEYSPACE;
        }
        return DATA;
    }

    @Override
    public String resolveWithResource(String resource) {
        String[] parts = this.validate(resource);
        if (this.tableScoped) {
            return resource;
        }
        if (this.keyspaceScoped) {
            return parts.length == 3 ? "data/" + parts[1].trim() : resource;
        }
        return DATA;
    }

    @Override
    public Set<String> expandedResources() {
        return this.expandedResources;
    }

    private String[] validate(String resource) {
        if (StringUtils.isNullOrEmpty((String)resource)) {
            throw new IllegalArgumentException("Resource expected for resolving");
        }
        String[] parts = resource.split(RESOURCE_PART_SPLITTER);
        if (parts.length == 0 || !parts[0].equals(DATA) || resource.endsWith(RESOURCE_PART_SPLITTER) || parts.length > 3) {
            throw new IllegalArgumentException(String.format("%s is not a valid data resource, expected format is data/<keyspace>/<table>", resource));
        }
        for (String part : parts) {
            if (!part.trim().isEmpty()) continue;
            throw new IllegalArgumentException("Keyspace or table can not be empty in data resource");
        }
        return parts;
    }
}

