/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils.concurrent;

import com.google.common.util.concurrent.FutureCallback;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.apache.cassandra.utils.Shared;
import org.apache.cassandra.utils.concurrent.Future;

@Shared(scope={Shared.Scope.SIMULATION}, ancestors=Shared.Recursive.INTERFACES)
public interface Promise<V>
extends io.netty.util.concurrent.Promise<V>,
Future<V> {
    public static <V> GenericFutureListener<? extends Future<V>> listener(FutureCallback<V> callback) {
        return future -> {
            if (future.isSuccess()) {
                callback.onSuccess(future.getNow());
            } else {
                callback.onFailure(future.cause());
            }
        };
    }

    public static <V> GenericFutureListener<? extends Future<V>> listener(ExecutorService executor, FutureCallback<V> callback) {
        return future -> executor.execute(() -> {
            if (future.isSuccess()) {
                callback.onSuccess(future.getNow());
            } else {
                callback.onFailure(future.cause());
            }
        });
    }

    @Override
    public Promise<V> addCallback(FutureCallback<? super V> var1);

    @Override
    public Promise<V> addCallback(FutureCallback<? super V> var1, Executor var2);

    @Override
    public Promise<V> addCallback(Consumer<? super V> var1, Consumer<? super Throwable> var2);

    @Override
    public Promise<V> addListener(GenericFutureListener<? extends io.netty.util.concurrent.Future<? super V>> var1);

    @Override
    public Promise<V> addListeners(GenericFutureListener<? extends io.netty.util.concurrent.Future<? super V>> ... var1);

    @Override
    public Promise<V> removeListener(GenericFutureListener<? extends io.netty.util.concurrent.Future<? super V>> var1);

    @Override
    public Promise<V> removeListeners(GenericFutureListener<? extends io.netty.util.concurrent.Future<? super V>> ... var1);

    public Promise<V> setSuccess(V var1) throws IllegalStateException;

    public Promise<V> setFailure(Throwable var1) throws IllegalStateException;

    public boolean setUncancellableExclusive();

    @Override
    public Promise<V> await() throws InterruptedException;

    @Override
    public Promise<V> awaitUninterruptibly();

    @Override
    public Promise<V> awaitThrowUncheckedOnInterrupt();

    @Override
    public Promise<V> sync() throws InterruptedException;

    @Override
    public Promise<V> syncUninterruptibly();
}

