/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.settings;

import com.datastax.driver.core.Host;
import com.google.common.net.HostAndPort;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cassandra.stress.settings.GroupedOptions;
import org.apache.cassandra.stress.settings.Option;
import org.apache.cassandra.stress.settings.OptionSimple;
import org.apache.cassandra.stress.settings.StressSettings;
import org.apache.cassandra.stress.util.ResultLogger;

public class SettingsNode
implements Serializable {
    public final List<String> nodes;
    public final boolean isWhiteList;
    public final String datacenter;

    public SettingsNode(Options options) {
        block16: {
            if (options.file.setByUser()) {
                try {
                    ArrayList<String> tmpNodes = new ArrayList<String>();
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(options.file.value(), new String[0]), new OpenOption[0])));){
                        String node;
                        while ((node = in.readLine()) != null) {
                            if (node.length() <= 0) continue;
                            tmpNodes.add(node);
                        }
                        this.nodes = Arrays.asList(tmpNodes.toArray(new String[tmpNodes.size()]));
                        break block16;
                    }
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
            this.nodes = Arrays.asList(options.list.value().split(","));
        }
        this.isWhiteList = options.whitelist.setByUser();
        this.datacenter = options.datacenter.value();
    }

    public Set<String> resolveAllPermitted(StressSettings settings) {
        HashSet<String> r = new HashSet<String>();
        switch (settings.mode.api) {
            case JAVA_DRIVER_NATIVE: {
                if (!this.isWhiteList) {
                    for (Host host : settings.getJavaDriverClient().getCluster().getMetadata().getAllHosts()) {
                        r.add(host.getSocketAddress().getHostString() + ":" + host.getSocketAddress().getPort());
                    }
                    break;
                }
            }
            case SIMPLE_NATIVE: {
                for (InetAddress address : this.resolveAllSpecified()) {
                    r.add(address.getHostName());
                }
                break;
            }
        }
        return r;
    }

    public Set<InetAddress> resolveAllSpecified() {
        HashSet<InetAddress> r = new HashSet<InetAddress>();
        for (String node : this.nodes) {
            try {
                HostAndPort hap = HostAndPort.fromString((String)node);
                r.add(InetAddress.getByName(hap.getHost()));
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return r;
    }

    public Set<InetSocketAddress> resolveAll(int port) {
        HashSet<InetSocketAddress> r = new HashSet<InetSocketAddress>();
        for (String node : this.nodes) {
            try {
                HostAndPort hap = HostAndPort.fromString((String)node).withDefaultPort(port);
                r.add(new InetSocketAddress(InetAddress.getByName(hap.getHost()), hap.getPort()));
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return r;
    }

    public String randomNode() {
        int index = (int)(Math.random() * (double)this.nodes.size());
        if (index >= this.nodes.size()) {
            index = this.nodes.size() - 1;
        }
        return this.nodes.get(index);
    }

    public void printSettings(ResultLogger out) {
        out.println("  Nodes: " + this.nodes);
        out.println("  Is White List: " + this.isWhiteList);
        out.println("  Datacenter: " + this.datacenter);
    }

    public static SettingsNode get(Map<String, String[]> clArgs) {
        String[] params = clArgs.remove("-node");
        if (params == null) {
            return new SettingsNode(new Options());
        }
        GroupedOptions options = GroupedOptions.select((String[])params, (GroupedOptions[])new Options[]{new Options()});
        if (options == null) {
            SettingsNode.printHelp();
            System.out.println("Invalid -node options provided, see output for valid options");
            System.exit(1);
        }
        return new SettingsNode((Options)options);
    }

    public static void printHelp() {
        GroupedOptions.printOptions(System.out, "-node", new Options());
    }

    public static Runnable helpPrinter() {
        return SettingsNode::printHelp;
    }

    public static final class Options
    extends GroupedOptions {
        final OptionSimple datacenter = new OptionSimple("datacenter=", ".*", null, "Datacenter used for DCAwareRoundRobinLoadPolicy", false);
        final OptionSimple whitelist = new OptionSimple("whitelist", "", null, "Limit communications to the provided nodes", false);
        final OptionSimple file = new OptionSimple("file=", ".*", null, "Node file (one per line)", false);
        final OptionSimple list = new OptionSimple("", "[^=,]+(,[^=,]+)*", "localhost", "comma delimited list of nodes", false);

        @Override
        public List<? extends Option> options() {
            return Arrays.asList(this.datacenter, this.whitelist, this.file, this.list);
        }
    }
}

