/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.Destroyable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAKey;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.internal.Permissions;

public final class AsymmetricRSAPrivateKey
extends AsymmetricRSAKey
implements Destroyable,
AsymmetricPrivateKey {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private BigInteger publicExponent;
    private BigInteger privateExponent;
    private BigInteger p;
    private BigInteger q;
    private BigInteger dp;
    private BigInteger dq;
    private BigInteger qInv;
    private int hashCode;

    public AsymmetricRSAPrivateKey(Algorithm algorithm, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5, BigInteger bigInteger6, BigInteger bigInteger7, BigInteger bigInteger8) {
        super(algorithm, bigInteger);
        this.publicExponent = bigInteger2;
        this.privateExponent = bigInteger3;
        this.p = bigInteger4;
        this.q = bigInteger5;
        this.dp = bigInteger6;
        this.dq = bigInteger7;
        this.qInv = bigInteger8;
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricRSAPrivateKey(Algorithm algorithm, BigInteger bigInteger, BigInteger bigInteger2) {
        super(algorithm, bigInteger);
        this.privateExponent = bigInteger2;
        this.publicExponent = BigInteger.ZERO;
        this.p = BigInteger.ZERO;
        this.q = BigInteger.ZERO;
        this.dp = BigInteger.ZERO;
        this.dq = BigInteger.ZERO;
        this.qInv = BigInteger.ZERO;
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricRSAPrivateKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, AsymmetricRSAPrivateKey.getPrivateKeyInfo(byArray));
    }

    public AsymmetricRSAPrivateKey(Algorithm algorithm, PrivateKeyInfo privateKeyInfo) {
        this(algorithm, privateKeyInfo.getPrivateKeyAlgorithm(), AsymmetricRSAPrivateKey.parsePrivateKey(privateKeyInfo));
    }

    private static PrivateKeyInfo getPrivateKeyInfo(byte[] byArray) {
        try {
            return PrivateKeyInfo.getInstance(byArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            try {
                return new PrivateKeyInfo(DEF_ALG_ID, ASN1Sequence.getInstance(byArray));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Unable to parse private key: " + illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }
    }

    private static RSAPrivateKey parsePrivateKey(PrivateKeyInfo privateKeyInfo) {
        try {
            return RSAPrivateKey.getInstance(privateKeyInfo.parsePrivateKey());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Unable to parse private key: " + iOException.getMessage(), iOException);
        }
    }

    private AsymmetricRSAPrivateKey(Algorithm algorithm, AlgorithmIdentifier algorithmIdentifier, RSAPrivateKey rSAPrivateKey) {
        super(algorithm, algorithmIdentifier, KeyUtils.validatedModulus(rSAPrivateKey.getModulus()));
        this.publicExponent = rSAPrivateKey.getPublicExponent();
        this.privateExponent = rSAPrivateKey.getPrivateExponent();
        this.p = rSAPrivateKey.getPrime1();
        this.q = rSAPrivateKey.getPrime2();
        this.dp = rSAPrivateKey.getExponent1();
        this.dq = rSAPrivateKey.getExponent2();
        this.qInv = rSAPrivateKey.getCoefficient();
        this.hashCode = this.calculateHashCode();
    }

    public Algorithm getAlgorithm() {
        Algorithm algorithm = super.getAlgorithm();
        KeyUtils.checkDestroyed(this);
        return algorithm;
    }

    public BigInteger getModulus() {
        BigInteger bigInteger = super.getModulus();
        KeyUtils.checkDestroyed(this);
        return bigInteger;
    }

    public BigInteger getPublicExponent() {
        BigInteger bigInteger = this.publicExponent;
        KeyUtils.checkDestroyed(this);
        return bigInteger;
    }

    public BigInteger getPrivateExponent() {
        return this.fieldValue(this.privateExponent);
    }

    public BigInteger getP() {
        return this.fieldValue(this.p);
    }

    public BigInteger getQ() {
        return this.fieldValue(this.q);
    }

    public BigInteger getDP() {
        return this.fieldValue(this.dp);
    }

    public BigInteger getDQ() {
        return this.fieldValue(this.dq);
    }

    public BigInteger getQInv() {
        return this.fieldValue(this.qInv);
    }

    public final byte[] getEncoded() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkDestroyed(this);
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        return KeyUtils.getEncodedPrivateKeyInfo(this.rsaAlgIdentifier, new RSAPrivateKey(this.getModulus(), this.publicExponent, this.getPrivateExponent(), this.getP(), this.getQ(), this.getDP(), this.getDQ(), this.getQInv()));
    }

    public void destroy() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            this.publicExponent = null;
            this.privateExponent = null;
            this.qInv = null;
            this.dq = null;
            this.dp = null;
            this.q = null;
            this.p = null;
            this.hashCode = -1;
            super.zeroize();
        }
    }

    public boolean isDestroyed() {
        this.checkApprovedOnlyModeStatus();
        return this.hasBeenDestroyed.get();
    }

    public boolean equals(Object object) {
        this.checkApprovedOnlyModeStatus();
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricRSAPrivateKey)) {
            return false;
        }
        AsymmetricRSAPrivateKey asymmetricRSAPrivateKey = (AsymmetricRSAPrivateKey)object;
        asymmetricRSAPrivateKey.checkApprovedOnlyModeStatus();
        return KeyUtils.isFieldEqual(this.modulus, asymmetricRSAPrivateKey.modulus) && KeyUtils.isFieldEqual(this.privateExponent, asymmetricRSAPrivateKey.privateExponent) && KeyUtils.isFieldEqual(this.publicExponent, asymmetricRSAPrivateKey.publicExponent) && KeyUtils.isFieldEqual(this.p, asymmetricRSAPrivateKey.p) && KeyUtils.isFieldEqual(this.q, asymmetricRSAPrivateKey.q) && KeyUtils.isFieldEqual(this.dp, asymmetricRSAPrivateKey.dp) && KeyUtils.isFieldEqual(this.dq, asymmetricRSAPrivateKey.dq) && KeyUtils.isFieldEqual(this.qInv, asymmetricRSAPrivateKey.qInv);
    }

    public int hashCode() {
        this.checkApprovedOnlyModeStatus();
        return this.hashCode;
    }

    private int calculateHashCode() {
        int n = this.getModulus().hashCode();
        n = 31 * n + this.publicExponent.hashCode();
        n = 31 * n + this.privateExponent.hashCode();
        n = 31 * n + this.p.hashCode();
        n = 31 * n + this.q.hashCode();
        n = 31 * n + this.dp.hashCode();
        n = 31 * n + this.dq.hashCode();
        n = 31 * n + this.qInv.hashCode();
        return n;
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    private void checkCanRead() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        KeyUtils.checkDestroyed(this);
    }

    private BigInteger fieldValue(BigInteger bigInteger) {
        this.checkCanRead();
        return bigInteger;
    }
}

