/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.perf.dlog;

import com.beust.jcommander.Parameter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.Recorder;
import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.perf.utils.PaddingDecimalFormat;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.api.namespace.Namespace;
import org.apache.distributedlog.api.namespace.NamespaceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PerfReaderBase
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PerfReaderBase.class);
    protected final LongAdder recordsRead = new LongAdder();
    protected final LongAdder bytesRead = new LongAdder();
    protected final ServiceURI serviceURI;
    protected final Flags flags;
    protected final Recorder recorder = new Recorder(TimeUnit.SECONDS.toMillis(120000L), 5);
    protected final Recorder cumulativeRecorder = new Recorder(TimeUnit.SECONDS.toMillis(120000L), 5);
    protected final AtomicBoolean isDone = new AtomicBoolean(false);
    protected static final DecimalFormat THROUGHPUT_FORMAT = new PaddingDecimalFormat("0.0", 8);
    protected static final DecimalFormat PADDING_DECIMAL_FORMAT = new PaddingDecimalFormat("0.000", 7);

    PerfReaderBase(ServiceURI serviceURI, Flags flags) {
        this.serviceURI = serviceURI;
        this.flags = flags;
    }

    protected void execute() throws Exception {
        ObjectMapper m = new ObjectMapper();
        ObjectWriter w = m.writerWithDefaultPrettyPrinter();
        log.info("Starting dlog perf reader with config : {}", (Object)w.writeValueAsString((Object)this.flags));
        DistributedLogConfiguration conf = PerfReaderBase.newDlogConf(this.flags);
        try (Namespace namespace = NamespaceBuilder.newBuilder().conf(conf).uri(this.serviceURI.getUri()).build();){
            this.execute(namespace);
        }
    }

    protected void reportStats() {
        long oldTime = System.nanoTime();
        Histogram reportHistogram = null;
        while (true) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                break;
            }
            if (this.isDone.get()) break;
            long now = System.nanoTime();
            double elapsed = (double)(now - oldTime) / 1.0E9;
            double rate = (double)this.recordsRead.sumThenReset() / elapsed;
            double throughput = (double)this.bytesRead.sumThenReset() / elapsed / 1024.0 / 1024.0;
            reportHistogram = this.recorder.getIntervalHistogram(reportHistogram);
            log.info("Throughput read : {}  records/s --- {} MB/s --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - Max: {}", new Object[]{THROUGHPUT_FORMAT.format(rate), THROUGHPUT_FORMAT.format(throughput), PADDING_DECIMAL_FORMAT.format(reportHistogram.getMean() / 1000.0), PADDING_DECIMAL_FORMAT.format((double)reportHistogram.getValueAtPercentile(50.0) / 1000.0), PADDING_DECIMAL_FORMAT.format((double)reportHistogram.getValueAtPercentile(95.0) / 1000.0), PADDING_DECIMAL_FORMAT.format((double)reportHistogram.getValueAtPercentile(99.0) / 1000.0), PADDING_DECIMAL_FORMAT.format((double)reportHistogram.getValueAtPercentile(99.9) / 1000.0), PADDING_DECIMAL_FORMAT.format((double)reportHistogram.getValueAtPercentile(99.99) / 1000.0), PADDING_DECIMAL_FORMAT.format((double)reportHistogram.getMaxValue() / 1000.0)});
            reportHistogram.reset();
            oldTime = now;
        }
    }

    protected abstract void execute(Namespace var1) throws Exception;

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (Exception e) {
            log.error("Encountered exception at running dlog perf writer", (Throwable)e);
        }
    }

    private static DistributedLogConfiguration newDlogConf(Flags flags) {
        DistributedLogConfiguration conf = new DistributedLogConfiguration().setReadAheadBatchSize(flags.readAheadBatchSize).setReadAheadMaxRecords(flags.maxReadAheadRecords).setReadAheadWaitTime(200);
        conf.setProperty("bkc.numChannelsPerBookie", (Object)8);
        return conf;
    }

    protected static void printAggregatedStats(Recorder recorder) {
        Histogram reportHistogram = recorder.getIntervalHistogram();
        log.info("Aggregated latency stats --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - 99.999pct: {} - Max: {}", new Object[]{PADDING_DECIMAL_FORMAT.format(reportHistogram.getMean() / 1000.0), PADDING_DECIMAL_FORMAT.format((double)reportHistogram.getValueAtPercentile(50.0) / 1000.0), PADDING_DECIMAL_FORMAT.format((double)reportHistogram.getValueAtPercentile(95.0) / 1000.0), PADDING_DECIMAL_FORMAT.format((double)reportHistogram.getValueAtPercentile(99.0) / 1000.0), PADDING_DECIMAL_FORMAT.format((double)reportHistogram.getValueAtPercentile(99.9) / 1000.0), PADDING_DECIMAL_FORMAT.format((double)reportHistogram.getValueAtPercentile(99.99) / 1000.0), PADDING_DECIMAL_FORMAT.format((double)reportHistogram.getValueAtPercentile(99.999) / 1000.0), PADDING_DECIMAL_FORMAT.format((double)reportHistogram.getMaxValue() / 1000.0)});
    }

    public static class Flags
    extends CliFlags {
        @Parameter(names={"-ln", "--log-name"}, description="Log name or log name pattern if more than 1 log is specified at `--num-logs`")
        public String logName = "test-log-%06d";
        @Parameter(names={"-l", "--num-logs"}, description="Number of log streams")
        public int numLogs = 1;
        @Parameter(names={"-t", "--threads"}, description="Number of threads reading")
        public int numThreads = 1;
        @Parameter(names={"-mr", "--max-readahead-records"}, description="Max readhead records")
        public int maxReadAheadRecords = 1000000;
        @Parameter(names={"-ns", "--num-splits-per-segment"}, description="Num splits per segment")
        public int numSplitsPerSegment = 1;
        @Parameter(names={"-bs", "--readahead-batch-size"}, description="ReadAhead Batch Size, in entries")
        public int readAheadBatchSize = 4;
    }
}

