/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.http;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.commons.configuration2.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServerLoader {
    static final Logger LOG = LoggerFactory.getLogger(HttpServerLoader.class);
    public static final String HTTP_SERVER_CLASS = "httpServerClass";
    static HttpServer server = null;

    public static void loadHttpServer(Configuration conf) {
        String className = conf.getString(HTTP_SERVER_CLASS);
        if (className != null) {
            try {
                Class<?> cls = Class.forName(className);
                Constructor<?> cons = cls.getDeclaredConstructor(new Class[0]);
                server = (HttpServer)cons.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException cnfe) {
                LOG.error("Couldn't find configured class(" + className + ")", (Throwable)cnfe);
            }
            catch (NoSuchMethodException nsme) {
                LOG.error("Couldn't find default constructor for class (" + className + ")", (Throwable)nsme);
            }
            catch (InstantiationException ie) {
                LOG.error("Couldn't construct class (" + className + ")", (Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                LOG.error("Couldn't construct class (" + className + "), Is the constructor private?", (Throwable)iae);
            }
            catch (InvocationTargetException ite) {
                LOG.error("Constructor threw an exception. It should not have.", (Throwable)ite);
            }
        }
    }

    public static HttpServer get() {
        return server;
    }
}

