/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jute.Record;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.CreateOptions;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.proto.CreateResponse;
import org.apache.zookeeper.proto.CreateTTLRequest;
import org.apache.zookeeper.proto.ReplyHeader;
import org.apache.zookeeper.proto.RequestHeader;
import org.apache.zookeeper.server.ContainerManager;
import org.apache.zookeeper.server.DataNode;
import org.apache.zookeeper.server.EphemeralType;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class CreateTTLTest
extends ClientBase {
    private TestableZooKeeper zk;
    private static final Collection<String> disabledTests = Collections.singleton("testDisabled");

    @Override
    public void setUp() throws Exception {
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        System.setProperty("zookeeper.extendedTypesEnabled", disabledTests.contains(((Method)testInfo.getTestMethod().get()).getName()) ? "false" : "true");
        super.setUpWithServerId(254);
        this.zk = this.createClient();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        System.clearProperty("zookeeper.extendedTypesEnabled");
        super.tearDown();
        this.zk.close();
    }

    @Test
    public void testCreate() throws KeeperException, InterruptedException {
        Stat stat = new Stat();
        this.zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_WITH_TTL, stat, 100L);
        Assertions.assertEquals((long)0L, (long)stat.getEphemeralOwner());
        AtomicLong fakeElapsed = new AtomicLong(0L);
        ContainerManager containerManager = this.newContainerManager(fakeElapsed);
        containerManager.checkContainers();
        Assertions.assertNotNull((Object)this.zk.exists("/foo", false), (String)"Ttl node should not have been deleted yet");
        fakeElapsed.set(1000L);
        containerManager.checkContainers();
        Assertions.assertNull((Object)this.zk.exists("/foo", false), (String)"Ttl node should have been deleted");
    }

    @Test
    public void testBadTTLs() throws InterruptedException, KeeperException {
        RequestHeader h = new RequestHeader(1, 21);
        String path = "/bad_ttl";
        CreateTTLRequest request = new CreateTTLRequest(path, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_WITH_TTL.toFlag(), -100L);
        CreateResponse response = new CreateResponse();
        ReplyHeader r = this.zk.submitRequest(h, (Record)request, (Record)response, null);
        Assertions.assertEquals((int)r.getErr(), (int)KeeperException.Code.BADARGUMENTS.intValue(), (String)"An invalid CreateTTLRequest should throw BadArguments");
        Assertions.assertNull((Object)this.zk.exists(path, false), (String)"An invalid CreateTTLRequest should not result in znode creation");
        request = new CreateTTLRequest(path, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_WITH_TTL.toFlag(), EphemeralType.TTL.maxValue() + 1L);
        response = new CreateResponse();
        r = this.zk.submitRequest(h, (Record)request, (Record)response, null);
        Assertions.assertEquals((int)r.getErr(), (int)KeeperException.Code.BADARGUMENTS.intValue(), (String)"An invalid CreateTTLRequest should throw BadArguments");
        Assertions.assertNull((Object)this.zk.exists(path, false), (String)"An invalid CreateTTLRequest should not result in znode creation");
    }

    @Test
    public void testMaxTTLs() throws InterruptedException, KeeperException {
        RequestHeader h = new RequestHeader(1, 21);
        String path = "/bad_ttl";
        CreateTTLRequest request = new CreateTTLRequest(path, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_WITH_TTL.toFlag(), EphemeralType.TTL.maxValue());
        CreateResponse response = new CreateResponse();
        ReplyHeader r = this.zk.submitRequest(h, (Record)request, (Record)response, null);
        Assertions.assertEquals((int)r.getErr(), (int)KeeperException.Code.OK.intValue(), (String)"EphemeralType.getMaxTTL() should succeed");
        Assertions.assertNotNull((Object)this.zk.exists(path, false), (String)"Node should exist");
    }

    @Test
    public void testCreateSequential() throws KeeperException, InterruptedException {
        Stat stat = new Stat();
        String path = this.zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_SEQUENTIAL_WITH_TTL, stat, 100L);
        Assertions.assertEquals((long)0L, (long)stat.getEphemeralOwner());
        AtomicLong fakeElapsed = new AtomicLong(0L);
        ContainerManager containerManager = this.newContainerManager(fakeElapsed);
        containerManager.checkContainers();
        Assertions.assertNotNull((Object)this.zk.exists(path, false), (String)"Ttl node should not have been deleted yet");
        fakeElapsed.set(1000L);
        containerManager.checkContainers();
        Assertions.assertNull((Object)this.zk.exists(path, false), (String)"Ttl node should have been deleted");
    }

    @Test
    public void testCreateAsync() throws KeeperException, InterruptedException {
        AsyncCallback.Create2Callback callback = (rc, path, ctx, name, stat) -> {};
        this.zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_WITH_TTL, callback, null, 100L);
        AtomicLong fakeElapsed = new AtomicLong(0L);
        ContainerManager containerManager = this.newContainerManager(fakeElapsed);
        containerManager.checkContainers();
        Assertions.assertNotNull((Object)this.zk.exists("/foo", false), (String)"Ttl node should not have been deleted yet");
        fakeElapsed.set(1000L);
        containerManager.checkContainers();
        Assertions.assertNull((Object)this.zk.exists("/foo", false), (String)"Ttl node should have been deleted");
    }

    @Test
    public void testModifying() throws KeeperException, InterruptedException {
        Stat stat = new Stat();
        this.zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_WITH_TTL, stat, 100L);
        Assertions.assertEquals((long)0L, (long)stat.getEphemeralOwner());
        AtomicLong fakeElapsed = new AtomicLong(0L);
        ContainerManager containerManager = this.newContainerManager(fakeElapsed);
        containerManager.checkContainers();
        Assertions.assertNotNull((Object)this.zk.exists("/foo", false), (String)"Ttl node should not have been deleted yet");
        for (int i = 0; i < 10; ++i) {
            fakeElapsed.set(50L);
            this.zk.setData("/foo", new byte[i + 1], -1);
            containerManager.checkContainers();
            Assertions.assertNotNull((Object)this.zk.exists("/foo", false), (String)"Ttl node should not have been deleted yet");
        }
        fakeElapsed.set(200L);
        containerManager.checkContainers();
        Assertions.assertNull((Object)this.zk.exists("/foo", false), (String)"Ttl node should have been deleted");
    }

    @Test
    public void testMulti() throws KeeperException, InterruptedException {
        CreateOptions options = CreateOptions.newBuilder((List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT_WITH_TTL).withTtl(100L).build();
        CreateOptions sequentialOptions = CreateOptions.newBuilder((List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT_SEQUENTIAL_WITH_TTL).withTtl(200L).build();
        Op createTtl = Op.create((String)"/a", (byte[])new byte[0], (List)options.getAcl(), (CreateMode)options.getCreateMode(), (long)options.getTtl());
        Op createTtl2 = Op.create((String)"/a2", (byte[])new byte[0], (CreateOptions)options);
        Op createTtlSequential = Op.create((String)"/b", (byte[])new byte[0], (List)sequentialOptions.getAcl(), (CreateMode)sequentialOptions.getCreateMode(), (long)sequentialOptions.getTtl());
        Op createTtlSequential2 = Op.create((String)"/b2", (byte[])new byte[0], (CreateOptions)sequentialOptions);
        Op createNonTtl = Op.create((String)"/c", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT);
        List results = this.zk.multi(Arrays.asList(createTtl, createTtl2, createTtlSequential, createTtlSequential2, createNonTtl));
        String sequentialPath = ((OpResult.CreateResult)results.get(2)).getPath();
        String sequentialPath2 = ((OpResult.CreateResult)results.get(3)).getPath();
        AtomicLong fakeElapsed = new AtomicLong(0L);
        ContainerManager containerManager = this.newContainerManager(fakeElapsed);
        containerManager.checkContainers();
        Assertions.assertNotNull((Object)this.zk.exists("/a", false), (String)"node should not have been deleted yet");
        Assertions.assertNotNull((Object)this.zk.exists("/a2", false), (String)"node should not have been deleted yet");
        Assertions.assertNotNull((Object)this.zk.exists(sequentialPath, false), (String)"node should not have been deleted yet");
        Assertions.assertNotNull((Object)this.zk.exists(sequentialPath2, false), (String)"node should not have been deleted yet");
        Assertions.assertNotNull((Object)this.zk.exists("/c", false), (String)"node should never be deleted");
        fakeElapsed.set(110L);
        containerManager.checkContainers();
        Assertions.assertNull((Object)this.zk.exists("/a", false), (String)"node should have been deleted");
        Assertions.assertNull((Object)this.zk.exists("/a2", false), (String)"node should have been deleted");
        Assertions.assertNotNull((Object)this.zk.exists(sequentialPath, false), (String)"node should not have been deleted yet");
        Assertions.assertNotNull((Object)this.zk.exists(sequentialPath2, false), (String)"node should not have been deleted yet");
        Assertions.assertNotNull((Object)this.zk.exists("/c", false), (String)"node should never be deleted");
        fakeElapsed.set(210L);
        containerManager.checkContainers();
        Assertions.assertNull((Object)this.zk.exists("/a", false), (String)"node should have been deleted");
        Assertions.assertNull((Object)this.zk.exists("/a2", false), (String)"node should have been deleted");
        Assertions.assertNull((Object)this.zk.exists(sequentialPath, false), (String)"node should have been deleted");
        Assertions.assertNull((Object)this.zk.exists(sequentialPath2, false), (String)"node should have been deleted");
        Assertions.assertNotNull((Object)this.zk.exists("/c", false), (String)"node should never be deleted");
    }

    @Test
    public void testBadUsage() throws KeeperException, InterruptedException {
        Op op2;
        for (CreateMode createMode : CreateMode.values()) {
            try {
                this.zk.create("/foo", new byte[]{}, ZooDefs.Ids.OPEN_ACL_UNSAFE, createMode, new Stat(), createMode.isTTL() ? 0L : 100L);
                Assertions.fail((String)"should have thrown IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        for (CreateMode createMode : CreateMode.values()) {
            AsyncCallback.Create2Callback callback = (rc, path, ctx, name, stat) -> {};
            try {
                this.zk.create("/foo", new byte[]{}, ZooDefs.Ids.OPEN_ACL_UNSAFE, createMode, callback, null, createMode.isTTL() ? 0L : 100L);
                Assertions.fail((String)"should have thrown IllegalArgumentException");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        try {
            op2 = Op.create((String)"/foo", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT_WITH_TTL, (long)0L);
            this.zk.multi(Collections.singleton(op2));
            Assertions.fail((String)"should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException op2) {
            // empty catch block
        }
        try {
            op2 = Op.create((String)"/foo", (byte[])new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, (CreateMode)CreateMode.PERSISTENT_SEQUENTIAL_WITH_TTL, (long)0L);
            this.zk.multi(Collections.singleton(op2));
            Assertions.fail((String)"should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testDisabled() throws KeeperException, InterruptedException {
        Assertions.assertThrows(KeeperException.UnimplementedException.class, () -> this.zk.create("/foo", new byte[0], ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT_WITH_TTL, new Stat(), 100L));
    }

    private ContainerManager newContainerManager(final AtomicLong fakeElapsed) {
        return new ContainerManager(this.serverFactory.getZooKeeperServer().getZKDatabase(), this.serverFactory.getZooKeeperServer().firstProcessor, 1, 100){

            protected long getElapsed(DataNode node) {
                return fakeElapsed.get();
            }
        };
    }
}

