/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.security.Principal;
import java.time.Duration;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.zookeeper.Login;
import org.apache.zookeeper.common.ZKConfig;
import org.apache.zookeeper.server.quorum.auth.KerberosTestUtils;
import org.apache.zookeeper.server.quorum.auth.MiniKdc;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosTicketRenewalTest {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosTicketRenewalTest.class);
    private static final String JAAS_CONFIG_SECTION = "ClientUsingKerberos";
    private static final String TICKET_LIFETIME = "5000";
    private static File testTempDir;
    private static MiniKdc kdc;
    private static File kdcWorkDir;
    private static String PRINCIPAL;
    TestableKerberosLogin login;

    @BeforeAll
    public static void setupClass() throws Exception {
        System.setProperty("zookeeper.kerberos.minReLoginTimeMs", "500");
        testTempDir = ClientBase.createTmpDir();
        KerberosTicketRenewalTest.startMiniKdcAndAddPrincipal();
        String keytabFilePath = FilenameUtils.normalize((String)KerberosTestUtils.getKeytabFile(), (boolean)true);
        String jaasEntries = "ClientUsingKerberos {\n  com.sun.security.auth.module.Krb5LoginModule required\n  storeKey=\"false\"\n  useTicketCache=\"false\"\n  useKeyTab=\"true\"\n  doNotPrompt=\"true\"\n  debug=\"true\"\n  refreshKrb5Config=\"true\"\n  keyTab=\"" + keytabFilePath + "\"\n  principal=\"" + PRINCIPAL + "\";\n};\n";
        KerberosTicketRenewalTest.setupJaasConfig(jaasEntries);
    }

    @AfterAll
    public static void tearDownClass() {
        System.clearProperty("zookeeper.kerberos.minReLoginTimeMs");
        System.clearProperty("java.security.auth.login.config");
        KerberosTicketRenewalTest.stopMiniKdc();
        if (testTempDir != null) {
            FileUtils.deleteQuietly((File)testTempDir);
        }
    }

    @AfterEach
    public void tearDownTest() throws Exception {
        if (this.login != null) {
            this.login.shutdown();
            this.login.logout();
        }
    }

    @Test
    public void shouldLoginUsingKerberos() throws Exception {
        this.login = new TestableKerberosLogin();
        this.login.startThreadIfNeeded();
        this.assertPrincipalLoggedIn();
    }

    @Test
    public void shouldRenewTicketUsingKerberos() throws Exception {
        this.login = new TestableKerberosLogin();
        this.login.startThreadIfNeeded();
        long initialLoginTime = this.login.getLastLogin();
        this.assertTicketRefreshHappenedUntil(Duration.ofSeconds(15L));
        this.assertPrincipalLoggedIn();
        Assertions.assertTrue((initialLoginTime < this.login.getLastLogin() ? 1 : 0) != 0);
    }

    @Test
    public void shouldRecoverIfKerberosNotAvailableForSomeTime() throws Exception {
        this.login = new TestableKerberosLogin();
        this.login.startThreadIfNeeded();
        this.assertTicketRefreshHappenedUntil(Duration.ofSeconds(15L));
        KerberosTicketRenewalTest.stopMiniKdc();
        this.login.assertRefreshFailsEventually(Duration.ofSeconds(15L));
        KerberosTicketRenewalTest.startMiniKdcAndAddPrincipal();
        this.login.continueWithRetryAfterFailedRefresh();
        this.assertTicketRefreshHappenedUntil(Duration.ofSeconds(15L));
        this.assertPrincipalLoggedIn();
    }

    private void assertPrincipalLoggedIn() {
        Assertions.assertEquals((Object)PRINCIPAL, (Object)this.login.getUserName());
        Assertions.assertNotNull((Object)this.login.getSubject());
        Assertions.assertEquals((int)1, (int)this.login.getSubject().getPrincipals().size());
        Principal actualPrincipal = this.login.getSubject().getPrincipals().iterator().next();
        Assertions.assertEquals((Object)PRINCIPAL, (Object)actualPrincipal.getName());
    }

    private void assertTicketRefreshHappenedUntil(Duration timeout) {
        long lastLoginTime = this.login.getLastLogin();
        KerberosTicketRenewalTest.assertEventually(timeout, () -> this.login.getLastLogin() != lastLoginTime && this.login.getSubject() != null && !this.login.getSubject().getPrincipals().isEmpty());
    }

    private static void assertEventually(Duration timeout, Supplier<Boolean> test) {
        Assertions.assertTimeout((Duration)timeout, () -> {
            while (!((Boolean)test.get()).booleanValue()) {
                Thread.sleep(100L);
            }
            return;
        });
    }

    public static void startMiniKdcAndAddPrincipal() throws Exception {
        kdcWorkDir = KerberosTicketRenewalTest.createTmpDirInside(testTempDir);
        Properties conf = MiniKdc.createConf();
        conf.setProperty("max.ticket.lifetime", TICKET_LIFETIME);
        conf.setProperty("min.ticket.lifetime", TICKET_LIFETIME);
        kdc = new MiniKdc(conf, kdcWorkDir);
        kdc.start();
        String principalName = PRINCIPAL.substring(0, PRINCIPAL.lastIndexOf("@"));
        kdc.createPrincipal(new File(KerberosTestUtils.getKeytabFile()), principalName);
    }

    private static void stopMiniKdc() {
        if (kdc != null) {
            kdc.stop();
            kdc = null;
        }
        if (kdcWorkDir != null) {
            FileUtils.deleteQuietly((File)kdcWorkDir);
            kdcWorkDir = null;
        }
    }

    private static File createTmpDirInside(File parentDir) throws IOException {
        File tmpFile = File.createTempFile("test", ".junit", parentDir);
        File tmpDir = new File(tmpFile + ".dir");
        Assertions.assertFalse((boolean)tmpDir.exists());
        Assertions.assertTrue((boolean)tmpDir.mkdirs());
        return tmpDir;
    }

    private static void setupJaasConfig(String jaasEntries) {
        try {
            File saslConfFile = new File(testTempDir, "jaas.conf");
            FileWriter fwriter = new FileWriter(saslConfFile);
            fwriter.write(jaasEntries);
            fwriter.close();
            System.setProperty("java.security.auth.login.config", saslConfFile.getAbsolutePath());
        }
        catch (IOException ioe) {
            LOG.error("Failed to initialize JAAS conf file", (Throwable)ioe);
        }
        Configuration.getConfiguration().refresh();
    }

    static {
        PRINCIPAL = KerberosTestUtils.getClientPrincipal();
    }

    private static class TestableKerberosLogin
    extends Login {
        private AtomicBoolean refreshFailed = new AtomicBoolean(false);
        private CountDownLatch continueRefreshThread = new CountDownLatch(1);

        public TestableKerberosLogin() throws LoginException {
            super(KerberosTicketRenewalTest.JAAS_CONFIG_SECTION, () -> callbacks -> {}, new ZKConfig());
        }

        protected void sleepBeforeRetryFailedRefresh() throws InterruptedException {
            LOG.info("sleep started due to failed refresh");
            this.refreshFailed.set(true);
            this.continueRefreshThread.await(20L, TimeUnit.SECONDS);
            LOG.info("sleep due to failed refresh finished");
        }

        public void assertRefreshFailsEventually(Duration timeout) {
            KerberosTicketRenewalTest.assertEventually(timeout, () -> this.refreshFailed.get());
        }

        public void continueWithRetryAfterFailedRefresh() {
            LOG.info("continue refresh thread");
            this.continueRefreshThread.countDown();
        }
    }
}

