/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.zookeeper.server.util.RateLimiter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RateLimiterTest {
    @Test
    public void testAllow_withinInterval() {
        int rate = 2;
        RateLimiter rateLimiter = new RateLimiter(2, 5L, TimeUnit.SECONDS);
        for (int i = 0; i < 2; ++i) {
            Assertions.assertTrue((boolean)rateLimiter.allow());
        }
        Assertions.assertFalse((boolean)rateLimiter.allow());
    }

    @Test
    public void testAllow_withinInterval_multiThreaded() {
        int rate = 10;
        RateLimiter rateLimiter = new RateLimiter(10, 5L, TimeUnit.SECONDS);
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(11);
        for (int i = 0; i < 10; ++i) {
            executor.execute(() -> Assertions.assertTrue((boolean)rateLimiter.allow()));
        }
        executor.execute(() -> Assertions.assertFalse((boolean)rateLimiter.allow()));
    }

    @Test
    public void testAllow_exceedInterval() throws Exception {
        boolean interval = true;
        RateLimiter rateLimiter = new RateLimiter(1, 1L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)rateLimiter.allow());
        Assertions.assertFalse((boolean)rateLimiter.allow());
        Thread.sleep(TimeUnit.SECONDS.toMillis(2L));
        Assertions.assertTrue((boolean)rateLimiter.allow());
    }
}

