/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.watch;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.watch.WatchesReport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class WatchesReportTest
extends ZKTestCase {
    private Map<Long, Set<String>> m;
    private WatchesReport r;

    @BeforeEach
    public void setUp() {
        this.m = new HashMap<Long, Set<String>>();
        HashSet<String> s = new HashSet<String>();
        s.add("path1a");
        s.add("path1b");
        this.m.put(1L, s);
        s = new HashSet();
        s.add("path2a");
        this.m.put(2L, s);
        this.r = new WatchesReport(this.m);
    }

    @Test
    public void testHasPaths() {
        Assertions.assertTrue((boolean)this.r.hasPaths(1L));
        Assertions.assertTrue((boolean)this.r.hasPaths(2L));
        Assertions.assertFalse((boolean)this.r.hasPaths(3L));
    }

    @Test
    public void testGetPaths() {
        Set s = this.r.getPaths(1L);
        Assertions.assertEquals((int)2, (int)s.size());
        Assertions.assertTrue((boolean)s.contains("path1a"));
        Assertions.assertTrue((boolean)s.contains("path1b"));
        s = this.r.getPaths(2L);
        Assertions.assertEquals((int)1, (int)s.size());
        Assertions.assertTrue((boolean)s.contains("path2a"));
        Assertions.assertNull((Object)this.r.getPaths(3L));
    }

    @Test
    public void testToMap() {
        Assertions.assertEquals(this.m, (Object)this.r.toMap());
    }
}

