/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.X509KeyManager;
import javax.net.ssl.X509TrustManager;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.common.BaseX509ParameterizedTestCase;
import org.apache.zookeeper.common.ClientX509Util;
import org.apache.zookeeper.common.KeyStoreFileType;
import org.apache.zookeeper.common.SecretUtilsTest;
import org.apache.zookeeper.common.X509Exception;
import org.apache.zookeeper.common.X509KeyType;
import org.apache.zookeeper.common.X509Util;
import org.apache.zookeeper.common.ZKConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class X509UtilTest
extends BaseX509ParameterizedTestCase {
    private X509Util x509Util;
    private static final String[] customCipherSuites = new String[]{"SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA", "SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA"};

    @Override
    public void init(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        super.init(caKeyType, certKeyType, keyPassword, paramIndex);
        try (ClientX509Util x509util = new ClientX509Util();){
            this.x509TestContext.setSystemProperties((X509Util)x509util, KeyStoreFileType.JKS, KeyStoreFileType.JKS);
        }
        System.setProperty("zookeeper.serverCnxnFactory", "org.apache.zookeeper.server.NettyServerCnxnFactory");
        System.setProperty("zookeeper.clientCnxnSocket", "org.apache.zookeeper.ClientCnxnSocketNetty");
        this.x509Util = new ClientX509Util();
    }

    @AfterEach
    public void cleanUp() {
        this.x509TestContext.clearSystemProperties(this.x509Util);
        System.clearProperty(this.x509Util.getSslOcspEnabledProperty());
        System.clearProperty(this.x509Util.getSslCrlEnabledProperty());
        System.clearProperty(this.x509Util.getCipherSuitesProperty());
        System.clearProperty(this.x509Util.getSslProtocolProperty());
        System.clearProperty(this.x509Util.getSslHandshakeDetectionTimeoutMillisProperty());
        System.clearProperty("com.sun.net.ssl.checkRevocation");
        System.clearProperty("com.sun.security.enableCRLDP");
        Security.setProperty("ocsp.enable", Boolean.FALSE.toString());
        Security.setProperty("com.sun.security.enableCRLDP", Boolean.FALSE.toString());
        System.clearProperty("zookeeper.serverCnxnFactory");
        System.clearProperty("zookeeper.clientCnxnSocket");
        this.x509Util.close();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    @Timeout(value=5L)
    public void testCreateSSLContextWithoutCustomProtocol(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        SSLContext sslContext = this.x509Util.getDefaultSSLContext();
        Assertions.assertEquals((Object)X509Util.DEFAULT_PROTOCOL, (Object)sslContext.getProtocol());
        List<String> supported = Arrays.asList(SSLContext.getDefault().getSupportedSSLParameters().getProtocols());
        if (supported.contains("TLSv1.3")) {
            Assertions.assertEquals((Object)"TLSv1.3", (Object)sslContext.getProtocol());
            List<String> protos = Arrays.asList(sslContext.getDefaultSSLParameters().getProtocols());
            Assertions.assertTrue((boolean)protos.contains("TLSv1.2"));
            Assertions.assertTrue((boolean)protos.contains("TLSv1.3"));
        } else {
            Assertions.assertEquals((Object)"TLSv1.2", (Object)sslContext.getProtocol());
            Assertions.assertArrayEquals((Object[])new String[]{"TLSv1.2"}, (Object[])sslContext.getDefaultSSLParameters().getProtocols());
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    @Timeout(value=5L)
    public void testCreateSSLContextWithCustomProtocol(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        String protocol = "TLSv1.1";
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        System.setProperty(this.x509Util.getSslProtocolProperty(), "TLSv1.1");
        SSLContext sslContext = this.x509Util.getDefaultSSLContext();
        Assertions.assertEquals((Object)"TLSv1.1", (Object)sslContext.getProtocol());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    @Timeout(value=5L)
    public void testCreateSSLContextWithoutKeyStoreLocation(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        System.clearProperty(this.x509Util.getSslKeystoreLocationProperty());
        this.x509Util.getDefaultSSLContext();
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    @Timeout(value=5L)
    public void testCreateSSLContextWithoutKeyStorePassword(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        Assertions.assertThrows(X509Exception.SSLContextException.class, () -> {
            if (!this.x509TestContext.isKeyStoreEncrypted()) {
                throw new X509Exception.SSLContextException("");
            }
            System.clearProperty(this.x509Util.getSslKeystorePasswdProperty());
            this.x509Util.getDefaultSSLContext();
        });
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    @Timeout(value=5L)
    public void testCreateSSLContext_withKeyStorePasswordFromFile(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        this.testCreateSSLContext_withPasswordFromFile(keyPassword, this.x509Util.getSslKeystorePasswdProperty(), this.x509Util.getSslKeystorePasswdPathProperty());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    @Timeout(value=5L)
    public void testCreateSSLContext_withTrustStorePasswordFromFile(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        this.testCreateSSLContext_withPasswordFromFile(keyPassword, this.x509Util.getSslTruststorePasswdProperty(), this.x509Util.getSslTruststorePasswdPathProperty());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    @Timeout(value=5L)
    public void testCreateSSLContext_withWrongKeyStorePasswordFromFile(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        this.testCreateSSLContext_withWrongPasswordFromFile(keyPassword, this.x509Util.getSslKeystorePasswdPathProperty());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    @Timeout(value=5L)
    public void testCreateSSLContext_withWrongTrustStorePasswordFromFile(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        this.testCreateSSLContext_withWrongPasswordFromFile(keyPassword, this.x509Util.getSslTruststorePasswdPathProperty());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    @Timeout(value=5L)
    public void testCreateSSLContextWithCustomCipherSuites(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        this.setCustomCipherSuites();
        SSLSocket sslSocket = this.x509Util.createSSLSocket();
        Assertions.assertArrayEquals((Object[])customCipherSuites, (Object[])sslSocket.getEnabledCipherSuites());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    @Timeout(value=5L)
    public void testCRLEnabled(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        System.setProperty(this.x509Util.getSslCrlEnabledProperty(), "true");
        this.x509Util.getDefaultSSLContext();
        Assertions.assertTrue((boolean)Boolean.valueOf(System.getProperty("com.sun.net.ssl.checkRevocation")));
        Assertions.assertTrue((boolean)Boolean.valueOf(System.getProperty("com.sun.security.enableCRLDP")));
        Assertions.assertFalse((boolean)Boolean.valueOf(Security.getProperty("ocsp.enable")));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    @Timeout(value=5L)
    public void testCRLDisabled(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        this.x509Util.getDefaultSSLContext();
        Assertions.assertFalse((boolean)Boolean.valueOf(System.getProperty("com.sun.net.ssl.checkRevocation")));
        Assertions.assertFalse((boolean)Boolean.valueOf(System.getProperty("com.sun.security.enableCRLDP")));
        Assertions.assertFalse((boolean)Boolean.valueOf(Security.getProperty("ocsp.enable")));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    @Timeout(value=5L)
    public void testOCSPEnabled(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        System.setProperty(this.x509Util.getSslOcspEnabledProperty(), "true");
        this.x509Util.getDefaultSSLContext();
        Assertions.assertTrue((boolean)Boolean.valueOf(System.getProperty("com.sun.net.ssl.checkRevocation")));
        Assertions.assertTrue((boolean)Boolean.valueOf(System.getProperty("com.sun.security.enableCRLDP")));
        Assertions.assertTrue((boolean)Boolean.valueOf(Security.getProperty("ocsp.enable")));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    @Timeout(value=5L)
    public void testCreateSSLSocket(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        this.setCustomCipherSuites();
        SSLSocket sslSocket = this.x509Util.createSSLSocket();
        Assertions.assertArrayEquals((Object[])customCipherSuites, (Object[])sslSocket.getEnabledCipherSuites());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    @Timeout(value=5L)
    public void testCreateSSLServerSocketWithoutPort(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        this.setCustomCipherSuites();
        SSLServerSocket sslServerSocket = this.x509Util.createSSLServerSocket();
        Assertions.assertArrayEquals((Object[])customCipherSuites, (Object[])sslServerSocket.getEnabledCipherSuites());
        Assertions.assertTrue((boolean)sslServerSocket.getNeedClientAuth());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    @Timeout(value=5L)
    public void testCreateSSLServerSocketWithPort(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        this.setCustomCipherSuites();
        int port = PortAssignment.unique();
        SSLServerSocket sslServerSocket = this.x509Util.createSSLServerSocket(port);
        Assertions.assertEquals((int)sslServerSocket.getLocalPort(), (int)port);
        Assertions.assertArrayEquals((Object[])customCipherSuites, (Object[])sslServerSocket.getEnabledCipherSuites());
        Assertions.assertTrue((boolean)sslServerSocket.getNeedClientAuth());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadPEMKeyStore(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        X509KeyManager km = X509Util.createKeyManager((String)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PEM).getAbsolutePath(), (String)this.x509TestContext.getKeyStorePassword(), (String)KeyStoreFileType.PEM.getPropertyValue());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadPEMKeyStoreNullPassword(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        if (!this.x509TestContext.getKeyStorePassword().isEmpty()) {
            return;
        }
        X509KeyManager km = X509Util.createKeyManager((String)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PEM).getAbsolutePath(), null, (String)KeyStoreFileType.PEM.getPropertyValue());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadPEMKeyStoreAutodetectStoreFileType(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        X509KeyManager km = X509Util.createKeyManager((String)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PEM).getAbsolutePath(), (String)this.x509TestContext.getKeyStorePassword(), null);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadPEMKeyStoreWithWrongPassword(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        Assertions.assertThrows(X509Exception.KeyManagerException.class, () -> {
            X509KeyManager km = X509Util.createKeyManager((String)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PEM).getAbsolutePath(), (String)"wrong password", (String)KeyStoreFileType.PEM.getPropertyValue());
        });
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadPEMTrustStore(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        X509TrustManager tm = X509Util.createTrustManager((String)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PEM).getAbsolutePath(), (String)this.x509TestContext.getTrustStorePassword(), (String)KeyStoreFileType.PEM.getPropertyValue(), (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)false);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadPEMTrustStoreNullPassword(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        if (!this.x509TestContext.getTrustStorePassword().isEmpty()) {
            return;
        }
        X509TrustManager tm = X509Util.createTrustManager((String)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PEM).getAbsolutePath(), null, (String)KeyStoreFileType.PEM.getPropertyValue(), (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)false);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadPEMTrustStoreAutodetectStoreFileType(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        X509TrustManager tm = X509Util.createTrustManager((String)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PEM).getAbsolutePath(), (String)this.x509TestContext.getTrustStorePassword(), null, (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)false);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadJKSKeyStore(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        X509KeyManager km = X509Util.createKeyManager((String)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.JKS).getAbsolutePath(), (String)this.x509TestContext.getKeyStorePassword(), (String)KeyStoreFileType.JKS.getPropertyValue());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadJKSKeyStoreNullPassword(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        if (!this.x509TestContext.getKeyStorePassword().isEmpty()) {
            return;
        }
        X509KeyManager km = X509Util.createKeyManager((String)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.JKS).getAbsolutePath(), null, (String)KeyStoreFileType.JKS.getPropertyValue());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadJKSKeyStoreAutodetectStoreFileType(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        X509KeyManager km = X509Util.createKeyManager((String)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.JKS).getAbsolutePath(), (String)this.x509TestContext.getKeyStorePassword(), null);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadJKSKeyStoreWithWrongPassword(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        Assertions.assertThrows(X509Exception.KeyManagerException.class, () -> {
            X509KeyManager km = X509Util.createKeyManager((String)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.JKS).getAbsolutePath(), (String)"wrong password", (String)KeyStoreFileType.JKS.getPropertyValue());
        });
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadJKSTrustStore(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        X509TrustManager tm = X509Util.createTrustManager((String)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.JKS).getAbsolutePath(), (String)this.x509TestContext.getTrustStorePassword(), (String)KeyStoreFileType.JKS.getPropertyValue(), (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)false);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadJKSTrustStoreNullPassword(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        if (!this.x509TestContext.getTrustStorePassword().isEmpty()) {
            return;
        }
        X509TrustManager tm = X509Util.createTrustManager((String)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.JKS).getAbsolutePath(), null, (String)KeyStoreFileType.JKS.getPropertyValue(), (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)false);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadJKSTrustStoreAutodetectStoreFileType(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        X509TrustManager tm = X509Util.createTrustManager((String)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.JKS).getAbsolutePath(), (String)this.x509TestContext.getTrustStorePassword(), null, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)false);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadJKSTrustStoreWithWrongPassword(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        Assertions.assertThrows(X509Exception.TrustManagerException.class, () -> {
            X509TrustManager tm = X509Util.createTrustManager((String)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.JKS).getAbsolutePath(), (String)"wrong password", (String)KeyStoreFileType.JKS.getPropertyValue(), (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)false);
        });
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadPKCS12KeyStore(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        X509KeyManager km = X509Util.createKeyManager((String)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath(), (String)this.x509TestContext.getKeyStorePassword(), (String)KeyStoreFileType.PKCS12.getPropertyValue());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadPKCS12KeyStoreNullPassword(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        if (!this.x509TestContext.getKeyStorePassword().isEmpty()) {
            return;
        }
        X509KeyManager km = X509Util.createKeyManager((String)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath(), null, (String)KeyStoreFileType.PKCS12.getPropertyValue());
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadPKCS12KeyStoreAutodetectStoreFileType(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        X509KeyManager km = X509Util.createKeyManager((String)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath(), (String)this.x509TestContext.getKeyStorePassword(), null);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadPKCS12KeyStoreWithWrongPassword(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        Assertions.assertThrows(X509Exception.KeyManagerException.class, () -> {
            X509KeyManager km = X509Util.createKeyManager((String)this.x509TestContext.getKeyStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath(), (String)"wrong password", (String)KeyStoreFileType.PKCS12.getPropertyValue());
        });
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadPKCS12TrustStore(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        X509TrustManager tm = X509Util.createTrustManager((String)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath(), (String)this.x509TestContext.getTrustStorePassword(), (String)KeyStoreFileType.PKCS12.getPropertyValue(), (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)false);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadPKCS12TrustStoreNullPassword(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        if (!this.x509TestContext.getTrustStorePassword().isEmpty()) {
            return;
        }
        X509TrustManager tm = X509Util.createTrustManager((String)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath(), null, (String)KeyStoreFileType.PKCS12.getPropertyValue(), (boolean)false, (boolean)false, (boolean)true, (boolean)true, (boolean)false);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadPKCS12TrustStoreAutodetectStoreFileType(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        X509TrustManager tm = X509Util.createTrustManager((String)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath(), (String)this.x509TestContext.getTrustStorePassword(), null, (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)false);
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testLoadPKCS12TrustStoreWithWrongPassword(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        Assertions.assertThrows(X509Exception.TrustManagerException.class, () -> {
            X509TrustManager tm = X509Util.createTrustManager((String)this.x509TestContext.getTrustStoreFile(KeyStoreFileType.PKCS12).getAbsolutePath(), (String)"wrong password", (String)KeyStoreFileType.PKCS12.getPropertyValue(), (boolean)true, (boolean)true, (boolean)true, (boolean)true, (boolean)false);
        });
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testGetSslHandshakeDetectionTimeoutMillisProperty(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        Assertions.assertEquals((int)5000, (int)this.x509Util.getSslHandshakeTimeoutMillis());
        String newPropertyString = Integer.toString(5001);
        System.setProperty(this.x509Util.getSslHandshakeDetectionTimeoutMillisProperty(), newPropertyString);
        try (ClientX509Util tempX509Util = new ClientX509Util();){
            Assertions.assertEquals((int)5001, (int)tempX509Util.getSslHandshakeTimeoutMillis());
        }
        System.setProperty(this.x509Util.getSslHandshakeDetectionTimeoutMillisProperty(), "0");
        tempX509Util = new ClientX509Util();
        try {
            Assertions.assertEquals((int)5000, (int)tempX509Util.getSslHandshakeTimeoutMillis());
        }
        finally {
            tempX509Util.close();
        }
        System.setProperty(this.x509Util.getSslHandshakeDetectionTimeoutMillisProperty(), "-1");
        tempX509Util = new ClientX509Util();
        try {
            Assertions.assertEquals((int)5000, (int)tempX509Util.getSslHandshakeTimeoutMillis());
        }
        finally {
            tempX509Util.close();
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testCreateSSLContext_invalidCustomSSLContextClass(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        Assertions.assertThrows(X509Exception.SSLContextException.class, () -> {
            ZKConfig zkConfig = new ZKConfig();
            ClientX509Util clientX509Util = new ClientX509Util();
            zkConfig.setProperty(clientX509Util.getSslContextSupplierClassProperty(), String.class.getCanonicalName());
            clientX509Util.createSSLContext(zkConfig);
        });
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testCreateSSLContext_validCustomSSLContextClass(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        ZKConfig zkConfig = new ZKConfig();
        ClientX509Util clientX509Util = new ClientX509Util();
        zkConfig.setProperty(clientX509Util.getSslContextSupplierClassProperty(), SslContextSupplier.class.getName());
        SSLContext sslContext = clientX509Util.createSSLContext(zkConfig);
        Assertions.assertEquals((Object)SSLContext.getDefault(), (Object)sslContext);
    }

    private static void forceClose(Socket s) {
        if (s == null || s.isClosed()) {
            return;
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void forceClose(ServerSocket s) {
        if (s == null || s.isClosed()) {
            return;
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testClientRenegotiationFails(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Throwable {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        Assertions.assertThrows(SSLHandshakeException.class, () -> {
            int port = PortAssignment.unique();
            ExecutorService workerPool = Executors.newCachedThreadPool();
            final SSLServerSocket listeningSocket = this.x509Util.createSSLServerSocket();
            SSLSocket clientSocket = null;
            SSLSocket serverSocket = null;
            final AtomicInteger handshakesCompleted = new AtomicInteger(0);
            final CountDownLatch handshakeCompleted = new CountDownLatch(1);
            try {
                InetSocketAddress localServerAddress = new InetSocketAddress(InetAddress.getLoopbackAddress(), port);
                listeningSocket.bind(localServerAddress);
                Future<SSLSocket> acceptFuture = workerPool.submit(new Callable<SSLSocket>(){

                    @Override
                    public SSLSocket call() throws Exception {
                        SSLSocket sslSocket = (SSLSocket)listeningSocket.accept();
                        sslSocket.setEnabledProtocols(new String[]{"TLSv1.2"});
                        sslSocket.addHandshakeCompletedListener(new HandshakeCompletedListener(){

                            @Override
                            public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
                                handshakesCompleted.getAndIncrement();
                                handshakeCompleted.countDown();
                            }
                        });
                        Assertions.assertEquals((int)1, (int)sslSocket.getInputStream().read());
                        try {
                            sslSocket.getInputStream().read();
                            return sslSocket;
                        }
                        catch (Exception e) {
                            X509UtilTest.forceClose(sslSocket);
                            throw e;
                        }
                    }
                });
                clientSocket = this.x509Util.createSSLSocket();
                clientSocket.connect(localServerAddress);
                clientSocket.getOutputStream().write(1);
                clientSocket.startHandshake();
                clientSocket.getOutputStream().write(1);
                try {
                    serverSocket = acceptFuture.get();
                }
                catch (ExecutionException e) {
                    throw e.getCause();
                }
            }
            catch (Throwable throwable) {
                X509UtilTest.forceClose(serverSocket);
                X509UtilTest.forceClose(clientSocket);
                X509UtilTest.forceClose(listeningSocket);
                workerPool.shutdown();
                handshakeCompleted.await(5L, TimeUnit.SECONDS);
                Assertions.assertEquals((int)1, (int)handshakesCompleted.get());
                throw throwable;
            }
            X509UtilTest.forceClose(serverSocket);
            X509UtilTest.forceClose(clientSocket);
            X509UtilTest.forceClose(listeningSocket);
            workerPool.shutdown();
            handshakeCompleted.await(5L, TimeUnit.SECONDS);
            Assertions.assertEquals((int)1, (int)handshakesCompleted.get());
        });
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testGetDefaultCipherSuitesJava8(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        String[] cipherSuites = X509Util.getDefaultCipherSuitesForJavaVersion((String)"1.8");
        Assertions.assertTrue((boolean)cipherSuites[0].contains("CBC"));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testGetDefaultCipherSuitesJava9(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        String[] cipherSuites = X509Util.getDefaultCipherSuitesForJavaVersion((String)"9");
        Assertions.assertTrue((boolean)cipherSuites[0].contains("GCM"));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testGetDefaultCipherSuitesJava10(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        String[] cipherSuites = X509Util.getDefaultCipherSuitesForJavaVersion((String)"10");
        Assertions.assertTrue((boolean)cipherSuites[0].contains("GCM"));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testGetDefaultCipherSuitesJava11(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        String[] cipherSuites = X509Util.getDefaultCipherSuitesForJavaVersion((String)"11");
        Assertions.assertTrue((boolean)cipherSuites[0].contains("GCM"));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testGetDefaultCipherSuitesUnknownVersion(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        String[] cipherSuites = X509Util.getDefaultCipherSuitesForJavaVersion((String)"notaversion");
        Assertions.assertTrue((boolean)cipherSuites[0].contains("CBC"));
    }

    @ParameterizedTest
    @MethodSource(value={"data"})
    public void testGetDefaultCipherSuitesNullVersion(X509KeyType caKeyType, X509KeyType certKeyType, String keyPassword, Integer paramIndex) throws Exception {
        this.init(caKeyType, certKeyType, keyPassword, paramIndex);
        Assertions.assertThrows(NullPointerException.class, () -> X509Util.getDefaultCipherSuitesForJavaVersion(null));
    }

    private void setCustomCipherSuites() {
        System.setProperty(this.x509Util.getCipherSuitesProperty(), customCipherSuites[0] + "," + customCipherSuites[1]);
        this.x509Util.close();
        this.x509Util = new ClientX509Util();
    }

    private void testCreateSSLContext_withPasswordFromFile(String keyPassword, String propertyName, String pathPropertyName) throws Exception {
        Path secretFile = SecretUtilsTest.createSecretFile(keyPassword);
        System.clearProperty(propertyName);
        System.setProperty(pathPropertyName, secretFile.toString());
        this.x509Util.getDefaultSSLContext();
    }

    private void testCreateSSLContext_withWrongPasswordFromFile(String keyPassword, String pathPropertyName) throws Exception {
        Path secretFile = SecretUtilsTest.createSecretFile(keyPassword + "_wrong");
        Assertions.assertThrows(X509Exception.SSLContextException.class, () -> {
            System.setProperty(pathPropertyName, secretFile.toString());
            this.x509Util.getDefaultSSLContext();
        });
    }

    public static class SslContextSupplier
    implements Supplier<SSLContext> {
        @Override
        public SSLContext get() {
            try {
                return SSLContext.getDefault();
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

