/*
 * Decompiled with CFR 0.152.
 */
package org.inferred.freebuilder.processor;

import java.util.Optional;
import org.inferred.freebuilder.processor.BuilderFactory;
import org.inferred.freebuilder.processor.Datatype;
import org.inferred.freebuilder.processor.source.Scope;
import org.inferred.freebuilder.processor.source.SourceBuilder;
import org.inferred.freebuilder.processor.source.Variable;

public class Declarations {
    private static final String UPCAST_COMMENT = "// Upcast to access private fields; otherwise, oddly, we get an access violation.";

    public static Variable upcastToGeneratedBuilder(SourceBuilder code, Datatype datatype, String builder) {
        return code.scope().computeIfAbsent(Declaration.UPCAST, () -> {
            Variable base = new Variable("base");
            code.addLine(UPCAST_COMMENT, new Object[0]).addLine("%s %s = %s;", datatype.getGeneratedBuilder(), base, builder);
            return base;
        });
    }

    public static Optional<Variable> freshBuilder(SourceBuilder code, Datatype datatype) {
        if (!datatype.getBuilderFactory().isPresent()) {
            return Optional.empty();
        }
        return Optional.of(code.scope().computeIfAbsent(Declaration.FRESH_BUILDER, () -> {
            Variable defaults = new Variable("defaults");
            code.addLine("%s %s = %s;", datatype.getGeneratedBuilder(), defaults, datatype.getBuilderFactory().get().newBuilder(datatype.getBuilder(), BuilderFactory.TypeInference.INFERRED_TYPES));
            return defaults;
        }));
    }

    private Declarations() {
    }

    private static enum Declaration implements Scope.Key<Variable>
    {
        UPCAST,
        FRESH_BUILDER;


        @Override
        public Scope.Level level() {
            return Scope.Level.METHOD;
        }
    }
}

