/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.metrics.MetricsUtils;
import org.apache.zookeeper.server.ServerMetrics;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.QuorumUtil;
import org.hamcrest.Matcher;
import org.hamcrest.number.OrderingComparison;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LeaderMetricsTest
extends ZKTestCase {
    CountDownLatch createdLatch;
    int oldLoggingFeq;

    @Before
    public void setup() {
        this.oldLoggingFeq = Leader.getAckLoggingFrequency();
    }

    @After
    public void teardown() {
        Leader.setAckLoggingFrequency((int)this.oldLoggingFeq);
    }

    @Test
    public void testLeaderMetrics() throws Exception {
        Leader.setAckLoggingFrequency((int)1);
        ServerMetrics.getMetrics().resetAll();
        QuorumUtil util = new QuorumUtil(1);
        util.startAll();
        ZooKeeper zk = ClientBase.createZKClient(util.getConnString());
        this.createdLatch = new CountDownLatch(1);
        zk.exists("/test", (Watcher)new MyWatcher());
        zk.create("/test", new byte[2], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        this.createdLatch.await();
        Map<String, Object> values = MetricsUtils.currentServerMetrics();
        Assert.assertEquals((Object)2L, (Object)values.get("proposal_count"));
        Assert.assertEquals((Object)2L, (Object)values.get("cnt_quorum_ack_latency"));
        Assert.assertThat((Object)((Long)values.get("min_quorum_ack_latency")), (Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(0L)));
        int numberOfAckServers = 0;
        for (int sid = 1; sid <= 3; ++sid) {
            String metricName = "min_" + sid + "_ack_latency";
            if (values.get(metricName) == null) continue;
            ++numberOfAckServers;
            Assert.assertThat((Object)((Long)values.get("min_" + sid + "_ack_latency")), (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Long.valueOf(0L)));
        }
        Assert.assertThat((Object)numberOfAckServers, (Matcher)OrderingComparison.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
        zk.close();
        util.shutdownAll();
    }

    private class MyWatcher
    implements Watcher {
        private MyWatcher() {
        }

        public void process(WatchedEvent e) {
            LeaderMetricsTest.this.createdLatch.countDown();
        }
    }
}

