/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server.quorum;

import java.io.File;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.zookeeper.PortAssignment;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.server.quorum.FLELostMessageTest;
import org.apache.zookeeper.server.quorum.FLETestUtils;
import org.apache.zookeeper.server.quorum.QuorumCnxManager;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.test.ClientBase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLEBackwardElectionRoundTest
extends ZKTestCase {
    protected static final Logger LOG = LoggerFactory.getLogger(FLELostMessageTest.class);
    int count;
    Map<Long, QuorumPeer.QuorumServer> peers;
    File[] tmpdir;
    int[] port;
    QuorumCnxManager[] cnxManagers;

    @Before
    public void setUp() throws Exception {
        this.count = 3;
        this.peers = new HashMap<Long, QuorumPeer.QuorumServer>(this.count);
        this.tmpdir = new File[this.count];
        this.port = new int[this.count];
        this.cnxManagers = new QuorumCnxManager[this.count - 1];
    }

    @After
    public void tearDown() throws Exception {
        for (int i = 0; i < this.count - 1; ++i) {
            if (this.cnxManagers[i] == null) continue;
            this.cnxManagers[i].halt();
        }
    }

    @Test
    public void testBackwardElectionRound() throws Exception {
        LOG.info("TestLE: {}, {}", (Object)this.getTestName(), (Object)this.count);
        for (int i = 0; i < this.count; ++i) {
            int clientport = PortAssignment.unique();
            this.peers.put(Long.valueOf(i), new QuorumPeer.QuorumServer((long)i, new InetSocketAddress(clientport), new InetSocketAddress(PortAssignment.unique())));
            this.tmpdir[i] = ClientBase.createTmpDir();
            this.port[i] = clientport;
        }
        ByteBuffer initialMsg0 = this.getMsg();
        ByteBuffer initialMsg1 = this.getMsg();
        QuorumPeer peer = new QuorumPeer(this.peers, this.tmpdir[0], this.tmpdir[0], this.port[0], 3, 0L, 1000, 2, 2, 2);
        peer.startLeaderElection();
        FLETestUtils.LEThread thread = new FLETestUtils.LEThread(peer, 0);
        thread.start();
        QuorumPeer mockPeer = new QuorumPeer(this.peers, this.tmpdir[1], this.tmpdir[1], this.port[1], 3, 1L, 1000, 2, 2, 2);
        this.cnxManagers[0] = mockPeer.createCnxnManager();
        this.cnxManagers[0].listener.start();
        this.cnxManagers[0].toSend(Long.valueOf(0L), initialMsg0);
        mockPeer = new QuorumPeer(this.peers, this.tmpdir[2], this.tmpdir[2], this.port[2], 3, 2L, 1000, 2, 2, 2);
        this.cnxManagers[1] = mockPeer.createCnxnManager();
        this.cnxManagers[1].listener.start();
        this.cnxManagers[1].toSend(Long.valueOf(0L), initialMsg1);
        thread.join(5000L);
        thread = new FLETestUtils.LEThread(peer, 0);
        thread.start();
        this.cnxManagers[0].toSend(Long.valueOf(0L), initialMsg0);
        this.cnxManagers[1].toSend(Long.valueOf(0L), initialMsg1);
        thread.join(5000L);
        if (!thread.isAlive()) {
            Assert.fail((String)"Should not have joined");
        }
    }

    private ByteBuffer getMsg() {
        return FLETestUtils.createMsg(QuorumPeer.ServerState.FOLLOWING.ordinal(), 0L, 0L, 1L);
    }
}

